/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.spin.tools.Util;

public final class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    private FileUtils() {
    }

    public static boolean exists(String path) {
        return new File(path).exists();
    }

    public static String makePathString(String ... pathElements) {
        Util.guardNotNull(pathElements);
        if (pathElements.length == 0) {
            return "";
        }
        if (pathElements.length == 1) {
            return pathElements[0];
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < pathElements.length; ++i) {
            builder.append(pathElements[i]);
            if (i >= pathElements.length - 1) continue;
            builder.append(File.separatorChar);
        }
        return builder.toString();
    }

    public static String read(InputStream stream) throws IOException {
        return FileUtils.read(new InputStreamReader(stream));
    }

    public static String read(File filename) throws IOException {
        if (DEBUG) {
            log.debug((Object)("Reading contents from " + filename.getAbsolutePath()));
        }
        return FileUtils.read(new FileReader(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader reader) throws IOException {
        try {
            int len;
            StringBuilder contents = new StringBuilder();
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) > 0) {
                contents.append(buf, 0, len);
            }
            String string = contents.toString();
            return string;
        }
        finally {
            FileUtils.closeIgnoringException(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readAsList(File filename) throws IOException {
        if (DEBUG) {
            log.debug((Object)("Reading contents from " + filename.getAbsolutePath()));
        }
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        try {
            ArrayList<String> contents = new ArrayList<String>(100);
            while (reader.ready()) {
                contents.add(reader.readLine());
            }
            ArrayList<String> arrayList = contents;
            return arrayList;
        }
        finally {
            FileUtils.closeIgnoringException(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            if (((InputStream)in).available() > 0) {
                int len;
                if (!dest.exists() && !dest.createNewFile()) {
                    throw new IOException("Couldn't create '" + dest + "'");
                }
                out = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeIgnoringException(in);
            FileUtils.closeIgnoringException(out);
            throw throwable;
        }
        FileUtils.closeIgnoringException(in);
        FileUtils.closeIgnoringException(out);
    }

    private static final void closeIgnoringException(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.warn((Object)"Error closing resource: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File filename, String contents) throws IOException {
        if (DEBUG) {
            log.debug((Object)("Writing contents to " + filename.getAbsolutePath()));
        }
        PrintWriter output = null;
        try {
            output = new PrintWriter(new FileOutputStream(filename), false);
            output.write(contents);
        }
        catch (Throwable throwable) {
            FileUtils.closeIgnoringException(output);
            throw throwable;
        }
        FileUtils.closeIgnoringException(output);
    }
}

