/*
 * Decompiled with CFR 0.152.
 */
package org.spin.message;

import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.Signable;
import org.spin.tools.crypto.signature.Signature;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QueryInfo")
@XmlRootElement
public final class QueryInfo
implements Signable {
    @XmlElement(required=true)
    private String queryID;
    @XmlElement(required=true)
    private String peerGroup;
    @XmlElement(required=true)
    private String queryType;
    @XmlElement(required=false)
    private EndpointConfig aggregator;
    @XmlElement(required=false)
    private final List<CertID> routedByNodes = Util.makeArrayList();
    @XmlElement(required=true)
    private Identity identity;
    @XmlElement(required=true)
    private final Signature signature;

    public QueryInfo() {
        this(null, null, null);
    }

    protected QueryInfo(QueryInfo other) {
        this.queryID = other.queryID;
        this.peerGroup = other.peerGroup;
        this.queryType = other.queryType;
        this.aggregator = other.aggregator;
        this.routedByNodes.addAll(other.routedByNodes);
        this.identity = Identity.copyOf((Identity)other.identity);
        this.signature = other.signature;
    }

    public static final QueryInfo copyOf(QueryInfo other) {
        if (other == null) {
            return null;
        }
        return new QueryInfo(other);
    }

    public QueryInfo(String peerGroup, Identity identity, String queryType) {
        this.peerGroup = peerGroup;
        this.queryType = queryType;
        this.identity = identity;
        this.signature = null;
    }

    public QueryInfo(String peerGroup, Identity identity, String queryType, EndpointConfig aggregator) {
        this.peerGroup = peerGroup;
        this.queryType = queryType;
        this.identity = identity;
        this.aggregator = aggregator;
        this.signature = null;
    }

    public QueryInfo(String peerGroup, Identity identity, String queryType, String queryID) {
        this.peerGroup = peerGroup;
        this.queryType = queryType;
        this.identity = identity;
        this.queryID = queryID;
        this.signature = null;
    }

    private QueryInfo(String queryID, String peerGroup, String queryType, EndpointConfig aggregator, Identity identity, Signature signature) {
        this.queryID = queryID;
        this.peerGroup = peerGroup;
        this.queryType = queryType;
        this.aggregator = aggregator;
        this.identity = identity;
        this.signature = signature;
    }

    public final Signature getSignature() {
        return this.signature;
    }

    public final QueryInfo withRoutedByEntry(CertID routedBy) {
        QueryInfo result = QueryInfo.copyOf(this);
        result.routedByNodes.add(routedBy);
        return result;
    }

    public final QueryInfo withRoutedByNodes(Collection<CertID> routedBy) {
        QueryInfo result = QueryInfo.copyOf(this);
        result.routedByNodes.clear();
        result.routedByNodes.addAll(routedBy);
        return result;
    }

    public final QueryInfo withIdentity(Identity newIdentity) {
        return new QueryInfo(this.queryID, this.peerGroup, this.queryType, this.aggregator, newIdentity, this.signature);
    }

    public final QueryInfo withSignature(Signature newSignature) {
        return new QueryInfo(this.queryID, this.peerGroup, this.queryType, this.aggregator, this.identity, newSignature);
    }

    public final String getPeerGroup() {
        return this.peerGroup;
    }

    public final QueryInfo withPeerGroup(String newPeerGroup) {
        QueryInfo result = QueryInfo.copyOf(this);
        result.peerGroup = newPeerGroup;
        return result;
    }

    public final String getQueryID() {
        return this.queryID;
    }

    public final QueryInfo withQueryID(String newQueryID) {
        QueryInfo result = QueryInfo.copyOf(this);
        result.queryID = newQueryID;
        return result;
    }

    public final String getQueryType() {
        return this.queryType;
    }

    public final QueryInfo withQueryType(String newQueryType) {
        QueryInfo result = QueryInfo.copyOf(this);
        result.queryType = newQueryType;
        return result;
    }

    public final List<CertID> getRoutedByNodes() {
        return Util.makeArrayList(this.routedByNodes);
    }

    public final EndpointConfig getAggregator() {
        return this.aggregator;
    }

    public final QueryInfo withAggregator(EndpointConfig newAggregator) {
        QueryInfo result = QueryInfo.copyOf(this);
        result.aggregator = newAggregator;
        return result;
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregator == null ? 0 : this.aggregator.hashCode());
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        result = 31 * result + (this.peerGroup == null ? 0 : this.peerGroup.hashCode());
        result = 31 * result + (this.queryID == null ? 0 : this.queryID.hashCode());
        result = 31 * result + (this.queryType == null ? 0 : this.queryType.hashCode());
        result = 31 * result + (this.routedByNodes == null ? 0 : this.routedByNodes.hashCode());
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryInfo other = (QueryInfo)obj;
        if (this.aggregator == null ? other.aggregator != null : !this.aggregator.equals((Object)other.aggregator)) {
            return false;
        }
        if (this.identity == null ? other.identity != null : !this.identity.equals((Object)other.identity)) {
            return false;
        }
        if (this.peerGroup == null ? other.peerGroup != null : !this.peerGroup.equals(other.peerGroup)) {
            return false;
        }
        if (this.queryID == null ? other.queryID != null : !this.queryID.equals(other.queryID)) {
            return false;
        }
        if (this.queryType == null ? other.queryType != null : !this.queryType.equals(other.queryType)) {
            return false;
        }
        if (this.routedByNodes == null ? other.routedByNodes != null : !this.routedByNodes.equals(other.routedByNodes)) {
            return false;
        }
        return !(this.signature == null ? other.signature != null : !this.signature.equals((Object)other.signature));
    }

    public String toString() {
        return "QueryInfo [queryID=" + this.queryID + ", peerGroup=" + this.peerGroup + ", queryType=" + this.queryType + ", aggregator=" + this.aggregator + ", routedByNodes=" + this.routedByNodes + ", identity=" + this.identity + ", signature=" + this.signature + "]";
    }
}

