/*
 * Decompiled with CFR 0.152.
 */
package org.spin.message;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.message.EncryptionParams;
import org.spin.tools.crypto.signature.CertID;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QueryInput")
@XmlRootElement
public final class QueryInput {
    private final String criteria;
    private final EncryptionParams encryptionParams;

    public static final QueryInput noEncryptionRequested(String criteria) {
        return new QueryInput(criteria, EncryptionParams.NoEncryption);
    }

    public static final QueryInput encryptionRequested(String criteria, CertID encryptFor) {
        return new QueryInput(criteria, EncryptionParams.encryptFor(encryptFor));
    }

    public static final QueryInput of(String criteria, EncryptionParams encryptionParams) {
        return new QueryInput(criteria, encryptionParams);
    }

    private QueryInput() {
        this.criteria = null;
        this.encryptionParams = null;
    }

    private QueryInput(String criteria, EncryptionParams encryptionParams) {
        this.criteria = criteria;
        this.encryptionParams = encryptionParams;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public EncryptionParams getEncryptionParams() {
        return this.encryptionParams;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.criteria == null ? 0 : this.criteria.hashCode());
        result = 31 * result + (this.encryptionParams == null ? 0 : this.encryptionParams.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryInput other = (QueryInput)obj;
        if (this.criteria == null ? other.criteria != null : !this.criteria.equals(other.criteria)) {
            return false;
        }
        return !(this.encryptionParams == null ? other.encryptionParams != null : !this.encryptionParams.equals(other.encryptionParams));
    }

    public String toString() {
        return "QueryInput [criteria=" + this.criteria + ", encryptionParams=" + this.encryptionParams + "]";
    }
}

