/*
 * Decompiled with CFR 0.152.
 */
package org.spin.message;

import javax.xml.bind.annotation.XmlElement;
import org.spin.message.Failure;
import org.spin.message.HasOrigin;
import org.spin.message.Result;
import org.spin.tools.crypto.signature.CertID;

public abstract class Response
implements HasOrigin {
    @XmlElement
    protected final CertID origin;
    @XmlElement
    protected final String description;

    private Response() {
        this(null, null);
    }

    Response(CertID origin, String description) {
        this.origin = origin;
        this.description = description;
    }

    public abstract boolean isFailure();

    public final boolean isValid() {
        return !this.isFailure();
    }

    public boolean isEmpty() {
        return false;
    }

    @Override
    public final boolean isFor(CertID nodeId) {
        return this.origin.equals((Object)nodeId);
    }

    @Override
    public final CertID getOrigin() {
        return this.origin;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Result asResult() {
        return this.as(Result.class);
    }

    public final Failure asFailure() {
        return this.as(Failure.class);
    }

    private <T> T as(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Response other = (Response)obj;
        return !(this.origin == null ? other.origin != null : !this.origin.equals((Object)other.origin));
    }
}

