/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.connector;

import java.security.KeyStore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.spin.node.NodeException;
import org.spin.tools.ClassTools;
import org.spin.tools.crypto.PKITool;

public final class ConnectorUtils {
    private static final TLSClientParameters tlsParams = new TLSClientParameters();
    private static volatile boolean isTLSInitialized = false;
    private static final Lock setTlsParamsLock = new ReentrantLock();

    private ConnectorUtils() {
    }

    static final TLSClientParameters getTlsParams() {
        return tlsParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void initializeConduitForSSL() throws NodeException {
        block5: {
            setTlsParamsLock.lock();
            try {
                if (isTLSInitialized) break block5;
                PKITool pkiTool = PKITool.getInstance();
                KeyStore keyStore = pkiTool.getKeystore();
                char[] trustpass = pkiTool.getConfig().getPassword().toCharArray();
                tlsParams.setDisableCNCheck(true);
                tlsParams.setSecureSocketProtocol("TLS");
                try {
                    TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustFactory.init(keyStore);
                    TrustManager[] tm = trustFactory.getTrustManagers();
                    tlsParams.setTrustManagers(tm);
                    KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyFactory.init(keyStore, trustpass);
                    KeyManager[] km = keyFactory.getKeyManagers();
                    tlsParams.setKeyManagers(km);
                }
                catch (Exception e) {
                    throw new NodeException("Failed to initialize conduit for NodeConnector!", e);
                }
                isTLSInitialized = true;
            }
            finally {
                setTlsParamsLock.unlock();
            }
        }
    }

    static final <E extends Throwable> void rethrow(Class<E> exceptionClassToThrow, String message, Exception e) throws E {
        throw (Throwable)ClassTools.createInstance(exceptionClassToThrow, (Class[])Holder.ExceptionConstructorParamTypes, (Object[])new Object[]{message, e});
    }

    static final class Holder {
        private static final Class<?>[] ExceptionConstructorParamTypes = new Class[]{String.class, Throwable.class};

        private Holder() {
        }
    }
}

