/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.status;

import java.util.Map;
import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.NodeStatusInfo;
import org.spin.node.QueryActionInfo;
import org.spin.node.SpinNode;
import org.spin.node.connector.NodeConnector;

public final class NodeStatusUtil {
    private static final Logger log = Logger.getLogger(NodeStatusUtil.class);
    private final NodeStatusInfo status;
    private final String oldestEntry;
    private final String newestEntry;
    private final long ageOfOldest;
    private final long ageOfNewest;

    public NodeStatusUtil(String url) throws NodeException {
        this(NodeConnector.instance(url));
    }

    public NodeStatusUtil(SpinNode node) throws NodeException {
        this(NodeConnector.instance(node));
    }

    private NodeStatusUtil(NodeConnector connector) {
        this.status = connector.getNodeStatus();
        IDsAndAges idsAndAges = this.getOldestAndNewestCacheEntries();
        this.oldestEntry = idsAndAges.getTempOldestID();
        this.newestEntry = idsAndAges.getTempNewestID();
        this.ageOfOldest = idsAndAges.getTempOldestAge();
        this.ageOfNewest = idsAndAges.getTempNewestAge();
    }

    private IDsAndAges getOldestAndNewestCacheEntries() {
        if (this.status.getCacheInfo() == null) {
            return IDsAndAges.Null;
        }
        long tempOldestAge = 0L;
        long tempNewestAge = 0L;
        String tempOldestID = "";
        String tempNewestID = "";
        Map<String, Long> ageOfCacheEntries = this.status.getCacheInfo().getAgeOfEntries();
        for (Map.Entry<String, Long> entry : ageOfCacheEntries.entrySet()) {
            String queryID = entry.getKey();
            long age = entry.getValue();
            if (age > tempOldestAge) {
                tempOldestAge = age;
                tempOldestID = queryID;
                continue;
            }
            if (age >= tempNewestAge) continue;
            tempNewestAge = age;
            tempNewestID = queryID;
        }
        return new IDsAndAges(tempOldestAge, tempNewestAge, tempOldestID, tempNewestID);
    }

    public final boolean areQueriesOkay() {
        boolean queryStatus = true;
        for (QueryActionInfo queryActionInfo : this.status.getQueryActionInfos()) {
            if (queryActionInfo.isQueryReady()) continue;
            log.info((Object)("[NOT OK] " + queryActionInfo.getQueryType()));
            queryStatus = false;
        }
        return queryStatus && !this.status.getQueryActionInfos().isEmpty();
    }

    public final String getNodeStateName() {
        return this.status.getNodeState().name().toUpperCase();
    }

    public final boolean isOnline() {
        return this.getNodeState() == NodeStatusInfo.NodeStateTag.Online;
    }

    public final boolean isOffline() {
        return this.getNodeState() == NodeStatusInfo.NodeStateTag.Offline;
    }

    public final NodeStatusInfo.NodeStateTag getNodeState() {
        return this.status.getNodeState();
    }

    public final String getOldestEntry() {
        return this.oldestEntry;
    }

    public final String getNewestEntry() {
        return this.newestEntry;
    }

    public final long getAgeOfOldest() {
        return this.ageOfOldest;
    }

    public final long getAgeOfNewest() {
        return this.ageOfNewest;
    }

    public final int getNumEntriesInCache() {
        if (this.status.getCacheInfo() != null) {
            return this.status.getCacheInfo().getNumEntries();
        }
        return 0;
    }

    private static final class IDsAndAges {
        private final long tempOldestAge;
        private final long tempNewestAge;
        private final String tempOldestID;
        private final String tempNewestID;
        static final IDsAndAges Null = new IDsAndAges(0L, 0L, "", "");

        IDsAndAges(long tempOldestAge, long tempNewestAge, String tempOldestID, String tempNewestID) {
            this.tempOldestAge = tempOldestAge;
            this.tempNewestAge = tempNewestAge;
            this.tempOldestID = tempOldestID;
            this.tempNewestID = tempNewestID;
        }

        public long getTempOldestAge() {
            return this.tempOldestAge;
        }

        public long getTempNewestAge() {
            return this.tempNewestAge;
        }

        public String getTempOldestID() {
            return this.tempOldestID;
        }

        public String getTempNewestID() {
            return this.tempNewestID;
        }
    }
}

