/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfileTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListInstanceProfileTagsIterable
implements SdkIterable<ListInstanceProfileTagsResponse> {
    private final IamClient client;
    private final ListInstanceProfileTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceProfileTagsIterable(IamClient client, ListInstanceProfileTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInstanceProfileTagsResponseFetcher();
    }

    public Iterator<ListInstanceProfileTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListInstanceProfileTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInstanceProfileTagsResponseFetcher
    implements SyncPageFetcher<ListInstanceProfileTagsResponse> {
        private ListInstanceProfileTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceProfileTagsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListInstanceProfileTagsResponse nextPage(ListInstanceProfileTagsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceProfileTagsIterable.this.client.listInstanceProfileTags(ListInstanceProfileTagsIterable.this.firstRequest);
            }
            return ListInstanceProfileTagsIterable.this.client.listInstanceProfileTags((ListInstanceProfileTagsRequest)((Object)ListInstanceProfileTagsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

