/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.model.GetRoleResponse;
import software.amazon.awssdk.services.iam.model.GetUserRequest;
import software.amazon.awssdk.services.iam.model.GetUserResponse;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.waiters.IamWaiter;
import software.amazon.awssdk.services.iam.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultIamWaiter
implements IamWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final IamClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetInstanceProfileResponse> instanceProfileExistsWaiter;
    private final Waiter<GetUserResponse> userExistsWaiter;
    private final Waiter<GetRoleResponse> roleExistsWaiter;
    private final Waiter<GetPolicyResponse> policyExistsWaiter;

    private DefaultIamWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (IamClient)IamClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.instanceProfileExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetInstanceProfileResponse.class).acceptors(DefaultIamWaiter.instanceProfileExistsWaiterAcceptors())).overrideConfiguration(DefaultIamWaiter.instanceProfileExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.userExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetUserResponse.class).acceptors(DefaultIamWaiter.userExistsWaiterAcceptors())).overrideConfiguration(DefaultIamWaiter.userExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.roleExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRoleResponse.class).acceptors(DefaultIamWaiter.roleExistsWaiterAcceptors())).overrideConfiguration(DefaultIamWaiter.roleExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.policyExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetPolicyResponse.class).acceptors(DefaultIamWaiter.policyExistsWaiterAcceptors())).overrideConfiguration(DefaultIamWaiter.policyExistsWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetInstanceProfileResponse> waitUntilInstanceProfileExists(GetInstanceProfileRequest getInstanceProfileRequest) {
        return this.instanceProfileExistsWaiter.run(() -> this.client.getInstanceProfile(this.applyWaitersUserAgent(getInstanceProfileRequest)));
    }

    @Override
    public WaiterResponse<GetInstanceProfileResponse> waitUntilInstanceProfileExists(GetInstanceProfileRequest getInstanceProfileRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceProfileExistsWaiter.run(() -> this.client.getInstanceProfile(this.applyWaitersUserAgent(getInstanceProfileRequest)), DefaultIamWaiter.instanceProfileExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPolicyResponse> waitUntilPolicyExists(GetPolicyRequest getPolicyRequest) {
        return this.policyExistsWaiter.run(() -> this.client.getPolicy(this.applyWaitersUserAgent(getPolicyRequest)));
    }

    @Override
    public WaiterResponse<GetPolicyResponse> waitUntilPolicyExists(GetPolicyRequest getPolicyRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.policyExistsWaiter.run(() -> this.client.getPolicy(this.applyWaitersUserAgent(getPolicyRequest)), DefaultIamWaiter.policyExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRoleResponse> waitUntilRoleExists(GetRoleRequest getRoleRequest) {
        return this.roleExistsWaiter.run(() -> this.client.getRole(this.applyWaitersUserAgent(getRoleRequest)));
    }

    @Override
    public WaiterResponse<GetRoleResponse> waitUntilRoleExists(GetRoleRequest getRoleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.roleExistsWaiter.run(() -> this.client.getRole(this.applyWaitersUserAgent(getRoleRequest)), DefaultIamWaiter.roleExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetUserResponse> waitUntilUserExists(GetUserRequest getUserRequest) {
        return this.userExistsWaiter.run(() -> this.client.getUser(this.applyWaitersUserAgent(getUserRequest)));
    }

    @Override
    public WaiterResponse<GetUserResponse> waitUntilUserExists(GetUserRequest getUserRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.userExistsWaiter.run(() -> this.client.getUser(this.applyWaitersUserAgent(getUserRequest)), DefaultIamWaiter.userExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetInstanceProfileResponse>> instanceProfileExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetInstanceProfileResponse>> result = new ArrayList<WaiterAcceptor<? super GetInstanceProfileResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetUserResponse>> userExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetUserResponse>> result = new ArrayList<WaiterAcceptor<? super GetUserResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultIamWaiter.errorCode(error), "NoSuchEntity")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRoleResponse>> roleExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRoleResponse>> result = new ArrayList<WaiterAcceptor<? super GetRoleResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultIamWaiter.errorCode(error), "NoSuchEntity")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPolicyResponse>> policyExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPolicyResponse>> result = new ArrayList<WaiterAcceptor<? super GetPolicyResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultIamWaiter.errorCode(error), "NoSuchEntity")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration instanceProfileExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration userExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration roleExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration policyExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static IamWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends IamRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((IamRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements IamWaiter.Builder {
        private IamClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public IamWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public IamWaiter.Builder client(IamClient client) {
            this.client = client;
            return this;
        }

        @Override
        public IamWaiter build() {
            return new DefaultIamWaiter(this);
        }
    }
}

