/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import java.io.Serializable;
import net.shrine.crypto.ImproperlyConfiguredKeyStoreException;
import net.shrine.crypto.ImproperlyConfiguredKeyStoreProblem;
import net.shrine.crypto.InvalidSignatureFormatProblem;
import net.shrine.crypto.KeyStoreEntry;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.runtime.Nothing$;

public final class CryptoErrors$ {
    public static final CryptoErrors$ MODULE$ = new CryptoErrors$();

    public String comma(Iterable<KeyStoreEntry> entries) {
        return ((IterableOnceOps)entries.flatMap((Function1 & Serializable)x$1 -> x$1.aliases())).mkString(", ");
    }

    public final String NoPrivateKeyInStore() {
        return "Could not find a key in the KeyStore with a PrivateKey. Without one, SHRINE cannot sign messages.";
    }

    public final String CouldNotFindCa() {
        return "You must specify at least one ca cert alias corresponding to a PrivateKey entry for the Hub";
    }

    public final String CouldNotFindSigningCert() {
        return "There is no private entry signed by a public entry in the keystore corresponding to the Hub.";
    }

    public final String CouldNotFindCaAlias(Iterable<KeyStoreEntry> entries) {
        return new StringBuilder(62).append("Could not find a KeyStore Entry corresponding to the aliases '").append(this.comma(entries)).toString();
    }

    public final String NotSignedByCa(Iterable<KeyStoreEntry> entries, KeyStoreEntry caEntry) {
        return new StringBuilder(57).append("The private entries `").append(this.comma(entries)).append("` were not signed by the ca entry `").append((Object)caEntry.aliases().first()).append("`").toString();
    }

    public final String PrivateEntryIsCaEntry(Iterable<String> aliases) {
        return new StringBuilder(73).append("Your private cert must not also be your CA cert. Intersecting aliases: `").append(aliases.mkString(", ")).append("`").toString();
    }

    public final String ExpiredCertificates(Iterable<KeyStoreEntry> entries) {
        return new StringBuilder(43).append("The following certificates have expired: `").append(this.comma(entries)).append("`").toString();
    }

    public Nothing$ noKeyError(KeyStoreEntry myEntry) {
        IllegalArgumentException illegalEntry = new IllegalArgumentException(new StringBuilder(55).append("The provided keystore entry ").append(myEntry).append(" did not have a private key").toString());
        ImproperlyConfiguredKeyStoreProblem problem = new ImproperlyConfiguredKeyStoreProblem((Option<Throwable>)new Some((Object)illegalEntry), new StringBuilder(158).append("The KeyStore entry identified as the signing cert for this node did not provide a private key to sign with.").append(" Please check the KeyStore entry with the alias `").append((Object)myEntry.aliases().first()).append("`.").toString());
        throw (Throwable)problem.throwable().get();
    }

    public Nothing$ invalidSignatureFormat(byte[] bytes) {
        IllegalArgumentException illegalSignature = new IllegalArgumentException("Given a signature with bytes that are not valid CMSSignedData");
        InvalidSignatureFormatProblem problem = new InvalidSignatureFormatProblem(bytes, (Option<Throwable>)new Some((Object)illegalSignature));
        throw (Throwable)problem.throwable().get();
    }

    public ImproperlyConfiguredKeyStoreProblem configureError(String description) {
        return new ImproperlyConfiguredKeyStoreProblem((Option<Throwable>)new Some((Object)new ImproperlyConfiguredKeyStoreException(description)), description);
    }

    private CryptoErrors$() {
    }
}

