/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermAutomatonQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.RunAutomaton;

class TermAutomatonScorer
extends Scorer {
    private final TermAutomatonQuery.EnumAndScorer[] subs;
    private final TermAutomatonQuery.EnumAndScorer[] subsOnDoc;
    private final PriorityQueue<TermAutomatonQuery.EnumAndScorer> docIDQueue;
    private final PriorityQueue<TermAutomatonQuery.EnumAndScorer> posQueue;
    private final RunAutomaton runAutomaton;
    private final Map<Integer, BytesRef> idToTerm;
    private PosState[] positions;
    int posShift;
    private final int anyTermID;
    private final LeafSimScorer docScorer;
    private int numSubsOnDoc;
    private final long cost;
    private int docID = -1;
    private int freq;

    public TermAutomatonScorer(TermAutomatonQuery.TermAutomatonWeight weight, TermAutomatonQuery.EnumAndScorer[] subs, int anyTermID, Map<Integer, BytesRef> idToTerm, LeafSimScorer docScorer) throws IOException {
        super((Weight)weight);
        this.runAutomaton = new TermRunAutomaton(weight.automaton, subs.length);
        this.docScorer = docScorer;
        this.idToTerm = idToTerm;
        this.subs = subs;
        this.docIDQueue = new DocIDQueue(subs.length);
        this.posQueue = new PositionQueue(subs.length);
        this.anyTermID = anyTermID;
        this.subsOnDoc = new TermAutomatonQuery.EnumAndScorer[subs.length];
        this.positions = new PosState[4];
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = new PosState();
        }
        long cost = 0L;
        for (TermAutomatonQuery.EnumAndScorer sub : subs) {
            if (sub == null) continue;
            cost += sub.posEnum.cost();
            this.subsOnDoc[this.numSubsOnDoc++] = sub;
        }
        this.cost = cost;
    }

    private void popCurrentDoc() {
        assert (this.numSubsOnDoc == 0);
        assert (this.docIDQueue.size() > 0);
        this.subsOnDoc[this.numSubsOnDoc++] = (TermAutomatonQuery.EnumAndScorer)this.docIDQueue.pop();
        this.docID = this.subsOnDoc[0].posEnum.docID();
        while (this.docIDQueue.size() > 0 && ((TermAutomatonQuery.EnumAndScorer)this.docIDQueue.top()).posEnum.docID() == this.docID) {
            this.subsOnDoc[this.numSubsOnDoc++] = (TermAutomatonQuery.EnumAndScorer)this.docIDQueue.pop();
        }
    }

    private void pushCurrentDoc() {
        for (int i = 0; i < this.numSubsOnDoc; ++i) {
            this.docIDQueue.add((Object)this.subsOnDoc[i]);
        }
        this.numSubsOnDoc = 0;
    }

    public DocIdSetIterator iterator() {
        return new DocIdSetIterator(){

            public int docID() {
                return TermAutomatonScorer.this.docID;
            }

            public long cost() {
                return TermAutomatonScorer.this.cost;
            }

            public int nextDoc() throws IOException {
                for (int i = 0; i < TermAutomatonScorer.this.numSubsOnDoc; ++i) {
                    TermAutomatonQuery.EnumAndScorer sub = TermAutomatonScorer.this.subsOnDoc[i];
                    if (sub.posEnum.nextDoc() == Integer.MAX_VALUE) continue;
                    sub.posLeft = sub.posEnum.freq() - 1;
                    sub.pos = sub.posEnum.nextPosition();
                }
                TermAutomatonScorer.this.pushCurrentDoc();
                return this.doNext();
            }

            public int advance(int target) throws IOException {
                if (TermAutomatonScorer.this.docIDQueue.size() > 0) {
                    TermAutomatonQuery.EnumAndScorer top = (TermAutomatonQuery.EnumAndScorer)TermAutomatonScorer.this.docIDQueue.top();
                    while (top.posEnum.docID() < target) {
                        if (top.posEnum.advance(target) != Integer.MAX_VALUE) {
                            top.posLeft = top.posEnum.freq() - 1;
                            top.pos = top.posEnum.nextPosition();
                        }
                        top = (TermAutomatonQuery.EnumAndScorer)TermAutomatonScorer.this.docIDQueue.updateTop();
                    }
                }
                for (int i = 0; i < TermAutomatonScorer.this.numSubsOnDoc; ++i) {
                    TermAutomatonQuery.EnumAndScorer sub = TermAutomatonScorer.this.subsOnDoc[i];
                    if (sub.posEnum.advance(target) == Integer.MAX_VALUE) continue;
                    sub.posLeft = sub.posEnum.freq() - 1;
                    sub.pos = sub.posEnum.nextPosition();
                }
                TermAutomatonScorer.this.pushCurrentDoc();
                return this.doNext();
            }

            private int doNext() throws IOException {
                assert (TermAutomatonScorer.this.numSubsOnDoc == 0);
                assert (((TermAutomatonQuery.EnumAndScorer)((TermAutomatonScorer)TermAutomatonScorer.this).docIDQueue.top()).posEnum.docID() > TermAutomatonScorer.this.docID);
                while (true) {
                    TermAutomatonScorer.this.popCurrentDoc();
                    if (TermAutomatonScorer.this.docID == Integer.MAX_VALUE) {
                        return TermAutomatonScorer.this.docID;
                    }
                    TermAutomatonScorer.this.countMatches();
                    if (TermAutomatonScorer.this.freq > 0) {
                        return TermAutomatonScorer.this.docID;
                    }
                    for (int i = 0; i < TermAutomatonScorer.this.numSubsOnDoc; ++i) {
                        TermAutomatonQuery.EnumAndScorer sub = TermAutomatonScorer.this.subsOnDoc[i];
                        if (sub.posEnum.nextDoc() == Integer.MAX_VALUE) continue;
                        sub.posLeft = sub.posEnum.freq() - 1;
                        sub.pos = sub.posEnum.nextPosition();
                    }
                    TermAutomatonScorer.this.pushCurrentDoc();
                }
            }
        };
    }

    private PosState getPosition(int pos) {
        return this.positions[pos - this.posShift];
    }

    private void shift(int pos) {
        int limit = pos - this.posShift;
        for (int i = 0; i < limit; ++i) {
            this.positions[i].count = 0;
        }
        this.posShift = pos;
    }

    private void countMatches() throws IOException {
        this.freq = 0;
        for (int i = 0; i < this.numSubsOnDoc; ++i) {
            this.posQueue.add((Object)this.subsOnDoc[i]);
        }
        int lastPos = -1;
        this.posShift = -1;
        while (this.posQueue.size() != 0) {
            PosState posState;
            TermAutomatonQuery.EnumAndScorer sub = (TermAutomatonQuery.EnumAndScorer)this.posQueue.pop();
            int pos = sub.pos;
            if (this.posShift == -1) {
                this.posShift = pos;
            }
            if (pos + 1 - this.posShift >= this.positions.length) {
                PosState[] newPositions = new PosState[ArrayUtil.oversize((int)(pos + 1 - this.posShift), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.positions, 0, newPositions, 0, this.positions.length);
                for (int i = this.positions.length; i < newPositions.length; ++i) {
                    newPositions[i] = new PosState();
                }
                this.positions = newPositions;
            }
            if (lastPos != -1 && this.anyTermID != -1) {
                int startLastPos = lastPos;
                while (lastPos < pos) {
                    posState = this.getPosition(lastPos);
                    if (posState.count == 0 && lastPos > startLastPos) {
                        lastPos = pos;
                        break;
                    }
                    PosState nextPosState = this.getPosition(lastPos + 1);
                    for (int i = 0; i < posState.count; ++i) {
                        int state = this.runAutomaton.step(posState.states[i], this.anyTermID);
                        if (state == -1) continue;
                        nextPosState.add(state);
                    }
                    ++lastPos;
                }
            }
            posState = this.getPosition(pos);
            PosState nextPosState = this.getPosition(pos + 1);
            if (posState.count == 0 && nextPosState.count == 0) {
                this.shift(pos);
                posState = this.getPosition(pos);
                nextPosState = this.getPosition(pos + 1);
            }
            for (int i = 0; i < posState.count; ++i) {
                int state = this.runAutomaton.step(posState.states[i], sub.termID);
                if (state == -1) continue;
                nextPosState.add(state);
                if (!this.runAutomaton.isAccept(state)) continue;
                ++this.freq;
            }
            int state = this.runAutomaton.step(0, sub.termID);
            if (state != -1) {
                nextPosState.add(state);
                if (this.runAutomaton.isAccept(state)) {
                    ++this.freq;
                }
            }
            if (sub.posLeft > 0) {
                sub.pos = sub.posEnum.nextPosition();
                --sub.posLeft;
                this.posQueue.add((Object)sub);
            }
            lastPos = pos;
        }
        int limit = lastPos + 1 - this.posShift;
        for (int i = 0; i <= limit; ++i) {
            this.positions[i].count = 0;
        }
    }

    public String toString() {
        return "TermAutomatonScorer(" + this.weight + ")";
    }

    public int docID() {
        return this.docID;
    }

    public float score() throws IOException {
        return this.docScorer.score(this.docID, (float)this.freq);
    }

    public float getMaxScore(int upTo) throws IOException {
        return this.docScorer.getSimScorer().score(Float.MAX_VALUE, 1L);
    }

    private static class PosState {
        int[] states = new int[2];
        int count;

        private PosState() {
        }

        public void add(int state) {
            if (this.states.length == this.count) {
                this.states = ArrayUtil.grow((int[])this.states);
            }
            this.states[this.count++] = state;
        }
    }

    static class TermRunAutomaton
    extends RunAutomaton {
        public TermRunAutomaton(Automaton a, int termCount) {
            super(a, termCount);
        }
    }

    private static class PositionQueue
    extends PriorityQueue<TermAutomatonQuery.EnumAndScorer> {
        public PositionQueue(int maxSize) {
            super(maxSize);
        }

        protected boolean lessThan(TermAutomatonQuery.EnumAndScorer a, TermAutomatonQuery.EnumAndScorer b) {
            return a.pos < b.pos;
        }
    }

    private static class DocIDQueue
    extends PriorityQueue<TermAutomatonQuery.EnumAndScorer> {
        public DocIDQueue(int maxSize) {
            super(maxSize);
        }

        protected boolean lessThan(TermAutomatonQuery.EnumAndScorer a, TermAutomatonQuery.EnumAndScorer b) {
            return a.posEnum.docID() < b.posEnum.docID();
        }
    }
}

