/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.effect.Timer;
import ch.qos.logback.classic.Logger;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import net.shrine.adapter.QueryQueuedTimeToLiveExceeded;
import net.shrine.adapter.QueryResultNotAvailable;
import net.shrine.adapter.ReadQueryResultAdapter;
import net.shrine.adapter.ReadQueryResultAdapter$;
import net.shrine.adapter.dao.QueryResultStatus;
import net.shrine.config.ConfigSource$;
import net.shrine.config.package$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.http4s.catsio.IOScheduler;
import net.shrine.http4s.catsio.IOScheduler$;
import net.shrine.hub.mom.ShrineMomClient$;
import net.shrine.log.Loggable;
import net.shrine.problem.JsonProblemDigest;
import net.shrine.problem.JsonProblemDigest$;
import net.shrine.problem.Problem;
import net.shrine.problem.RawProblem;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.AuthenticationInfo$;
import net.shrine.protocol.ErrorResponse;
import net.shrine.protocol.QueryResult;
import net.shrine.protocol.ReadInstanceResultsResponse;
import net.shrine.protocol.ReadQueryInstancesResponse;
import net.shrine.protocol.ReadQueryResultResponse;
import net.shrine.protocol.ResultOutputType;
import net.shrine.protocol.ResultOutputType$;
import net.shrine.protocol.ShrineResponse;
import net.shrine.protocol.version.DateStamp;
import net.shrine.protocol.version.DateStamp$;
import net.shrine.protocol.version.EnvelopeContents;
import net.shrine.protocol.version.EnvelopeContentsCompanion;
import net.shrine.protocol.version.Id;
import net.shrine.protocol.version.NodeKey$;
import net.shrine.protocol.version.QueryId;
import net.shrine.protocol.version.ResultStatus;
import net.shrine.protocol.version.ResultStatuses;
import net.shrine.protocol.version.v1.UpdateResult;
import net.shrine.protocol.version.v1.UpdateResult$;
import net.shrine.protocol.version.v1.UpdateResultWithError;
import net.shrine.protocol.version.v1.UpdateResultWithError$;
import net.shrine.protocol.version.v1.UpdateResultWithProgress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class QueuedQueriesPoller$
implements Loggable {
    public static QueuedQueriesPoller$ MODULE$;
    private ReadQueryResultAdapter readQueryResultAdapter;
    private final FiniteDuration queuedQueryTimeToLive;
    private final FiniteDuration queuedQueryRestTimeBeforePolling;
    private final FiniteDuration queuedQueryCrcPollHttpCallTimeout;
    private final FiniteDuration crcRunQueryTimeLimit;
    private final Timer<IO> timer;
    private final IOScheduler scheduler;
    private Logger net$shrine$log$Loggable$$internalLogger;
    private volatile byte bitmap$0;
    private volatile byte bitmap$init$0;

    static {
        new QueuedQueriesPoller$();
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        QueuedQueriesPoller$ queuedQueriesPoller$ = this;
        synchronized (queuedQueriesPoller$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.net$shrine$log$Loggable$$internalLogger$lzycompute() : this.net$shrine$log$Loggable$$internalLogger;
    }

    public FiniteDuration queuedQueryTimeToLive() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/adapter/service/src/main/scala/net/shrine/adapter/QueuedQueriesPoller.scala: 27");
        }
        return this.queuedQueryTimeToLive;
    }

    public FiniteDuration queuedQueryRestTimeBeforePolling() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/adapter/service/src/main/scala/net/shrine/adapter/QueuedQueriesPoller.scala: 29");
        }
        return this.queuedQueryRestTimeBeforePolling;
    }

    public FiniteDuration queuedQueryCrcPollHttpCallTimeout() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/adapter/service/src/main/scala/net/shrine/adapter/QueuedQueriesPoller.scala: 31");
        }
        return this.queuedQueryCrcPollHttpCallTimeout;
    }

    public FiniteDuration crcRunQueryTimeLimit() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/adapter/service/src/main/scala/net/shrine/adapter/QueuedQueriesPoller.scala: 33");
        }
        return this.crcRunQueryTimeLimit;
    }

    public Timer<IO> timer() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/adapter/service/src/main/scala/net/shrine/adapter/QueuedQueriesPoller.scala: 35");
        }
        return this.timer;
    }

    private IOScheduler scheduler() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/xml-data/build-dir/SHRINE-TRUNK-JOB1/adapter/service/src/main/scala/net/shrine/adapter/QueuedQueriesPoller.scala: 37");
        }
        return this.scheduler;
    }

    public IO<BoxedUnit> restart() {
        return this.scheduler().restart();
    }

    public IO<BoxedUnit> stop() {
        return this.scheduler().stop();
    }

    private ReadQueryResultAdapter readQueryResultAdapter$lzycompute() {
        QueuedQueriesPoller$ queuedQueriesPoller$ = this;
        synchronized (queuedQueriesPoller$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.readQueryResultAdapter = ReadQueryResultAdapter$.MODULE$.apply(ConfigSource$.MODULE$.config());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.readQueryResultAdapter;
    }

    public ReadQueryResultAdapter readQueryResultAdapter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.readQueryResultAdapter$lzycompute() : this.readQueryResultAdapter;
    }

    public IO<Object> checkForQueuedQueries() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting checkForQueuedQueries");
        IO<Seq<QueryResultStatus>> queuedQueriesIO = this.readQueryResultAdapter().selectQueuedQueryIds();
        IO oldEnoughIO = queuedQueriesIO.map((Function1 & Serializable & scala.Serializable)queuedQueries -> {
            MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Found ").append(queuedQueries.size()).append(" queries. ").append(queuedQueries.mkString(", ")).toString());
            long now = System.currentTimeMillis();
            return new Tuple2(queuedQueries.filter((Function1 & Serializable & scala.Serializable)queuedQuery -> BoxesRunTime.boxToBoolean((boolean)QueuedQueriesPoller$.$anonfun$checkForQueuedQueries$4(now, queuedQuery))), (Object)BoxesRunTime.boxToBoolean((boolean)queuedQueries.nonEmpty()));
        });
        return oldEnoughIO.flatMap((Function1 & Serializable & scala.Serializable)oldEnoughAndCheckAgain -> {
            Seq oldEnough = (Seq)oldEnoughAndCheckAgain._1();
            Seq oldQueryIds = (Seq)((SeqLike)oldEnough.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.networkQueryId()), Seq$.MODULE$.canBuildFrom())).distinct();
            Seq oldEnoughAndDistinct = (Seq)oldQueryIds.flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(oldEnough.collectFirst((PartialFunction)new scala.Serializable(BoxesRunTime.unboxToLong((Object)id)){
                public static final long serialVersionUID = 0L;
                private final long id$1;

                public final <A1 extends QueryResultStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1;
                    A1 A12 = x1;
                    Object object = A12 != null && (A1 = A12).networkQueryId() == this.id$1 ? A1 : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(QueryResultStatus x1) {
                    QueryResultStatus queryResultStatus;
                    QueryResultStatus queryResultStatus2 = x1;
                    boolean bl = queryResultStatus2 != null && (queryResultStatus = queryResultStatus2).networkQueryId() == this.id$1;
                    return bl;
                }
                {
                    this.id$1 = id$1;
                }
            })), Seq$.MODULE$.canBuildFrom());
            MODULE$.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Found ").append(oldEnoughAndDistinct.size()).append(" queries old enough to check. ").append(oldEnoughAndDistinct.mkString(", ")).toString());
            Seq askCrcIOs = (Seq)oldEnoughAndDistinct.map((Function1 & Serializable & scala.Serializable)queuedQuery -> {
                MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Will ask the CRC about query ").append(queuedQuery.networkQueryId()).toString());
                AuthenticationInfo auth = AuthenticationInfo$.MODULE$.noPassword(queuedQuery.username(), queuedQuery.domain());
                return MODULE$.readQueryResultAdapter().askCrc(queuedQuery.networkQueryId(), (Duration)MODULE$.queuedQueryCrcPollHttpCallTimeout(), auth).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.interpretAndMaybeSendAnUpdate((QueryResultStatus)queuedQuery, (Either<ErrorResponse, ShrineResponse>)x$2)).handleErrorWith((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Throwable throwable = x0$1;
                    Option option = NonFatal$.MODULE$.unapply(throwable);
                    if (option.isEmpty()) {
                        throw new MatchError((Object)throwable);
                    }
                    Throwable x = (Throwable)option.get();
                    IO iO = IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Caught exception in QueuedQueriesPoller while checking on query ").append(queuedQuery.networkQueryId()).toString(), x));
                    return iO;
                });
            }, Seq$.MODULE$.canBuildFrom());
            Seq itOfStreams = (Seq)askCrcIOs.map((Function1 & Serializable & scala.Serializable)fo -> new Stream(Stream$.MODULE$.eval((Object)fo)), Seq$.MODULE$.canBuildFrom());
            IO seqResultStatus = (IO)Stream$.MODULE$.compile$extension(((Stream)itOfStreams.foldLeft((Object)new Stream(Stream$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(soFar, next) -> new Stream(Stream$.MODULE$.append$extension(((Stream)soFar).fs2$Stream$$free(), (Function0 & Serializable & scala.Serializable)() -> new Stream(next))))).fs2$Stream$$free(), Stream.Compiler$.MODULE$.syncInstance((Sync)IO$.MODULE$.ioEffect())).drain();
            return seqResultStatus.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)oldEnoughAndCheckAgain._2$mcZ$sp()));
        }).handleErrorWith((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Throwable throwable = x0$2;
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (option.isEmpty()) {
                throw new MatchError((Object)throwable);
            }
            Throwable x = (Throwable)option.get();
            MODULE$.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught exception in QueuedQueriesPoller.checkForQueuedQueries", x);
            IO iO = IO$.MODULE$.raiseError(x);
            return iO;
        });
    }

    public IO<BoxedUnit> interpretAndMaybeSendAnUpdate(QueryResultStatus oldQueryResult, Either<ErrorResponse, ShrineResponse> crcResponse) {
        long queryId = oldQueryResult.networkQueryId();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(new QueryId(queryId)).append("'s response is ").append(crcResponse).toString());
        IO maybeUpdateFromCrcIO = (IO)crcResponse.fold((Function1 & Serializable & scala.Serializable)errorResponse -> MODULE$.readQueryResultAdapter().storeErrorFromShrine(oldQueryResult, errorResponse.problem()).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            None$ none$;
            Problem problem = errorResponse.problem();
            if (problem instanceof QueryResultNotAvailable) {
                QueryResultNotAvailable queryResultNotAvailable = (QueryResultNotAvailable)problem;
                MODULE$.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(141).append("Not reporting ").append((Object)queryResultNotAvailable).append(" to the hub. If it is recurring please set the status for this query to FINISHED in the shrine_query_history.QUERY_RESULT table").toString());
                none$ = None$.MODULE$;
            } else if (problem instanceof RawProblem) {
                RawProblem rawProblem = (RawProblem)problem;
                long x$1 = queryId;
                String x$2 = NodeKey$.MODULE$.localNodeKey();
                JsonProblemDigest x$3 = JsonProblemDigest$.MODULE$.apply(rawProblem);
                ResultStatuses.ErrorFromCrc$ x$42 = ResultStatuses.ErrorFromCrc$.MODULE$;
                Option x$5 = Option$.MODULE$.apply((Object)errorResponse.errorMessage());
                Option x$6 = Option$.MODULE$.apply((Object)new DateStamp(DateStamp$.MODULE$.now()));
                Option x$7 = UpdateResultWithError$.MODULE$.apply$default$6();
                none$ = new Some((Object)new UpdateResultWithError(x$1, x$2, x$3, (ResultStatus)x$42, x$5, x$7, x$6));
            } else {
                throw new IllegalStateException("Error response problems must be subclasses of RawProblem");
            }
            return none$;
        }), (Function1 & Serializable & scala.Serializable)shrineResponse -> {
            Option option;
            MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("interpretAndMaybeSendAnUpdate shrineResponse is ").append(shrineResponse).toString());
            ShrineResponse shrineResponse2 = shrineResponse;
            if (shrineResponse2 instanceof ReadQueryResultResponse) {
                ReadQueryResultResponse readQueryResultResponse = (ReadQueryResultResponse)shrineResponse2;
                UpdateResult updateResult = readQueryResultResponse.singleNodeResult().createUpdateResult(queryId, readQueryResultResponse.queryId(), (ResultOutputType)((QueryResult)readQueryResultResponse.results().head()).resultType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ResultOutputType$.MODULE$.PATIENT_COUNT_XML()));
                option = updateResult.status().isFinal() ? new Some((Object)updateResult) : None$.MODULE$;
            } else if (shrineResponse2 instanceof ReadInstanceResultsResponse) {
                None$ none$;
                ReadInstanceResultsResponse readInstanceResultsResponse = (ReadInstanceResultsResponse)shrineResponse2;
                UpdateResult updateResult = ((QueryResult)readInstanceResultsResponse.results().head()).createUpdateResult(queryId, ((QueryResult)readInstanceResultsResponse.results().head()).resultId(), (ResultOutputType)((QueryResult)readInstanceResultsResponse.results().head()).resultType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ResultOutputType$.MODULE$.PATIENT_COUNT_XML()));
                UpdateResult updateResult2 = updateResult;
                if (updateResult2 instanceof UpdateResultWithError) {
                    UpdateResultWithError updateResultWithError = (UpdateResultWithError)updateResult2;
                    MODULE$.readQueryResultAdapter().storeErrorFromShrine(oldQueryResult, (Problem)updateResultWithError.problem());
                    none$ = new Some((Object)updateResultWithError);
                } else {
                    none$ = None$.MODULE$;
                }
                option = none$;
            } else if (shrineResponse2 instanceof ReadQueryInstancesResponse) {
                ReadQueryInstancesResponse readQueryInstancesResponse = (ReadQueryInstancesResponse)shrineResponse2;
                Option maybeUpdateResult = readQueryInstancesResponse.createUpdateResult(queryId);
                maybeUpdateResult.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    IO<BoxedUnit> iO;
                    UpdateResult updateResult = x0$1;
                    if (updateResult instanceof UpdateResultWithError) {
                        UpdateResultWithError updateResultWithError = (UpdateResultWithError)updateResult;
                        iO = MODULE$.readQueryResultAdapter().storeErrorFromShrine(oldQueryResult, (Problem)updateResultWithError.problem());
                    } else {
                        iO = BoxedUnit.UNIT;
                    }
                    return iO;
                });
                option = maybeUpdateResult;
            } else {
                throw new IllegalArgumentException(new StringBuilder(24).append("Code does not handle a ").append(shrineResponse.getClass().getSimpleName()).append(" ").append(shrineResponse).toString());
            }
            Option maybeUpdateResult = option;
            return IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> maybeUpdateResult);
        });
        IO maybeUpdateIO = maybeUpdateFromCrcIO.map((Function1 & Serializable & scala.Serializable)maybeUpdateFromCrc -> (Option)maybeUpdateFromCrc.fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.maybeQueryTooOld(oldQueryResult), (Function1 & Serializable & scala.Serializable)x0$2 -> {
            Some some;
            UpdateResult updateResult = x0$2;
            if (updateResult instanceof UpdateResultWithProgress) {
                UpdateResultWithProgress updateResultWithProgress = (UpdateResultWithProgress)updateResult;
                some = MODULE$.maybeQueryTooOld(oldQueryResult).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)updateResultWithProgress));
            } else {
                some = new Some((Object)updateResult);
            }
            return some;
        }));
        return maybeUpdateIO.flatMap((Function1 & Serializable & scala.Serializable)maybeUpdate -> (IO)maybeUpdate.fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.unit(), (Function1 & Serializable & scala.Serializable)updateResult -> MODULE$.sendUpdateResultMessageIO((UpdateResult)updateResult)));
    }

    private Option<UpdateResult> maybeQueryTooOld(QueryResultStatus oldQueryResult) {
        None$ none$;
        long now = System.currentTimeMillis();
        if (now - oldQueryResult.timestamp().getTime() > this.queuedQueryTimeToLive().toMillis()) {
            long queryId = oldQueryResult.networkQueryId();
            QueryQueuedTimeToLiveExceeded problem = new QueryQueuedTimeToLiveExceeded(queryId, this.queuedQueryTimeToLive());
            this.readQueryResultAdapter().storeErrorFromShrine(oldQueryResult, (Problem)problem);
            long x$1 = queryId;
            String x$2 = NodeKey$.MODULE$.localNodeKey();
            JsonProblemDigest x$3 = JsonProblemDigest$.MODULE$.apply((RawProblem)problem);
            ResultStatuses.ErrorFromCrc$ x$4 = ResultStatuses.ErrorFromCrc$.MODULE$;
            Option x$5 = Option$.MODULE$.apply((Object)problem.description());
            Option x$6 = Option$.MODULE$.apply((Object)new DateStamp(DateStamp$.MODULE$.now()));
            Option x$7 = UpdateResultWithError$.MODULE$.apply$default$6();
            Some some = new Some((Object)new UpdateResultWithError(x$1, x$2, x$3, (ResultStatus)x$4, x$5, x$7, x$6));
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private IO<BoxedUnit> sendUpdateResultMessageIO(UpdateResult updateResult) {
        return ShrineMomClient$.MODULE$.sendToHubIO((Id)new QueryId(updateResult.queryId()), (EnvelopeContents)updateResult, (EnvelopeContentsCompanion)UpdateResult$.MODULE$, new StringBuilder(29).append(" updateResult for ").append(new QueryId(updateResult.queryId())).append(" to the hub").toString());
    }

    public static final /* synthetic */ boolean $anonfun$checkForQueuedQueries$4(long now$1, QueryResultStatus queuedQuery) {
        return now$1 - queuedQuery.timestamp().getTime() > MODULE$.queuedQueryRestTimeBeforePolling().toMillis() + MODULE$.crcRunQueryTimeLimit().toMillis();
    }

    private QueuedQueriesPoller$() {
        MODULE$ = this;
        Loggable.$init$((Loggable)this);
        this.queuedQueryTimeToLive = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.adapter.queuedQueryTimeToLive");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.queuedQueryRestTimeBeforePolling = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.adapter.queuedQueryRestTimeBeforePolling");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.queuedQueryCrcPollHttpCallTimeout = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.adapter.queuedQueryCrcPollHttpCallTimeout");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.crcRunQueryTimeLimit = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.adapter.crcRunQueryTimeLimit");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.timer = IO$.MODULE$.timer((ExecutionContext)ExecutionContexts$.MODULE$.crcExecutionContext());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.scheduler = IOScheduler$.MODULE$.scheduleWithFixedDelay(this.queuedQueryRestTimeBeforePolling(), this.queuedQueryRestTimeBeforePolling(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.checkForQueuedQueries(), "QueuedQueriesPoller", this.timer());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }
}

