/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import com.typesafe.config.Config;
import java.io.Serializable;
import net.shrine.adapter.AdapterComponents;
import net.shrine.adapter.Obfuscator;
import net.shrine.adapter.Obfuscator$;
import net.shrine.adapter.RunQueryAdapter;
import net.shrine.adapter.dao.AdapterDao;
import net.shrine.adapter.dao.squeryl.SquerylAdapterDao;
import net.shrine.adapter.dao.squeryl.SquerylI2b2AdminDao;
import net.shrine.adapter.dao.squeryl.tables.Tables;
import net.shrine.adapter.mappings.AdapterMappings;
import net.shrine.adapter.mappings.AdapterMappings$;
import net.shrine.adapter.service.I2b2AdminService;
import net.shrine.adapter.translators.ExpressionTranslator;
import net.shrine.adapter.translators.ExpressionTranslator$;
import net.shrine.adapter.translators.QueryDefinitionTranslator;
import net.shrine.config.package$;
import net.shrine.crypto.BouncyKeyStoreCollection;
import net.shrine.dao.squeryl.SquerylInitializer;
import net.shrine.http4s.client.legacy.EndpointConfig;
import net.shrine.http4s.client.legacy.EndpointConfig$;
import net.shrine.http4s.client.legacy.Poster;
import net.shrine.http4s.client.legacy.Poster$;
import net.shrine.log.Log$;
import net.shrine.protocol.HiveCredentials;
import net.shrine.protocol.ResultOutputType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.runtime.BoxesRunTime;

public final class AdapterComponents$
implements scala.Serializable {
    public static AdapterComponents$ MODULE$;

    static {
        new AdapterComponents$();
    }

    public AdapterComponents apply(Config adapterConfig, BouncyKeyStoreCollection certCollection, SquerylInitializer squerylInitializer, Set<ResultOutputType> breakdownTypes, HiveCredentials crcHiveCredentials, Poster pmPoster) {
        EndpointConfig crcEndpoint = (EndpointConfig)package$.MODULE$.ConfigExtensions(adapterConfig).getConfigured("crcEndpoint", (Function1 & Serializable & scala.Serializable)x$1 -> EndpointConfig$.MODULE$.apply(x$1));
        Poster crcPoster = Poster$.MODULE$.apply(certCollection, crcEndpoint);
        Tables squerylAdapterTables = new Tables();
        SquerylAdapterDao adapterDao = new SquerylAdapterDao(squerylInitializer, squerylAdapterTables, breakdownTypes);
        SquerylI2b2AdminDao i2b2AdminDao = new SquerylI2b2AdminDao(crcHiveCredentials.projectId(), squerylInitializer, squerylAdapterTables);
        String adapterMappingsFile = adapterConfig.getString("adapterMappingsFileName");
        AdapterMappings adapterMappings = AdapterMappings$.MODULE$.apply(adapterMappingsFile);
        ExpressionTranslator expressionTranslator = ExpressionTranslator$.MODULE$.apply(adapterMappings);
        QueryDefinitionTranslator queryDefinitionTranslator = new QueryDefinitionTranslator(expressionTranslator);
        boolean doObfuscation = adapterConfig.getBoolean("setSizeObfuscation");
        boolean collectAdapterAudit = adapterConfig.getBoolean("audit.collectAdapterAudit");
        Seq countsAndMilliseconds = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(adapterConfig.getConfig("botDefense").getConfigList("countsAndMilliseconds")).asScala();
        Seq botCountTimeThresholds = (Seq)countsAndMilliseconds.map((Function1 & Serializable & scala.Serializable)pairConfig -> new Tuple2((Object)BoxesRunTime.boxToLong((long)pairConfig.getLong("count")), (Object)new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(pairConfig.getLong("milliseconds"))).milliseconds()), Seq$.MODULE$.canBuildFrom());
        Obfuscator obfuscator = (Obfuscator)package$.MODULE$.ConfigExtensions(adapterConfig).getConfigured("obfuscation", (Function1 & Serializable & scala.Serializable)x$2 -> Obfuscator$.MODULE$.apply((Config)x$2));
        Log$.MODULE$.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("obfuscator is ").append(obfuscator).toString());
        RunQueryAdapter runQueryAdapter = new RunQueryAdapter(crcPoster, adapterDao, crcHiveCredentials, queryDefinitionTranslator, doObfuscation, adapterConfig.getBoolean("immediatelyRunIncomingQueries"), breakdownTypes, collectAdapterAudit, (Seq<Tuple2<Object, Duration>>)botCountTimeThresholds, obfuscator, (Duration)package$.MODULE$.ConfigExtensions(adapterConfig).get("crcRunQueryTimeLimit", (Function1 & Serializable & scala.Serializable)x$3 -> Duration$.MODULE$.apply(x$3)), certCollection);
        return new AdapterComponents(new I2b2AdminService(adapterDao, i2b2AdminDao, pmPoster, runQueryAdapter), adapterDao, adapterMappings, adapterMappings.lastModified());
    }

    public AdapterComponents apply(I2b2AdminService i2b2AdminService, AdapterDao adapterDao, AdapterMappings adapterMappings, long lastModified) {
        return new AdapterComponents(i2b2AdminService, adapterDao, adapterMappings, lastModified);
    }

    public Option<Tuple4<I2b2AdminService, AdapterDao, AdapterMappings, Object>> unapply(AdapterComponents x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.i2b2AdminService(), (Object)x$0.adapterDao(), (Object)x$0.adapterMappings(), (Object)BoxesRunTime.boxToLong((long)x$0.lastModified())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AdapterComponents$() {
        MODULE$ = this;
    }
}

