/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import cats.effect.Fiber;
import cats.effect.IO;
import cats.effect.IO$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.sql.SQLException;
import javax.xml.datatype.XMLGregorianCalendar;
import net.shrine.adapter.AdapterDatabaseProblem;
import net.shrine.adapter.AdapterMappingException;
import net.shrine.adapter.AdapterMappingProblem;
import net.shrine.adapter.CannotInterpretCrcBreakdownXml;
import net.shrine.adapter.CouldNotInterpretI2b2OutputTypesException;
import net.shrine.adapter.CouldNotInterpretQueryDefinitionException;
import net.shrine.adapter.CrcAdapter;
import net.shrine.adapter.CrcCouldNotBeInvoked;
import net.shrine.adapter.CrcInvocationException;
import net.shrine.adapter.ErrorFromCrcBreakdown;
import net.shrine.adapter.ExceptionWhileAttemptingToRunQuery;
import net.shrine.adapter.Obfuscator;
import net.shrine.adapter.QueuedQueriesPoller$;
import net.shrine.adapter.RunQueryAdapter$;
import net.shrine.adapter.audit.AdapterAuditDb$;
import net.shrine.adapter.dao.AdapterDao;
import net.shrine.adapter.translators.QueryDefinitionTranslator;
import net.shrine.crypto.BouncyKeyStoreCollection;
import net.shrine.crypto.SignatureNotVerifiedException;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.http4s.client.legacy.Poster;
import net.shrine.hub.mom.ShrineMomClient$;
import net.shrine.log.Log$;
import net.shrine.problem.AbstractProblem;
import net.shrine.problem.Problem;
import net.shrine.problem.ProblemNotYetEncoded$;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.AuthenticationInfo$;
import net.shrine.protocol.BaseShrineRequest;
import net.shrine.protocol.BaseShrineResponse;
import net.shrine.protocol.BroadcastMessage;
import net.shrine.protocol.Credential;
import net.shrine.protocol.ErrorFromCrcException;
import net.shrine.protocol.ErrorResponse;
import net.shrine.protocol.HiveCredentials;
import net.shrine.protocol.I2b2ResultEnvelope;
import net.shrine.protocol.MissingCrCXmlResultException;
import net.shrine.protocol.QueryResult;
import net.shrine.protocol.QueryResult$;
import net.shrine.protocol.RawCrcRunQueryResponse;
import net.shrine.protocol.RawCrcRunQueryResponse$;
import net.shrine.protocol.ReadResultRequest;
import net.shrine.protocol.ReadResultResponse;
import net.shrine.protocol.ReadResultResponse$;
import net.shrine.protocol.ResultOutputType;
import net.shrine.protocol.ResultOutputType$;
import net.shrine.protocol.RunQueryRequest;
import net.shrine.protocol.RunQueryRequest$;
import net.shrine.protocol.RunQueryResponse;
import net.shrine.protocol.ShrineRequest;
import net.shrine.protocol.ShrineResponse;
import net.shrine.protocol.XmlNodeName$;
import net.shrine.protocol.query.CouldNotMapAllTermsException;
import net.shrine.protocol.query.MappingException;
import net.shrine.protocol.query.QueryDefinition;
import net.shrine.protocol.query.QueryDefinition$;
import net.shrine.protocol.version.CouldNotVerifySignature;
import net.shrine.protocol.version.EnvelopeContents;
import net.shrine.protocol.version.EnvelopeContentsCompanion;
import net.shrine.protocol.version.Id;
import net.shrine.protocol.version.NodeKey;
import net.shrine.protocol.version.QueryId;
import net.shrine.protocol.version.ResultId;
import net.shrine.protocol.version.ResultStatus;
import net.shrine.protocol.version.ResultStatuses;
import net.shrine.protocol.version.v1.RunQueryForResult;
import net.shrine.protocol.version.v1.UpdateResult;
import net.shrine.protocol.version.v1.UpdateResult$;
import net.shrine.protocol.version.v1.UpdateResultWithError;
import net.shrine.protocol.version.v1.UpdateResultWithError$;
import net.shrine.protocol.version.v1.UpdateResultWithProgress;
import net.shrine.protocol.version.v1.UpdateResultWithProgress$;
import net.shrine.source.ConfigSource$;
import net.shrine.util.XmlDateHelper$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple12;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.NodeSeq;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\u0011-b\u0001\u0002&L\u0005JC\u0001\"\u001b\u0001\u0003\u0016\u0004%\tA\u001b\u0005\tk\u0002\u0011\t\u0012)A\u0005W\"Aa\u000f\u0001BK\u0002\u0013\u0005q\u000f\u0003\u0005~\u0001\tE\t\u0015!\u0003y\u0011!q\bA!f\u0001\n\u0003z\bBCA\u0004\u0001\tE\t\u0015!\u0003\u0002\u0002!Q\u0011\u0011\u0002\u0001\u0003\u0016\u0004%\t!a\u0003\t\u0015\u0005e\u0001A!E!\u0002\u0013\ti\u0001\u0003\u0006\u0002\u001c\u0001\u0011)\u001a!C\u0001\u0003;A!\"!\n\u0001\u0005#\u0005\u000b\u0011BA\u0010\u0011)\t9\u0003\u0001BK\u0002\u0013\u0005\u0011Q\u0004\u0005\u000b\u0003S\u0001!\u0011#Q\u0001\n\u0005}\u0001BCA\u0016\u0001\tU\r\u0011\"\u0001\u0002.!Q\u00111\n\u0001\u0003\u0012\u0003\u0006I!a\f\t\u0015\u00055\u0003A!f\u0001\n\u0003\ti\u0002\u0003\u0006\u0002P\u0001\u0011\t\u0012)A\u0005\u0003?A!\"!\u0015\u0001\u0005+\u0007I\u0011AA*\u0011)\t\u0019\t\u0001B\tB\u0003%\u0011Q\u000b\u0005\u000b\u0003\u000b\u0003!Q3A\u0005\u0002\u0005\u001d\u0005BCAH\u0001\tE\t\u0015!\u0003\u0002\n\"Q\u0011\u0011\u0013\u0001\u0003\u0016\u0004%\t!a%\t\u0015\u0005U\u0005A!E!\u0002\u0013\t\u0019\b\u0003\u0006\u0002\u0018\u0002\u0011)\u001a!C\u0001\u00033C!\"a*\u0001\u0005#\u0005\u000b\u0011BAN\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!a2\u0001\t\u0003\tI\rC\u0004\u0002~\u0002!\t!a@\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006!9!q\b\u0001\u0005\n\t\u0005\u0003\u0002\u0003B#\u0001\u0011E3Ja\u0012\t\u0011\tu\u0003\u0001\"\u0015L\u0005?B\u0001B!\u001a\u0001\t#Z%q\r\u0005\b\u0005g\u0002A\u0011\u0002B;\u0011\u001d\u0011y\b\u0001C\u0005\u0005\u0003CqAa\"\u0001\t\u0013\u0011I\tC\u0004\u0003\u0018\u0002!IA!'\t\u0011\t\u0005\u0006\u0001\"\u0001L\u0005GCqA!,\u0001\t\u0013\u0011y\u000bC\u0004\u0003D\u0002!IA!2\t\u0011\t\u0005\b\u0001\"\u0001L\u0005GD\u0001B!=\u0001\t\u0003Y%1\u001f\u0005\t\u0005{\u0004A\u0011A&\u0003\u0000\"91\u0011\u0002\u0001\u0005\n\r-\u0001\"CB\u0007\u0001\u0005\u0005I\u0011AB\b\u0011%\u0019I\u0003AI\u0001\n\u0003\u0019Y\u0003C\u0005\u0004B\u0001\t\n\u0011\"\u0001\u0004D!I1q\t\u0001\u0012\u0002\u0013\u00051\u0011\n\u0005\n\u0007\u001b\u0002\u0011\u0013!C\u0001\u0007\u001fB\u0011ba\u0015\u0001#\u0003%\ta!\u0016\t\u0013\re\u0003!%A\u0005\u0002\rU\u0003\"CB.\u0001E\u0005I\u0011AB/\u0011%\u0019\t\u0007AI\u0001\n\u0003\u0019)\u0006C\u0005\u0004d\u0001\t\n\u0011\"\u0001\u0004f!I1\u0011\u000e\u0001\u0012\u0002\u0013\u000511\u000e\u0005\n\u0007_\u0002\u0011\u0013!C\u0001\u0007cB\u0011b!\u001e\u0001#\u0003%\taa\u001e\t\u0013\rm\u0004!!A\u0005B\ru\u0004\"CBH\u0001\u0005\u0005I\u0011ABI\u0011%\u0019I\nAA\u0001\n\u0003\u0019Y\nC\u0005\u0004(\u0002\t\t\u0011\"\u0011\u0004*\"I1q\u0017\u0001\u0002\u0002\u0013\u00051\u0011\u0018\u0005\n\u0007{\u0003\u0011\u0011!C!\u0007\u007fC\u0011b!1\u0001\u0003\u0003%\tea1\t\u0013\r\u0015\u0007!!A\u0005B\r\u001dwaBBf\u0017\"\u00051Q\u001a\u0004\u0007\u0015.C\taa4\t\u000f\u0005%&\t\"\u0001\u0004X\"91\u0011\u001c\"\u0005\u0002\rm\u0007\"CBm\u0005\u0006\u0005I\u0011QBz\u0011%!iAQI\u0001\n\u0003\u0019\t\bC\u0005\u0005\u0010\t\u000b\t\u0011\"!\u0005\u0012!IAq\u0004\"\u0012\u0002\u0013\u00051\u0011\u000f\u0005\n\tC\u0011\u0015\u0011!C\u0005\tG\u0011qBU;o#V,'/_!eCB$XM\u001d\u0006\u0003\u00196\u000bq!\u00193baR,'O\u0003\u0002O\u001f\u000611\u000f\u001b:j]\u0016T\u0011\u0001U\u0001\u0004]\u0016$8\u0001A\n\u0005\u0001M\u0003g\r\u0005\u0003U+^kV\"A&\n\u0005Y[%AC\"sG\u0006#\u0017\r\u001d;feB\u0011\u0001lW\u0007\u00023*\u0011!,T\u0001\taJ|Go\\2pY&\u0011A,\u0017\u0002\u0010%Vt\u0017+^3ssJ+\u0017/^3tiB\u0011\u0001LX\u0005\u0003?f\u0013\u0001CU;o#V,'/\u001f*fgB|gn]3\u0011\u0005\u0005$W\"\u00012\u000b\u0003\r\fQa]2bY\u0006L!!\u001a2\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011mZ\u0005\u0003Q\n\u0014AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001]8ti\u0016\u0014X#A6\u0011\u00051\u001cX\"A7\u000b\u00059|\u0017A\u00027fO\u0006\u001c\u0017P\u0003\u0002qc\u000611\r\\5f]RT!A]'\u0002\r!$H\u000f\u001d\u001bt\u0013\t!XN\u0001\u0004Q_N$XM]\u0001\ba>\u001cH/\u001a:!\u0003\r!\u0017m\\\u000b\u0002qB\u0011\u0011p_\u0007\u0002u*\u0011aoS\u0005\u0003yj\u0014!\"\u00113baR,'\u000fR1p\u0003\u0011!\u0017m\u001c\u0011\u0002\u001f!Lg/Z\"sK\u0012,g\u000e^5bYN,\"!!\u0001\u0011\u0007a\u000b\u0019!C\u0002\u0002\u0006e\u0013q\u0002S5wK\u000e\u0013X\rZ3oi&\fGn]\u0001\u0011Q&4Xm\u0011:fI\u0016tG/[1mg\u0002\n\u0011cY8oG\u0016\u0004H\u000f\u0016:b]Nd\u0017\r^8s+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019bS\u0001\fiJ\fgn\u001d7bi>\u00148/\u0003\u0003\u0002\u0018\u0005E!!G)vKJLH)\u001a4j]&$\u0018n\u001c8Ue\u0006t7\u000f\\1u_J\f!cY8oG\u0016\u0004H\u000f\u0016:b]Nd\u0017\r^8sA\u0005iAm\\(cMV\u001c8-\u0019;j_:,\"!a\b\u0011\u0007\u0005\f\t#C\u0002\u0002$\t\u0014qAQ8pY\u0016\fg.\u0001\be_>\u0013g-^:dCRLwN\u001c\u0011\u0002+I,h.U;fe&,7/S7nK\u0012L\u0017\r^3ms\u00061\"/\u001e8Rk\u0016\u0014\u0018.Z:J[6,G-[1uK2L\b%\u0001\bce\u0016\f7\u000eZ8x]RK\b/Z:\u0016\u0005\u0005=\u0002CBA\u0019\u0003\u007f\t)E\u0004\u0003\u00024\u0005m\u0002cAA\u001bE6\u0011\u0011q\u0007\u0006\u0004\u0003s\t\u0016A\u0002\u001fs_>$h(C\u0002\u0002>\t\fa\u0001\u0015:fI\u00164\u0017\u0002BA!\u0003\u0007\u00121aU3u\u0015\r\tiD\u0019\t\u00041\u0006\u001d\u0013bAA%3\n\u0001\"+Z:vYR|U\u000f\u001e9viRK\b/Z\u0001\u0010EJ,\u0017m\u001b3po:$\u0016\u0010]3tA\u0005\u00192m\u001c7mK\u000e$\u0018\tZ1qi\u0016\u0014\u0018)\u001e3ji\u0006!2m\u001c7mK\u000e$\u0018\tZ1qi\u0016\u0014\u0018)\u001e3ji\u0002\naCY8u\u0007>,h\u000e\u001e+j[\u0016$\u0006N]3tQ>dGm]\u000b\u0003\u0003+\u0002b!a\u0016\u0002b\u0005\u001dd\u0002BA-\u0003;rA!!\u000e\u0002\\%\t1-C\u0002\u0002`\t\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\u0005\u0015$aA*fc*\u0019\u0011q\f2\u0011\u000f\u0005\fI'!\u001c\u0002t%\u0019\u00111\u000e2\u0003\rQ+\b\u000f\\33!\r\t\u0017qN\u0005\u0004\u0003c\u0012'\u0001\u0002'p]\u001e\u0004B!!\u001e\u0002\u00005\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(\u0001\u0005ekJ\fG/[8o\u0015\r\tiHY\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAA\u0003o\u0012\u0001\u0002R;sCRLwN\\\u0001\u0018E>$8i\\;oiRKW.\u001a+ie\u0016\u001c\bn\u001c7eg\u0002\n!b\u001c2gkN\u001c\u0017\r^8s+\t\tI\tE\u0002U\u0003\u0017K1!!$L\u0005)y%MZ;tG\u0006$xN]\u0001\f_\n4Wo]2bi>\u0014\b%\u0001\u000bde\u000e\u0014VO\\)vKJLH+[7f\u0019&l\u0017\u000e^\u000b\u0003\u0003g\nQc\u0019:d%Vt\u0017+^3ssRKW.\u001a'j[&$\b%\u0001\bdKJ$8i\u001c7mK\u000e$\u0018n\u001c8\u0016\u0005\u0005m\u0005\u0003BAO\u0003Gk!!a(\u000b\u0007\u0005\u0005V*\u0001\u0004def\u0004Ho\\\u0005\u0005\u0003K\u000byJ\u0001\rC_Vt7-_&fsN#xN]3D_2dWm\u0019;j_:\fqbY3si\u000e{G\u000e\\3di&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u00155\u00055\u0016qVAY\u0003g\u000b),a.\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019-!2\u0011\u0005Q\u0003\u0001\"B5\u001a\u0001\u0004Y\u0007\"\u0002<\u001a\u0001\u0004A\bB\u0002@\u001a\u0001\u0004\t\t\u0001C\u0004\u0002\ne\u0001\r!!\u0004\t\u000f\u0005m\u0011\u00041\u0001\u0002 !9\u0011qE\rA\u0002\u0005}\u0001bBA\u00163\u0001\u0007\u0011q\u0006\u0005\b\u0003\u001bJ\u0002\u0019AA\u0010\u0011\u001d\t\t&\u0007a\u0001\u0003+Bq!!\"\u001a\u0001\u0004\tI\tC\u0005\u0002\u0012f\u0001\n\u00111\u0001\u0002t!9\u0011qS\rA\u0002\u0005m\u0015AH:uCJ$(+\u001e8Rk\u0016\u0014\u0018PR8s\u000bb\u0004Xm\u0019;fIJ+7/\u001e7u)\u0011\tY-!;\u0011\r\u00055\u0017q[An\u001b\t\tyM\u0003\u0003\u0002R\u0006M\u0017AB3gM\u0016\u001cGO\u0003\u0002\u0002V\u0006!1-\u0019;t\u0013\u0011\tI.a4\u0003\u0005%{\u0005\u0003CAg\u0003;\f\t/a9\n\t\u0005}\u0017q\u001a\u0002\u0006\r&\u0014WM\u001d\t\u0005\u0003\u001b\f9\u000eE\u0002b\u0003KL1!a:c\u0005\u0011)f.\u001b;\t\u000f\u0005-(\u00041\u0001\u0002n\u0006\t\"/\u001e8Rk\u0016\u0014\u0018PR8s%\u0016\u001cX\u000f\u001c;\u0011\t\u0005=\u0018\u0011`\u0007\u0003\u0003cTA!a=\u0002v\u0006\u0011a/\r\u0006\u0004\u0003oL\u0016a\u0002<feNLwN\\\u0005\u0005\u0003w\f\tPA\tSk:\fV/\u001a:z\r>\u0014(+Z:vYR\f\u0011D];o#V,'/\u001f$pe\u0016C\b/Z2uK\u0012\u0014Vm];miR!\u00111\u001dB\u0001\u0011\u001d\tYo\u0007a\u0001\u0003[\fAD];o#V,'/_%o\u0007J\u001c\u0017I\u001c3Ti>\u0014XMU3tk2$8\u000f\u0006\u0006\u0003\b\tm!q\u0004B\u0016\u0005k\u0001r!YA5\u0005\u0013\u0011y\u0001\u0005\u0003\u0002p\n-\u0011\u0002\u0002B\u0007\u0003c\u0014A\"\u00169eCR,'+Z:vYR\u0004R!\u0019B\t\u0005+I1Aa\u0005c\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001La\u0006\n\u0007\te\u0011L\u0001\bTQJLg.\u001a*fgB|gn]3\t\r\tuA\u00041\u0001X\u0003=\u0011XO\\)vKJL(+Z9vKN$\bb\u0002B\u00119\u0001\u0007!1E\u0001\bcV,'/_%e!\u0011\u0011)Ca\n\u000e\u0005\u0005U\u0018\u0002\u0002B\u0015\u0003k\u0014q!U;fefLE\rC\u0004\u0003.q\u0001\rAa\f\u0002#Q\u0014\u0018M\\:mCR,GMU3rk\u0016\u001cH\u000fE\u0002Y\u0005cI1Aa\rZ\u00055\u0019\u0006N]5oKJ+\u0017/^3ti\"9!q\u0007\u000fA\u0002\te\u0012a\u0003;iSNtu\u000eZ3LKf\u0004BA!\n\u0003<%!!QHA{\u0005\u001dqu\u000eZ3LKf\f!E];o#V,'/\u001f$peJ+7/\u001e7u)>\u0014VO\\)vKJL(+Z9vKN$HcA,\u0003D!9\u00111^\u000fA\u0002\u00055\u0018a\u00059beN,7\u000b\u001b:j]\u0016\u0014Vm\u001d9p]N,G\u0003\u0002B%\u0005\u001f\u00022\u0001\u0017B&\u0013\r\u0011i%\u0017\u0002\u0017%\u0006<8I]2Sk:\fV/\u001a:z%\u0016\u001c\bo\u001c8tK\"9!\u0011\u000b\u0010A\u0002\tM\u0013a\u0001=nYB!!Q\u000bB-\u001b\t\u00119FC\u0002\u0003R\tLAAa\u0017\u0003X\t9aj\u001c3f'\u0016\f\u0018a\u0006;sC:\u001cH.\u0019;f\u001d\u0016$xo\u001c:l)>dunY1m)\r9&\u0011\r\u0005\u0007\u0005Gz\u0002\u0019A,\u0002\u000fI,\u0017/^3ti\u0006q\u0001O]8dKN\u001c(+Z9vKN$H\u0003\u0002B\u000b\u0005SBqAa\u001b!\u0001\u0004\u0011i'A\u0004nKN\u001c\u0018mZ3\u0011\u0007a\u0013y'C\u0002\u0003re\u0013\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;NKN\u001c\u0018mZ3\u0002!I,7\u000f]8og\u0016$vNU3tk2$H\u0003\u0003B\u0005\u0005o\u0012IH! \t\u000f\t\u0005\u0012\u00051\u0001\u0003$!9!1P\u0011A\u0002\tU\u0011AD:ie&tWMU3ta>t7/\u001a\u0005\b\u0005o\t\u0003\u0019\u0001B\u001d\u0003A\u0019XM\u001c3Va\u0012\fG/\u001a*fgVdG\u000f\u0006\u0003\u0002d\n\r\u0005b\u0002BCE\u0001\u0007!\u0011B\u0001\rkB$\u0017\r^3SKN,H\u000e^\u0001\u000bgR|'/Z)vKJLH#B/\u0003\f\nU\u0005b\u0002BGG\u0001\u0007!qR\u0001\u000bCV$\bN\u001c+p+N,\u0007c\u0001-\u0003\u0012&\u0019!1S-\u0003%\u0005+H\u000f[3oi&\u001c\u0017\r^5p]&sgm\u001c\u0005\u0007\u0005G\u001a\u0003\u0019A,\u0002\u0011I,h.U;fef$\u0002B!\u0006\u0003\u001c\nu%q\u0014\u0005\b\u0005\u001b#\u0003\u0019\u0001BH\u0011\u001d\u0011Y\u0007\na\u0001\u0005[BaAa\u0019%\u0001\u00049\u0016!\b9s_\u000e,7o\u001d*bo\u000e\u00138MU;o#V,'/\u001f*fgB|gn]3\u0015\u000fu\u0013)Ka*\u0003*\"9!QR\u0013A\u0002\t=\u0005B\u0002B2K\u0001\u0007q\u000bC\u0004\u0003,\u0016\u0002\rA!\u0013\u0002'I\fwOU;o#V,'/\u001f*fgB|gn]3\u0002SI,7/\u001e7ug^KG\u000f[\"pk:$8\u000b^1uK>3G*Z1ti\u000e{W\u000e\u001d7fi\u0016\u001cF/\u0019;f)!\u0011\tL!/\u0003<\n}\u0006CBA,\u0003C\u0012\u0019\fE\u0002Y\u0005kK1Aa.Z\u0005-\tV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\r\t\rd\u00051\u0001X\u0011\u001d\u0011iL\na\u0001\u0005c\u000bqb\u001c:jO&t\u0017\r\u001c*fgVdGo\u001d\u0005\b\u0005\u00034\u0003\u0019\u0001BY\u0003ay'/[4j]\u0006d'I]3bW\u0012|wO\u001c*fgVdGo]\u0001\u0011O\u0016$(+Z:vYR4%o\\7De\u000e$bAa2\u0003Z\nu\u0007C\u0002Be\u0005\u001f\u0014\u0019.\u0004\u0002\u0003L*\u0019!Q\u001a2\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005#\u0014YMA\u0002Uef\u00042\u0001\u0017Bk\u0013\r\u00119.\u0017\u0002\u0013%\u0016\fGMU3tk2$(+Z:q_:\u001cX\r\u0003\u0004\u0003\\\u001e\u0002\raV\u0001\u000ea\u0006\u0014XM\u001c;SKF,Xm\u001d;\t\u000f\t}w\u00051\u0001\u0002n\u0005ya.\u001a;x_J\\'+Z:vYRLE-\u0001\fbiR,W\u000e\u001d;U_J+GO]5fm\u0016\u001cu.\u001e8u)\u0019\u0011)O!;\u0003nB9\u0011-!\u001b\u00034\n\u001d\bC\u0002Be\u0005\u001f\u0014\u0019\f\u0003\u0004\u0003l\"\u0002\raV\u0001\feVt\u0017+^3ssJ+\u0017\u000fC\u0004\u0003p\"\u0002\rAa-\u00021=\u0014\u0018nZ5oC2\u001cu.\u001e8u#V,'/\u001f*fgVdG/A\u000ebiR,W\u000e\u001d;U_J+GO]5fm\u0016\u0014%/Z1lI><hn\u001d\u000b\u0007\u0005k\u00149P!?\u0011\r\u0005]\u0013\u0011\rBs\u0011\u0019\u0011Y/\u000ba\u0001/\"9!1`\u0015A\u0002\tE\u0016\u0001\u00052sK\u0006\\Gm\\<o%\u0016\u001cX\u000f\u001c;t\u0003Qawn\u001a\"sK\u0006\\Gm\\<o\r\u0006LG.\u001e:fgR1\u00111]B\u0001\u0007\u000bAqaa\u0001+\u0001\u0004\u0011I%\u0001\u0005sKN\u0004xN\\:f\u0011\u001d\u00199A\u000ba\u0001\u0005k\f\u0001BZ1jYV\u0014Xm]\u0001\u000bY><7\u000b^1siV\u0004HCAAr\u0003\u0011\u0019w\u000e]=\u00155\u000556\u0011CB\n\u0007+\u00199b!\u0007\u0004\u001c\ru1qDB\u0011\u0007G\u0019)ca\n\t\u000f%d\u0003\u0013!a\u0001W\"9a\u000f\fI\u0001\u0002\u0004A\b\u0002\u0003@-!\u0003\u0005\r!!\u0001\t\u0013\u0005%A\u0006%AA\u0002\u00055\u0001\"CA\u000eYA\u0005\t\u0019AA\u0010\u0011%\t9\u0003\fI\u0001\u0002\u0004\ty\u0002C\u0005\u0002,1\u0002\n\u00111\u0001\u00020!I\u0011Q\n\u0017\u0011\u0002\u0003\u0007\u0011q\u0004\u0005\n\u0003#b\u0003\u0013!a\u0001\u0003+B\u0011\"!\"-!\u0003\u0005\r!!#\t\u0013\u0005EE\u0006%AA\u0002\u0005M\u0004\"CALYA\u0005\t\u0019AAN\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\f+\u0007-\u001cyc\u000b\u0002\u00042A!11GB\u001f\u001b\t\u0019)D\u0003\u0003\u00048\re\u0012!C;oG\",7m[3e\u0015\r\u0019YDY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB \u0007k\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"a!\u0012+\u0007a\u001cy#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r-#\u0006BA\u0001\u0007_\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0004R)\"\u0011QBB\u0018\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"aa\u0016+\t\u0005}1qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]*\"aa\u0018+\t\u0005=2qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIe*\"aa\u001a+\t\u0005U3qF\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132aU\u00111Q\u000e\u0016\u0005\u0003\u0013\u001by#A\bd_BLH\u0005Z3gCVdG\u000fJ\u00192+\t\u0019\u0019H\u000b\u0003\u0002t\r=\u0012aD2paf$C-\u001a4bk2$H%\r\u001a\u0016\u0005\re$\u0006BAN\u0007_\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB@!\u0011\u0019\tia#\u000e\u0005\r\r%\u0002BBC\u0007\u000f\u000bA\u0001\\1oO*\u00111\u0011R\u0001\u0005U\u00064\u0018-\u0003\u0003\u0004\u000e\u000e\r%AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0004\u0014B\u0019\u0011m!&\n\u0007\r]%MA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004\u001e\u000e\r\u0006cA1\u0004 &\u00191\u0011\u00152\u0003\u0007\u0005s\u0017\u0010C\u0005\u0004&n\n\t\u00111\u0001\u0004\u0014\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa+\u0011\r\r561WBO\u001b\t\u0019yKC\u0002\u00042\n\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019)la,\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003?\u0019Y\fC\u0005\u0004&v\n\t\u00111\u0001\u0004\u001e\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0004\u0014\u0006AAo\\*ue&tw\r\u0006\u0002\u0004\u0000\u00051Q-];bYN$B!a\b\u0004J\"I1Q\u0015!\u0002\u0002\u0003\u00071QT\u0001\u0010%Vt\u0017+^3ss\u0006#\u0017\r\u001d;feB\u0011AKQ\n\u0005\u0005\u000eEg\rE\u0002b\u0007'L1a!6c\u0005\u0019\te.\u001f*fMR\u00111QZ\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0003[\u001bi\u000eC\u0004\u0004`\u0012\u0003\ra!9\u0002\r\r|gNZ5h!\u0011\u0019\u0019oa<\u000e\u0005\r\u0015(\u0002BBp\u0007OTAa!;\u0004l\u0006AA/\u001f9fg\u00064WM\u0003\u0002\u0004n\u0006\u00191m\\7\n\t\rE8Q\u001d\u0002\u0007\u0007>tg-[4\u00155\u000556Q_B|\u0007s\u001cYp!@\u0004\u0000\u0012\u0005A1\u0001C\u0003\t\u000f!I\u0001b\u0003\t\u000b%,\u0005\u0019A6\t\u000bY,\u0005\u0019\u0001=\t\ry,\u0005\u0019AA\u0001\u0011\u001d\tI!\u0012a\u0001\u0003\u001bAq!a\u0007F\u0001\u0004\ty\u0002C\u0004\u0002(\u0015\u0003\r!a\b\t\u000f\u0005-R\t1\u0001\u00020!9\u0011QJ#A\u0002\u0005}\u0001bBA)\u000b\u0002\u0007\u0011Q\u000b\u0005\b\u0003\u000b+\u0005\u0019AAE\u0011%\t\t*\u0012I\u0001\u0002\u0004\t\u0019\bC\u0004\u0002\u0018\u0016\u0003\r!a'\u0002!\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE\n\u0014aB;oCB\u0004H.\u001f\u000b\u0005\t'!Y\u0002E\u0003b\u0005#!)\u0002E\rb\t/Y\u00070!\u0001\u0002\u000e\u0005}\u0011qDA\u0018\u0003?\t)&!#\u0002t\u0005m\u0015b\u0001C\rE\n9A+\u001e9mKF\u0012\u0004\"\u0003C\u000f\u000f\u0006\u0005\t\u0019AAW\u0003\rAH\u0005M\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00192\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0011\u0015\u0002\u0003BBA\tOIA\u0001\"\u000b\u0004\u0004\n1qJ\u00196fGR\u0004")
public final class RunQueryAdapter
extends CrcAdapter<RunQueryRequest, RunQueryResponse>
implements Product,
scala.Serializable {
    private final Poster poster;
    private final AdapterDao dao;
    private final HiveCredentials hiveCredentials;
    private final QueryDefinitionTranslator conceptTranslator;
    private final boolean doObfuscation;
    private final boolean runQueriesImmediately;
    private final Set<ResultOutputType> breakdownTypes;
    private final boolean collectAdapterAudit;
    private final Seq<Tuple2<Object, Duration>> botCountTimeThresholds;
    private final Obfuscator obfuscator;
    private final Duration crcRunQueryTimeLimit;
    private final BouncyKeyStoreCollection certCollection;

    public static Duration $lessinit$greater$default$11() {
        return RunQueryAdapter$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<Tuple12<Poster, AdapterDao, HiveCredentials, QueryDefinitionTranslator, Object, Object, Set<ResultOutputType>, Object, Seq<Tuple2<Object, Duration>>, Obfuscator, Duration, BouncyKeyStoreCollection>> unapply(RunQueryAdapter runQueryAdapter) {
        return RunQueryAdapter$.MODULE$.unapply(runQueryAdapter);
    }

    public static Duration apply$default$11() {
        return RunQueryAdapter$.MODULE$.apply$default$11();
    }

    public static RunQueryAdapter apply(Poster poster, AdapterDao adapterDao, HiveCredentials hiveCredentials, QueryDefinitionTranslator queryDefinitionTranslator, boolean bl, boolean bl2, Set<ResultOutputType> set, boolean bl3, Seq<Tuple2<Object, Duration>> seq, Obfuscator obfuscator, Duration duration, BouncyKeyStoreCollection bouncyKeyStoreCollection) {
        return RunQueryAdapter$.MODULE$.apply(poster, adapterDao, hiveCredentials, queryDefinitionTranslator, bl, bl2, set, bl3, seq, obfuscator, duration, bouncyKeyStoreCollection);
    }

    public static RunQueryAdapter apply(Config config) {
        return RunQueryAdapter$.MODULE$.apply(config);
    }

    public Poster poster() {
        return this.poster;
    }

    public AdapterDao dao() {
        return this.dao;
    }

    @Override
    public HiveCredentials hiveCredentials() {
        return this.hiveCredentials;
    }

    public QueryDefinitionTranslator conceptTranslator() {
        return this.conceptTranslator;
    }

    public boolean doObfuscation() {
        return this.doObfuscation;
    }

    public boolean runQueriesImmediately() {
        return this.runQueriesImmediately;
    }

    public Set<ResultOutputType> breakdownTypes() {
        return this.breakdownTypes;
    }

    public boolean collectAdapterAudit() {
        return this.collectAdapterAudit;
    }

    public Seq<Tuple2<Object, Duration>> botCountTimeThresholds() {
        return this.botCountTimeThresholds;
    }

    public Obfuscator obfuscator() {
        return this.obfuscator;
    }

    public Duration crcRunQueryTimeLimit() {
        return this.crcRunQueryTimeLimit;
    }

    public BouncyKeyStoreCollection certCollection() {
        return this.certCollection;
    }

    public IO<Fiber<IO, BoxedUnit>> startRunQueryForExpectedResult(RunQueryForResult runQueryForResult) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runQueryForExpectedResult(runQueryForResult)).start(IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.crcExecutionContext()));
    }

    public void runQueryForExpectedResult(RunQueryForResult runQueryForResult) {
        String thisNodeKey = ((NodeKey)net.shrine.config.package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).get("shrine.nodeKey", (Function1 & Serializable & scala.Serializable)x$1 -> new NodeKey(x$1))).underlying();
        if (this.collectAdapterAudit()) {
            AdapterAuditDb$.MODULE$.db().insertQueryReceived(runQueryForResult);
        }
        long queryId = runQueryForResult.resultProgress().queryId();
        UpdateResultWithProgress updateResultProgressReceived = new UpdateResultWithProgress(queryId, thisNodeKey, (ResultStatus)ResultStatuses.ReceivedByAdapter$.MODULE$, UpdateResultWithProgress$.MODULE$.apply$default$4());
        this.sendUpdateResult((UpdateResult)updateResultProgressReceived);
        Try runQueryRequestTry = runQueryForResult.query().verifySignature(this.certCollection()).toTry(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x$2 -> this.runQueryForResultToRunQueryRequest(runQueryForResult));
        Try resultFromRun = runQueryRequestTry.map((Function1 & Serializable & scala.Serializable)runQueryRequest -> {
            Tuple2 tuple2;
            if (this.runQueriesImmediately()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Performing query from user ").append(runQueryRequest.authn().domain()).append(":").append(runQueryRequest.authn().username()).toString());
                package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.dao().checkIfBot(runQueryRequest.authn(), this.botCountTimeThresholds()));
                ShrineRequest translatedRequest = this.translateRequest((BaseShrineRequest)runQueryRequest);
                if (this.collectAdapterAudit()) {
                    AdapterAuditDb$.MODULE$.db().insertExecutionStarted((RunQueryRequest)runQueryRequest);
                }
                tuple2 = this.runQueryInCrcAndStoreResults((RunQueryRequest)runQueryRequest, queryId, translatedRequest, thisNodeKey);
            } else {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Storing query from user ").append(runQueryRequest.authn().domain()).append(":").append(runQueryRequest.authn().username()).append(" to run manually").toString());
                this.storeQuery(runQueryRequest.authn(), (RunQueryRequest)runQueryRequest);
                UpdateResultWithProgress updateProgress = new UpdateResultWithProgress(queryId, thisNodeKey, (ResultStatus)ResultStatuses.QueuedForManualSubmission$.MODULE$, (Option)new Some((Object)"Adapter configured to submit queries manually"));
                tuple2 = new Tuple2((Object)updateProgress, (Object)None$.MODULE$);
            }
            return tuple2;
        }).transform((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> s), (Function1 & Serializable & scala.Serializable)throwable -> {
            AbstractProblem abstractProblem;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SignatureNotVerifiedException) {
                SignatureNotVerifiedException signatureNotVerifiedException = (SignatureNotVerifiedException)throwable2;
                abstractProblem = new CouldNotVerifySignature(signatureNotVerifiedException, (Id)new ResultId(runQueryForResult.resultProgress().id()));
            } else if (throwable2 instanceof AdapterMappingException) {
                AdapterMappingException adapterMappingException = (AdapterMappingException)throwable2;
                abstractProblem = new AdapterMappingProblem(adapterMappingException);
            } else if (throwable2 instanceof SQLException) {
                SQLException sQLException = (SQLException)throwable2;
                abstractProblem = new AdapterDatabaseProblem(sQLException);
            } else if (throwable2 instanceof CrcInvocationException) {
                CrcInvocationException crcInvocationException = (CrcInvocationException)throwable2;
                abstractProblem = new CrcCouldNotBeInvoked(crcInvocationException.invokedUrl(), crcInvocationException.request(), crcInvocationException);
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable x = (Throwable)option.get();
                    abstractProblem = new ExceptionWhileAttemptingToRunQuery(x);
                } else {
                    throw new MatchError((Object)throwable2);
                }
            }
            AdapterMappingProblem problem = abstractProblem;
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                UpdateResultWithError errorUpdate = UpdateResultWithError$.MODULE$.create(queryId, thisNodeKey, (Problem)problem, (ResultStatus)ResultStatuses.ErrorInShrine$.MODULE$, UpdateResultWithError$.MODULE$.create$default$5(), UpdateResultWithError$.MODULE$.create$default$6());
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("errorUpdate is ").append(errorUpdate).toString(), (Throwable)throwable);
                return new Tuple2((Object)errorUpdate, (Object)None$.MODULE$);
            });
        });
        resultFromRun.map((Function1 & Serializable & scala.Serializable)r -> {
            RunQueryAdapter.$anonfun$runQueryForExpectedResult$12(this, queryId, r);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<UpdateResult, Option<ShrineResponse>> runQueryInCrcAndStoreResults(RunQueryRequest runQueryRequest, long queryId, ShrineRequest translatedRequest, String thisNodeKey) {
        Tuple2 tuple2;
        UpdateResultWithProgress updateResultProgressToCrc = new UpdateResultWithProgress(queryId, thisNodeKey, (ResultStatus)ResultStatuses.SubmittedToCRC$.MODULE$, UpdateResultWithProgress$.MODULE$.apply$default$4());
        this.sendUpdateResult((UpdateResult)updateResultProgressToCrc);
        try {
            ErrorResponse errorResponse;
            String i2b2Response = this.callCrc(translatedRequest);
            ShrineResponse shrineResponse = this.parseShrineErrorResponseWithFallback(i2b2Response);
            if (shrineResponse instanceof ErrorResponse) {
                ErrorResponse errorResponse2;
                errorResponse = errorResponse2 = (ErrorResponse)shrineResponse;
            } else if (shrineResponse instanceof RawCrcRunQueryResponse) {
                RawCrcRunQueryResponse rawCrcRunQueryResponse = (RawCrcRunQueryResponse)shrineResponse;
                errorResponse = this.processRawCrcRunQueryResponse(runQueryRequest.authn(), runQueryRequest, rawCrcRunQueryResponse);
            } else {
                throw new MatchError((Object)shrineResponse);
            }
            ErrorResponse responseFromCrc = errorResponse;
            if (this.collectAdapterAudit()) {
                AdapterAuditDb$.MODULE$.db().insertExecutionCompletedShrineResponse(runQueryRequest, (ShrineResponse)responseFromCrc);
            }
            UpdateResult updateResult = this.responseToResult(queryId, (ShrineResponse)responseFromCrc, thisNodeKey);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("updateResult is ").append(updateResult).toString());
            QueuedQueriesPoller$.MODULE$.restart().unsafeRunSync();
            tuple2 = new Tuple2((Object)updateResult, (Object)Option$.MODULE$.apply((Object)responseFromCrc));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable x = (Throwable)option.get();
            UpdateResultWithError errorUpdate = UpdateResultWithError$.MODULE$.create(queryId, thisNodeKey, (Problem)new ExceptionWhileAttemptingToRunQuery(x), (ResultStatus)ResultStatuses.ErrorFromCrc$.MODULE$, UpdateResultWithError$.MODULE$.create$default$5(), UpdateResultWithError$.MODULE$.create$default$6());
            Tuple2 tuple22 = new Tuple2((Object)errorUpdate, (Object)None$.MODULE$);
            tuple2 = tuple22;
        }
        return tuple2;
    }

    private RunQueryRequest runQueryForResultToRunQueryRequest(RunQueryForResult runQueryForResult) {
        QueryDefinition queryDefinition;
        Set set;
        AuthenticationInfo authToUse = AuthenticationInfo$.MODULE$.noPasswordFromResearcher(runQueryForResult.researcher());
        try {
            set = RunQueryRequest$.MODULE$.determineI2b2OutputTypes(this.breakdownTypes(), (NodeSeq)XML$.MODULE$.loadString(runQueryForResult.query().outputTypesXml()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable x = (Throwable)option.get();
                throw new CouldNotInterpretI2b2OutputTypesException(runQueryForResult.query().outputTypesXml(), x);
            }
            throw throwable;
        }
        Set outputTypes = set;
        try {
            queryDefinition = (QueryDefinition)QueryDefinition$.MODULE$.fromI2b2(runQueryForResult.query().queryDefinitionXml()).get();
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable x = (Throwable)option.get();
                throw new CouldNotInterpretQueryDefinitionException(runQueryForResult.query().queryDefinitionXml(), x);
            }
            throw throwable;
        }
        QueryDefinition queryDefinition2 = queryDefinition;
        return new RunQueryRequest(runQueryForResult.query().projectName(), this.crcRunQueryTimeLimit(), authToUse, ((QueryId)runQueryForResult.query().id()).underlying(), (Option)new Some((Object)new Tuple2((Object)((Object)BoxesRunTime.boxToLong((long)runQueryForResult.query().topicId())).toString(), (Object)runQueryForResult.topic().name())), outputTypes, queryDefinition2, (Option)new Some((Object)XmlNodeName$.MODULE$.fromProtocolNode(runQueryForResult.node())));
    }

    public RawCrcRunQueryResponse parseShrineResponse(NodeSeq xml) {
        return (RawCrcRunQueryResponse)RawCrcRunQueryResponse$.MODULE$.fromI2b2(this.breakdownTypes(), xml).get();
    }

    @Override
    public RunQueryRequest translateNetworkToLocal(RunQueryRequest request) {
        RunQueryRequest runQueryRequest;
        try {
            runQueryRequest = request.mapQueryDefinition((Function1 & Serializable & scala.Serializable)queryDef -> this.conceptTranslator().translate((QueryDefinition)queryDef));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof CouldNotMapAllTermsException) {
                CouldNotMapAllTermsException couldNotMapAllTermsException = (CouldNotMapAllTermsException)throwable2;
                Set unmappable = couldNotMapAllTermsException.unmappable();
                throw new AdapterMappingException(request, new StringBuilder(30).append("Could not map query term(s) ").append(unmappable.mkString(", ")).append("}.").toString(), (Throwable)couldNotMapAllTermsException);
            }
            if (throwable2 instanceof MappingException) {
                MappingException mappingException = (MappingException)throwable2;
                String message = mappingException.message();
                throw new AdapterMappingException(request, message, (Throwable)mappingException);
            }
            throw throwable;
        }
        return runQueryRequest;
    }

    public ShrineResponse processRequest(BroadcastMessage message) {
        RunQueryResponse runQueryResponse;
        if (this.collectAdapterAudit()) {
            AdapterAuditDb$.MODULE$.db().insertQueryReceived(message);
        }
        this.dao().checkIfBot(message.networkAuthn(), this.botCountTimeThresholds());
        RunQueryRequest runQueryReq = (RunQueryRequest)message.request();
        Credential x$1 = new Credential("", false);
        String x$2 = message.networkAuthn().copy$default$1();
        String x$3 = message.networkAuthn().copy$default$2();
        AuthenticationInfo authnToUse = message.networkAuthn().copy(x$2, x$3, x$1);
        Duration x$42 = this.crcRunQueryTimeLimit();
        String x$5 = runQueryReq.copy$default$1();
        AuthenticationInfo x$6 = runQueryReq.copy$default$3();
        long x$7 = runQueryReq.copy$default$4();
        Option x$8 = runQueryReq.copy$default$5();
        Set x$9 = runQueryReq.copy$default$6();
        QueryDefinition x$10 = runQueryReq.copy$default$7();
        Option x$11 = runQueryReq.copy$default$8();
        RunQueryRequest runQueryReqWithTimeLimit = runQueryReq.copy(x$5, x$42, x$6, x$7, x$8, x$9, x$10, x$11);
        if (!this.runQueriesImmediately()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Queueing query from user ").append(message.networkAuthn().domain()).append(":").append(message.networkAuthn().username()).toString());
            runQueryResponse = this.storeQuery(authnToUse, runQueryReqWithTimeLimit);
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Performing query from user ").append(message.networkAuthn().domain()).append(":").append(message.networkAuthn().username()).toString());
            RunQueryRequest x$12 = runQueryReqWithTimeLimit.withAuthn(authnToUse);
            long x$13 = message.copy$default$1();
            AuthenticationInfo x$14 = message.copy$default$2();
            Option x$15 = message.copy$default$4();
            ShrineResponse shrineResponse = this.runQuery(authnToUse, message.copy(x$13, x$14, (BaseShrineRequest)x$12, x$15), runQueryReqWithTimeLimit.withAuthn(authnToUse));
            String thisNodeKey = ((NodeKey)net.shrine.config.package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).get("shrine.nodeKey", (Function1 & Serializable & scala.Serializable)x$4 -> new NodeKey(x$4))).underlying();
            QueuedQueriesPoller$.MODULE$.restart().unsafeRunSync();
            this.sendUpdateResult(this.responseToResult(runQueryReqWithTimeLimit.networkQueryId(), shrineResponse, thisNodeKey));
            runQueryResponse = shrineResponse;
        }
        return runQueryResponse;
    }

    private UpdateResult responseToResult(long queryId, ShrineResponse shrineResponse, String thisNodeKey) {
        UpdateResult updateResult;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("start responseToResult for query ").append(new QueryId(queryId)).toString());
        ShrineResponse shrineResponse2 = shrineResponse;
        if (shrineResponse2 instanceof RunQueryResponse) {
            RunQueryResponse runQueryResponse = (RunQueryResponse)shrineResponse2;
            updateResult = runQueryResponse.singleNodeResult().createUpdateResult(queryId, runQueryResponse.queryInstanceId(), (ResultOutputType)runQueryResponse.results().headOption().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.resultType()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ResultOutputType$.MODULE$.PATIENT_COUNT_XML()));
        } else if (shrineResponse2 instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)shrineResponse2;
            updateResult = UpdateResultWithError$.MODULE$.create(queryId, thisNodeKey, errorResponse.problem(), (ResultStatus)ResultStatuses.ErrorFromCrc$.MODULE$, (Option)new Some((Object)errorResponse.errorMessage()), UpdateResultWithError$.MODULE$.create$default$6());
        } else {
            throw new MatchError((Object)shrineResponse2);
        }
        return updateResult;
    }

    private void sendUpdateResult(UpdateResult updateResult) {
        ShrineMomClient$.MODULE$.sendToHubIO((Id)new QueryId(updateResult.queryId()), (EnvelopeContents)updateResult, (EnvelopeContentsCompanion)UpdateResult$.MODULE$, new StringBuilder(7).append(updateResult).append(" to hub").toString(), ShrineMomClient$.MODULE$.sendToHubIO$default$5()).handleErrorWith((Function1 & Serializable & scala.Serializable)t -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Log$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> "Exception while running RunQueryAdapter.sendUpdateResult", t))).unsafeRunAsyncAndForget();
    }

    private RunQueryResponse storeQuery(AuthenticationInfo authnToUse, RunQueryRequest request) {
        long masterId = -1L;
        long queryInstanceId = -1L;
        long resultId = -1L;
        String groupId = authnToUse.domain();
        long invalidSetSize = -1L;
        XMLGregorianCalendar now = XmlDateHelper$.MODULE$.now();
        QueryResult queryResult = new QueryResult(resultId, queryInstanceId, (Option)new Some((Object)ResultOutputType$.MODULE$.PATIENT_COUNT_XML()), invalidSetSize, (Option)new Some((Object)now), (Option)new Some((Object)now), (Option)new Some((Object)"Query enqueued for later processing"), QueryResult.StatusType$.MODULE$.Held(), (Option)new Some((Object)"Query enqueued for later processing"), QueryResult$.MODULE$.apply$default$10(), QueryResult$.MODULE$.apply$default$11());
        this.dao().inTransaction((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int insertedQueryId = this.dao().insertQuery(((Object)BoxesRunTime.boxToLong((long)masterId)).toString(), request.networkQueryId(), authnToUse, request.queryDefinition(), false, false, (Option<String>)None$.MODULE$);
            Map<ResultOutputType, Seq<Object>> insertedQueryResultIds = this.dao().insertQueryResults(insertedQueryId, (Seq<QueryResult>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QueryResult[]{queryResult}))));
            int countQueryResultId = BoxesRunTime.unboxToInt((Object)((IterableLike)insertedQueryResultIds.apply((Object)ResultOutputType$.MODULE$.PATIENT_COUNT_XML())).head());
            this.dao().insertCountResult(countQueryResultId, -1L, -1L);
        });
        return new RunQueryResponse(masterId, XmlDateHelper$.MODULE$.now(), authnToUse.username(), groupId, request.queryDefinition(), queryInstanceId, queryResult);
    }

    private ShrineResponse runQuery(AuthenticationInfo authnToUse, BroadcastMessage message, RunQueryRequest request) {
        ErrorResponse result;
        block5: {
            ErrorResponse errorResponse;
            BaseShrineResponse baseShrineResponse;
            if (this.collectAdapterAudit()) {
                AdapterAuditDb$.MODULE$.db().insertExecutionStarted(request);
            }
            if ((baseShrineResponse = super.processRequest(message)) instanceof ErrorResponse) {
                ErrorResponse errorResponse2;
                errorResponse = errorResponse2 = (ErrorResponse)baseShrineResponse;
            } else if (baseShrineResponse instanceof RawCrcRunQueryResponse) {
                RawCrcRunQueryResponse rawCrcRunQueryResponse = (RawCrcRunQueryResponse)baseShrineResponse;
                errorResponse = this.processRawCrcRunQueryResponse(authnToUse, request, rawCrcRunQueryResponse);
            } else {
                throw new MatchError((Object)baseShrineResponse);
            }
            result = errorResponse;
            if (!this.collectAdapterAudit()) break block5;
            AdapterAuditDb$.MODULE$.db().insertExecutionCompletedShrineResponse(request, (ShrineResponse)result);
        }
        return result;
    }

    public RunQueryResponse processRawCrcRunQueryResponse(AuthenticationInfo authnToUse, RunQueryRequest request, RawCrcRunQueryResponse rawRunQueryResponse) {
        Seq originalResults = rawRunQueryResponse.results();
        Tuple2 tuple2 = originalResults.partition((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.isBreakdown$1(result)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq originalBreakdownResults = (Seq)tuple2._1();
        Seq originalNonBreakDownResults = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)originalBreakdownResults, (Object)originalNonBreakDownResults);
        Tuple2 tuple23 = tuple22;
        Seq originalBreakdownResults2 = (Seq)tuple23._1();
        Seq originalNonBreakDownResults2 = (Seq)tuple23._2();
        Seq<QueryResult> resultsWithLeastCompleteState = this.resultsWithCountStateOfLeastCompleteState(request, (Seq<QueryResult>)originalResults, (Seq<QueryResult>)originalBreakdownResults2);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("resultsWithLeastCompleteState is ").append(resultsWithLeastCompleteState).toString());
        QueryResult countResultWithLeastCompleteState = (QueryResult)((IterableLike)resultsWithLeastCompleteState.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$processRawCrcRunQueryResponse$4(x$8)))).head();
        Seq<Tuple2<QueryResult, Try<QueryResult>>> originalBreakdownCountAttempts = countResultWithLeastCompleteState.statusType().isDone() && !countResultWithLeastCompleteState.statusType().isError() ? this.attemptToRetrieveBreakdowns(request, (Seq<QueryResult>)originalBreakdownResults2) : (Seq<Tuple2<QueryResult, Try<QueryResult>>>)Seq$.MODULE$.empty();
        Tuple2 tuple24 = originalBreakdownCountAttempts.partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$processRawCrcRunQueryResponse$6(x0$1)));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Seq successfulBreakdownCountAttempts = (Seq)tuple24._1();
        Seq failedBreakdownCountAttempts = (Seq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)successfulBreakdownCountAttempts, (Object)failedBreakdownCountAttempts);
        Tuple2 tuple26 = tuple25;
        Seq successfulBreakdownCountAttempts2 = (Seq)tuple26._1();
        Seq failedBreakdownCountAttempts2 = (Seq)tuple26._2();
        Seq failedBreakdownCountAttemptsWithProblems = (Seq)failedBreakdownCountAttempts2.map((Function1 & Serializable & scala.Serializable)attempt -> {
            QueryResult queryResult;
            QueryResult originalResult = (QueryResult)attempt._1();
            if (originalResult.problem().isDefined()) {
                queryResult = originalResult;
            } else {
                QueryResult queryResult2;
                Try try_ = (Try)attempt._2();
                if (try_ instanceof Success) {
                    queryResult2 = originalResult;
                } else if (try_ instanceof Failure) {
                    AbstractProblem abstractProblem;
                    Failure failure = (Failure)try_;
                    Throwable x = failure.exception();
                    Throwable throwable = x;
                    if (throwable instanceof ErrorFromCrcException) {
                        ErrorFromCrcException errorFromCrcException = (ErrorFromCrcException)throwable;
                        abstractProblem = new ErrorFromCrcBreakdown(errorFromCrcException);
                    } else if (throwable instanceof MissingCrCXmlResultException) {
                        MissingCrCXmlResultException missingCrCXmlResultException = (MissingCrCXmlResultException)throwable;
                        abstractProblem = new CannotInterpretCrcBreakdownXml(missingCrCXmlResultException);
                    } else {
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            String summary = "Unexpected exception while interpreting breakdown response";
                            abstractProblem = ProblemNotYetEncoded$.MODULE$.apply(summary, e);
                        } else {
                            throw new MatchError((Object)throwable);
                        }
                    }
                    ErrorFromCrcBreakdown problem = abstractProblem;
                    QueryResult.StatusType x$1 = QueryResult.StatusType$.MODULE$.Error();
                    Some x$2 = new Some((Object)problem.summary());
                    Some x$3 = new Some((Object)problem);
                    long x$4 = originalResult.copy$default$1();
                    long x$5 = originalResult.copy$default$2();
                    Option x$6 = originalResult.copy$default$3();
                    long x$7 = originalResult.copy$default$4();
                    Option x$8 = originalResult.copy$default$5();
                    Option x$9 = originalResult.copy$default$6();
                    Option x$10 = originalResult.copy$default$7();
                    Map x$11 = originalResult.copy$default$11();
                    queryResult2 = originalResult.copy(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1, (Option)x$2, (Option)x$3, x$11);
                } else {
                    throw new MatchError((Object)try_);
                }
                queryResult = queryResult2;
            }
            QueryResult queryResult3 = queryResult;
            return new Tuple2((Object)queryResult3, attempt._2());
        }, Seq$.MODULE$.canBuildFrom());
        this.logBreakdownFailures(rawRunQueryResponse, (Seq<Tuple2<QueryResult, Try<QueryResult>>>)failedBreakdownCountAttemptsWithProblems);
        Seq successAndFailedBreakdowns = (Seq)((TraversableLike)successfulBreakdownCountAttempts2.map((Function1 & Serializable & scala.Serializable)x$11 -> (QueryResult)((Try)x$11._2()).get(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)failedBreakdownCountAttemptsWithProblems.map((Function1 & Serializable & scala.Serializable)x$12 -> (QueryResult)x$12._1(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq withBreakdownCounts = (Seq)successfulBreakdownCountAttempts2.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<QueryResult, Try<QueryResult>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Try try_;
                A1 A1 = x1;
                if (A1 != null && (try_ = (Try)A1._2()) instanceof Success) {
                    Success success = (Success)try_;
                    QueryResult queryResultWithBreakdowns = (QueryResult)success.value();
                    object = queryResultWithBreakdowns;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<QueryResult, Try<QueryResult>> x1) {
                Try try_;
                Tuple2<QueryResult, Try<QueryResult>> tuple2 = x1;
                boolean bl = tuple2 != null && (try_ = (Try)tuple2._2()) instanceof Success;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map originalMergedBreakdowns = (Map)((TraversableOnce)withBreakdownCounts.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.breakdowns(), Seq$.MODULE$.canBuildFrom())).fold((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x$14, x$15) -> x$14.$plus$plus((GenTraversableOnce)x$15));
        Seq<QueryResult> resultWithBreakdownState = this.resultsWithCountStateOfLeastCompleteState(request, resultsWithLeastCompleteState, (Seq<QueryResult>)successAndFailedBreakdowns);
        Seq obfuscatedQueryResults = (Seq)resultWithBreakdownState.map((Function1 & Serializable & scala.Serializable)result -> this.obfuscator().obfuscate((QueryResult)result), Seq$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("obfuscatedQueryResults is ").append(obfuscatedQueryResults).toString());
        Seq obfuscatedNonBreakdownQueryResults = (Seq)obfuscatedQueryResults.filterNot((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.isBreakdown$1(result)));
        Map obfuscatedMergedBreakdowns = originalMergedBreakdowns.mapValues((Function1 & Serializable & scala.Serializable)x$16 -> x$16.mapValues((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)l -> this.obfuscator().obfuscate(l)));
        Seq failedBreakdownTypes = (Seq)failedBreakdownCountAttemptsWithProblems.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            QueryResult qr = (QueryResult)tuple2._1();
            Iterable iterable = Option$.MODULE$.option2Iterable(qr.resultType());
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        this.dao().storeResults(authnToUse, ((Object)BoxesRunTime.boxToLong((long)rawRunQueryResponse.queryId())).toString(), request.networkQueryId(), request.queryDefinition(), resultWithBreakdownState, (Seq<QueryResult>)obfuscatedQueryResults, (Seq<ResultOutputType>)failedBreakdownTypes, (Map<ResultOutputType, I2b2ResultEnvelope>)originalMergedBreakdowns, (Map<ResultOutputType, I2b2ResultEnvelope>)obfuscatedMergedBreakdowns);
        Seq queryResults = this.doObfuscation() ? obfuscatedNonBreakdownQueryResults : originalNonBreakDownResults2;
        Map breakdownsToReturn = this.doObfuscation() ? obfuscatedMergedBreakdowns : originalMergedBreakdowns;
        QueryResult obfuscatedCountResult = (QueryResult)((IterableLike)queryResults.filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$processRawCrcRunQueryResponse$18(x$17)))).head();
        QueryResult resultWithBreakdowns = obfuscatedCountResult.withBreakdowns(breakdownsToReturn);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("resultWithBreakdowns is ").append(resultWithBreakdowns).toString());
        if (this.debugEnabled()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Returning QueryResult with count ").append(resultWithBreakdowns.setSize()).append(" ").toString());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Returning QueryResult with breakdowns ").append(RunQueryAdapter.justBreakdowns$1(resultWithBreakdowns.breakdowns())).append(" ").toString());
        }
        Option problem = failedBreakdownCountAttemptsWithProblems.headOption().flatMap((Function1 & Serializable & scala.Serializable)x -> ((QueryResult)x._1()).problem());
        QueryResult queryResult = (QueryResult)problem.fold((Function0 & Serializable & scala.Serializable)() -> resultWithBreakdowns, (Function1 & Serializable & scala.Serializable)pd -> resultWithBreakdowns.problem().isEmpty() ? QueryResult$.MODULE$.errorResult((Option)new Some((Object)pd.description()), "Error in breakdown from CRC", pd) : resultWithBreakdowns);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Final queryResult: ").append(queryResult).toString());
        return rawRunQueryResponse.toRunQueryResponse().withResult(queryResult);
    }

    private Seq<QueryResult> resultsWithCountStateOfLeastCompleteState(RunQueryRequest request, Seq<QueryResult> originalResults, Seq<QueryResult> originalBreakdownResults) {
        Seq seq;
        boolean expectedBreakdownsAreAbsentFromRaw;
        QueryResult countResult = (QueryResult)((IterableLike)originalResults.filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$resultsWithCountStateOfLeastCompleteState$1(x$20)))).head();
        QueryResult.StatusType countQueryState = countResult.statusType();
        Option firstBreakdownError = originalBreakdownResults.find((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$resultsWithCountStateOfLeastCompleteState$3(x$22)));
        Option firstBreakdownQueued = originalBreakdownResults.find((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$resultsWithCountStateOfLeastCompleteState$4(x$23)));
        boolean bl = expectedBreakdownsAreAbsentFromRaw = request.outputTypes().exists((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)x$24.isBreakdown())) && originalBreakdownResults.isEmpty();
        if (countQueryState.isError()) {
            seq = originalResults;
        } else if (firstBreakdownError.isDefined()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QueryResult[]{countResult.consolidateWithError((QueryResult)firstBreakdownError.get())}));
        } else if (countQueryState.crcPromisedToFinishAfterReply()) {
            seq = originalResults;
        } else if (firstBreakdownQueued.isDefined()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QueryResult[]{countResult.withStatus(((QueryResult)firstBreakdownQueued.get()).statusType(), ((QueryResult)firstBreakdownQueued.get()).statusMessage().orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"No status message for the firstBreakdownQueued")))}));
        } else if (expectedBreakdownsAreAbsentFromRaw) {
            QueryResult[] queryResultArray = new QueryResult[1];
            QueryResult.StatusType x$1 = QueryResult.StatusType$.MODULE$.Processing();
            Some x$2 = new Some((Object)"The CRC does not know about the breakdowns yet, but should soon");
            long x$3 = countResult.copy$default$1();
            long x$4 = countResult.copy$default$2();
            Option x$5 = countResult.copy$default$3();
            long x$6 = countResult.copy$default$4();
            Option x$7 = countResult.copy$default$5();
            Option x$8 = countResult.copy$default$6();
            Option x$9 = countResult.copy$default$7();
            Option x$10 = countResult.copy$default$10();
            Map x$11 = countResult.copy$default$11();
            queryResultArray[0] = countResult.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$1, (Option)x$2, x$10, x$11);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])queryResultArray));
        } else {
            seq = originalResults;
        }
        return seq;
    }

    private Try<ReadResultResponse> getResultFromCrc(RunQueryRequest parentRequest, long networkResultId) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Elem)XML$.MODULE$.loadString(this.callCrc((ShrineRequest)this.readResultRequest$1(parentRequest, networkResultId)))).flatMap((Function1 & Serializable & scala.Serializable)xml -> ReadResultResponse$.MODULE$.fromI2b2(this.breakdownTypes(), xml));
    }

    public Tuple2<QueryResult, Try<QueryResult>> attemptToRetrieveCount(RunQueryRequest runQueryReq, QueryResult originalCountQueryResult) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)originalCountQueryResult), (Object)this.getResultFromCrc(runQueryReq, originalCountQueryResult.resultId()).map((Function1 & Serializable & scala.Serializable)countData -> originalCountQueryResult.withSetSize(countData.metadata().setSize())));
    }

    public Seq<Tuple2<QueryResult, Try<QueryResult>>> attemptToRetrieveBreakdowns(RunQueryRequest runQueryReq, Seq<QueryResult> breakdownResults) {
        return (Seq)breakdownResults.map((Function1 & Serializable & scala.Serializable)origBreakdownResult -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(origBreakdownResult), (Object)this.getResultFromCrc(runQueryReq, origBreakdownResult.resultId()).map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.data()).map((Function1 & Serializable & scala.Serializable)breakdownData -> origBreakdownResult.withBreakdown(breakdownData))), Seq$.MODULE$.canBuildFrom());
    }

    public void logBreakdownFailures(RawCrcRunQueryResponse response, Seq<Tuple2<QueryResult, Try<QueryResult>>> failures) {
        failures.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$logBreakdownFailures$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$26 -> {
            RunQueryAdapter.$anonfun$logBreakdownFailures$2(this, response, x$26);
            return BoxedUnit.UNIT;
        });
    }

    private void logStartup() {
        String message = this.runQueriesImmediately() ? new StringBuilder(29).append(this.getClass().getSimpleName()).append(" will run queries immediately").toString() : new StringBuilder(39).append(this.getClass().getSimpleName()).append(" will queue queries for later execution").toString();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
    }

    public RunQueryAdapter copy(Poster poster, AdapterDao dao, HiveCredentials hiveCredentials, QueryDefinitionTranslator conceptTranslator, boolean doObfuscation, boolean runQueriesImmediately, Set<ResultOutputType> breakdownTypes, boolean collectAdapterAudit, Seq<Tuple2<Object, Duration>> botCountTimeThresholds, Obfuscator obfuscator, Duration crcRunQueryTimeLimit, BouncyKeyStoreCollection certCollection) {
        return new RunQueryAdapter(poster, dao, hiveCredentials, conceptTranslator, doObfuscation, runQueriesImmediately, breakdownTypes, collectAdapterAudit, botCountTimeThresholds, obfuscator, crcRunQueryTimeLimit, certCollection);
    }

    public Poster copy$default$1() {
        return this.poster();
    }

    public Obfuscator copy$default$10() {
        return this.obfuscator();
    }

    public Duration copy$default$11() {
        return this.crcRunQueryTimeLimit();
    }

    public BouncyKeyStoreCollection copy$default$12() {
        return this.certCollection();
    }

    public AdapterDao copy$default$2() {
        return this.dao();
    }

    public HiveCredentials copy$default$3() {
        return this.hiveCredentials();
    }

    public QueryDefinitionTranslator copy$default$4() {
        return this.conceptTranslator();
    }

    public boolean copy$default$5() {
        return this.doObfuscation();
    }

    public boolean copy$default$6() {
        return this.runQueriesImmediately();
    }

    public Set<ResultOutputType> copy$default$7() {
        return this.breakdownTypes();
    }

    public boolean copy$default$8() {
        return this.collectAdapterAudit();
    }

    public Seq<Tuple2<Object, Duration>> copy$default$9() {
        return this.botCountTimeThresholds();
    }

    public String productPrefix() {
        return "RunQueryAdapter";
    }

    public int productArity() {
        return 12;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.poster();
                break;
            }
            case 1: {
                object = this.dao();
                break;
            }
            case 2: {
                object = this.hiveCredentials();
                break;
            }
            case 3: {
                object = this.conceptTranslator();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.doObfuscation());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.runQueriesImmediately());
                break;
            }
            case 6: {
                object = this.breakdownTypes();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean((boolean)this.collectAdapterAudit());
                break;
            }
            case 8: {
                object = this.botCountTimeThresholds();
                break;
            }
            case 9: {
                object = this.obfuscator();
                break;
            }
            case 10: {
                object = this.crcRunQueryTimeLimit();
                break;
            }
            case 11: {
                object = this.certCollection();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RunQueryAdapter;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.poster()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dao()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.hiveCredentials()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.conceptTranslator()));
        n = Statics.mix((int)n, (int)(this.doObfuscation() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.runQueriesImmediately() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.breakdownTypes()));
        n = Statics.mix((int)n, (int)(this.collectAdapterAudit() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.botCountTimeThresholds()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.obfuscator()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.crcRunQueryTimeLimit()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.certCollection()));
        return Statics.finalizeHash((int)n, (int)12);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RunQueryAdapter)) return false;
        boolean bl = true;
        if (!bl) return false;
        RunQueryAdapter runQueryAdapter = (RunQueryAdapter)x$1;
        Poster poster = this.poster();
        Poster poster2 = runQueryAdapter.poster();
        if (poster == null) {
            if (poster2 != null) {
                return false;
            }
        } else if (!poster.equals(poster2)) return false;
        AdapterDao adapterDao = this.dao();
        AdapterDao adapterDao2 = runQueryAdapter.dao();
        if (adapterDao == null) {
            if (adapterDao2 != null) {
                return false;
            }
        } else if (!adapterDao.equals(adapterDao2)) return false;
        HiveCredentials hiveCredentials = this.hiveCredentials();
        HiveCredentials hiveCredentials2 = runQueryAdapter.hiveCredentials();
        if (hiveCredentials == null) {
            if (hiveCredentials2 != null) {
                return false;
            }
        } else if (!hiveCredentials.equals(hiveCredentials2)) return false;
        QueryDefinitionTranslator queryDefinitionTranslator = this.conceptTranslator();
        QueryDefinitionTranslator queryDefinitionTranslator2 = runQueryAdapter.conceptTranslator();
        if (queryDefinitionTranslator == null) {
            if (queryDefinitionTranslator2 != null) {
                return false;
            }
        } else if (!queryDefinitionTranslator.equals(queryDefinitionTranslator2)) return false;
        if (this.doObfuscation() != runQueryAdapter.doObfuscation()) return false;
        if (this.runQueriesImmediately() != runQueryAdapter.runQueriesImmediately()) return false;
        Set<ResultOutputType> set = this.breakdownTypes();
        Set<ResultOutputType> set2 = runQueryAdapter.breakdownTypes();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        if (this.collectAdapterAudit() != runQueryAdapter.collectAdapterAudit()) return false;
        Seq<Tuple2<Object, Duration>> seq = this.botCountTimeThresholds();
        Seq<Tuple2<Object, Duration>> seq2 = runQueryAdapter.botCountTimeThresholds();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Obfuscator obfuscator = this.obfuscator();
        Obfuscator obfuscator2 = runQueryAdapter.obfuscator();
        if (obfuscator == null) {
            if (obfuscator2 != null) {
                return false;
            }
        } else if (!((Object)obfuscator).equals(obfuscator2)) return false;
        Duration duration = this.crcRunQueryTimeLimit();
        Duration duration2 = runQueryAdapter.crcRunQueryTimeLimit();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!duration.equals(duration2)) return false;
        BouncyKeyStoreCollection bouncyKeyStoreCollection = this.certCollection();
        BouncyKeyStoreCollection bouncyKeyStoreCollection2 = runQueryAdapter.certCollection();
        if (bouncyKeyStoreCollection == null) {
            if (bouncyKeyStoreCollection2 == null) return true;
            return false;
        } else {
            if (!bouncyKeyStoreCollection.equals(bouncyKeyStoreCollection2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ void $anonfun$runQueryForExpectedResult$13(long queryId$1, ShrineResponse x$3) {
        AdapterAuditDb$.MODULE$.db().insertResultSent(queryId$1, x$3);
    }

    public static final /* synthetic */ void $anonfun$runQueryForExpectedResult$12(RunQueryAdapter $this, long queryId$1, Tuple2 r) {
        block0: {
            $this.sendUpdateResult((UpdateResult)r._1());
            if (!$this.collectAdapterAudit()) break block0;
            ((Option)r._2()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                RunQueryAdapter.$anonfun$runQueryForExpectedResult$13(queryId$1, x$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static final boolean isBreakdown$1(QueryResult result) {
        return result.resultType().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isBreakdown()));
    }

    public static final /* synthetic */ boolean $anonfun$processRawCrcRunQueryResponse$5(ResultOutputType x$9) {
        return !x$9.isBreakdown();
    }

    public static final /* synthetic */ boolean $anonfun$processRawCrcRunQueryResponse$4(QueryResult x$8) {
        return x$8.resultType().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$processRawCrcRunQueryResponse$5(x$9)));
    }

    public static final /* synthetic */ boolean $anonfun$processRawCrcRunQueryResponse$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Try t = (Try)tuple2._2();
        boolean bl = t.isSuccess();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$processRawCrcRunQueryResponse$19(ResultOutputType x$18) {
        return !x$18.isBreakdown();
    }

    public static final /* synthetic */ boolean $anonfun$processRawCrcRunQueryResponse$18(QueryResult x$17) {
        return x$17.resultType().exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$processRawCrcRunQueryResponse$19(x$18)));
    }

    private static final Map justBreakdowns$1(Map breakdowns) {
        return breakdowns.mapValues((Function1 & Serializable & scala.Serializable)x$19 -> x$19.data());
    }

    public static final /* synthetic */ boolean $anonfun$resultsWithCountStateOfLeastCompleteState$2(ResultOutputType x$21) {
        return !x$21.isBreakdown();
    }

    public static final /* synthetic */ boolean $anonfun$resultsWithCountStateOfLeastCompleteState$1(QueryResult x$20) {
        return x$20.resultType().exists((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)RunQueryAdapter.$anonfun$resultsWithCountStateOfLeastCompleteState$2(x$21)));
    }

    public static final /* synthetic */ boolean $anonfun$resultsWithCountStateOfLeastCompleteState$3(QueryResult x$22) {
        return x$22.statusType().isError();
    }

    public static final /* synthetic */ boolean $anonfun$resultsWithCountStateOfLeastCompleteState$4(QueryResult x$23) {
        return !x$23.statusType().isDone();
    }

    private final ReadResultRequest readResultRequest$1(RunQueryRequest runQueryReq, long networkResultId) {
        return new ReadResultRequest(this.hiveCredentials().projectId(), runQueryReq.waitTime(), this.hiveCredentials().toAuthenticationInfo(), ((Object)BoxesRunTime.boxToLong((long)networkResultId)).toString());
    }

    public static final /* synthetic */ boolean $anonfun$logBreakdownFailures$1(Tuple2 check$ifrefutable$1) {
        Try try_;
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null && (try_ = (Try)tuple2._2()) instanceof Failure;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$logBreakdownFailures$2(RunQueryAdapter $this, RawCrcRunQueryResponse response$1, Tuple2 x$26) {
        Try try_;
        QueryResult origQueryResult;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$26;
                if (tuple2 == null) break block2;
                origQueryResult = (QueryResult)tuple2._1();
                try_ = (Try)tuple2._2();
                if (try_ instanceof Failure) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        Failure failure = (Failure)try_;
        Throwable e = failure.exception();
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(106).append("Couldn't load breakdown for QueryResult with masterId: ").append(response$1.queryId()).append(", instanceId: ").append(origQueryResult.instanceId()).append(", resultId: ").append(origQueryResult.resultId()).append(". Asked for result type: ").append(origQueryResult.resultType()).toString(), e);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public RunQueryAdapter(Poster poster, AdapterDao dao, HiveCredentials hiveCredentials, QueryDefinitionTranslator conceptTranslator, boolean doObfuscation, boolean runQueriesImmediately, Set<ResultOutputType> breakdownTypes, boolean collectAdapterAudit, Seq<Tuple2<Object, Duration>> botCountTimeThresholds, Obfuscator obfuscator, Duration crcRunQueryTimeLimit, BouncyKeyStoreCollection certCollection) {
        this.poster = poster;
        this.dao = dao;
        this.hiveCredentials = hiveCredentials;
        this.conceptTranslator = conceptTranslator;
        this.doObfuscation = doObfuscation;
        this.runQueriesImmediately = runQueriesImmediately;
        this.breakdownTypes = breakdownTypes;
        this.collectAdapterAudit = collectAdapterAudit;
        this.botCountTimeThresholds = botCountTimeThresholds;
        this.obfuscator = obfuscator;
        this.crcRunQueryTimeLimit = crcRunQueryTimeLimit;
        this.certCollection = certCollection;
        super(poster, hiveCredentials);
        Product.$init$((Product)this);
        this.logStartup();
    }
}

