/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.dao.squeryl;

import ch.qos.logback.classic.Logger;
import java.io.Serializable;
import java.sql.Timestamp;
import javax.xml.datatype.XMLGregorianCalendar;
import net.shrine.adapter.dao.AdapterDao;
import net.shrine.adapter.dao.BotDetectedException;
import net.shrine.adapter.dao.QueryResultStatus;
import net.shrine.adapter.dao.model.BreakdownResultRow;
import net.shrine.adapter.dao.model.CountRow;
import net.shrine.adapter.dao.model.ObfuscatedPair;
import net.shrine.adapter.dao.model.QueryResultRow;
import net.shrine.adapter.dao.model.ShrineError;
import net.shrine.adapter.dao.model.ShrineQuery;
import net.shrine.adapter.dao.model.ShrineQueryResult;
import net.shrine.adapter.dao.model.ShrineQueryResult$;
import net.shrine.adapter.dao.model.squeryl.SquerylBreakdownResultRow;
import net.shrine.adapter.dao.model.squeryl.SquerylCountRow;
import net.shrine.adapter.dao.model.squeryl.SquerylQueryResultRow;
import net.shrine.adapter.dao.model.squeryl.SquerylShrineError;
import net.shrine.adapter.dao.model.squeryl.SquerylShrineQuery;
import net.shrine.adapter.dao.squeryl.SquerylAdapterDao$BreakdownFailure$1$;
import net.shrine.adapter.dao.squeryl.SquerylAdapterDao$Queries$;
import net.shrine.adapter.dao.squeryl.tables.Tables;
import net.shrine.dao.squeryl.SquerylEntryPoint$;
import net.shrine.dao.squeryl.SquerylInitializer;
import net.shrine.log.Loggable;
import net.shrine.problem.Problem;
import net.shrine.problem.RawProblem;
import net.shrine.problem.XmlProblemDigest;
import net.shrine.problem.XmlProblemDigest$;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.I2b2ResultEnvelope;
import net.shrine.protocol.QueryResult;
import net.shrine.protocol.ResultOutputType;
import net.shrine.protocol.ResultOutputType$;
import net.shrine.protocol.query.QueryDefinition;
import net.shrine.protocol.version.v1.Researcher;
import net.shrine.util.XmlDateHelper$;
import org.squeryl.Query;
import org.squeryl.dsl.Measures;
import org.squeryl.dsl.ast.UpdateAssignment;
import org.squeryl.dsl.internal.JoinedQueryable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.xml.NodeSeq;

@ScalaSignature(bytes="\u0006\u0001\rUe\u0001B\u00181\u0005mB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A\u0011\f\u0001B\u0001B\u0003-!\fC\u0003l\u0001\u0011\u0005A\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\t\u0003S\u0003A\u0011\u0001\u001b\u0002,\"A\u00111\u0019\u0001\u0005\u0002Q\n)\r\u0003\u0005\u0002N\u0002!\t\u0001NAh\u0011\u001d\t)\u000e\u0001C!\u0003/Dq!a;\u0001\t\u0003\ti\u000fC\u0004\u0002|\u0002!\t%!@\t\u000f\t\u0015\u0001\u0001\"\u0011\u0003\b!9!1\u0002\u0001\u0005B\t5\u0001B\u0003B\t\u0001!\u0015\r\u0011\"\u0003\u0003\u0014!9!q\u0004\u0001\u0005B\t\u0005\u0002b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005W\u0001A\u0011\tB'\u0011\u001d\u00119\u0007\u0001C!\u0005SBqA!!\u0001\t\u0003\u0012\u0019\tC\u0004\u0003\f\u0002!\tE!$\t\u000f\tm\u0005\u0001\"\u0011\u0003\u001e\"9!\u0011\u0016\u0001\u0005B\t-\u0006b\u0002Bk\u0001\u0011\u0005#q\u001b\u0005\b\u0005;\u0004A\u0011\tBp\u0011\u001d\u0011Y\u000f\u0001C!\u0005[DqA!=\u0001\t\u0003\u0012\u0019pB\u0004\u0003\u0000\u0002A\ta!\u0001\u0007\u000f\r\u0015\u0001\u0001#\u0001\u0004\b!11\u000e\tC\u0001\u0007\u0013Aqaa\u0003!\t\u0003\u0019i\u0001C\u0005\u00042\u0001\u0012\r\u0011\"\u0001\u00044!A1Q\b\u0011!\u0002\u0013\u0019)\u0004C\u0004\u0004@\u0001\"\ta!\u0011\t\u000f\r\u001d\u0003\u0005\"\u0001\u0004J!I1Q\n\u0011C\u0002\u0013\u00051q\n\u0005\t\u0007'\u0002\u0003\u0015!\u0003\u0004R!91Q\u000b\u0011\u0005\u0002\r]\u0003bBB.A\u0011\u00051Q\f\u0005\b\u0007G\u0002C\u0011AB3\u0011\u001d\u0019\t\b\tC\u0001\u0007gBqaa\u001e!\t\u0003\u0019I\bC\u0004\u0004\u0006\u0002\"\taa\"\u0003#M\u000bX/\u001a:zY\u0006#\u0017\r\u001d;fe\u0012\u000bwN\u0003\u00022e\u000591/];fefd'BA\u001a5\u0003\r!\u0017m\u001c\u0006\u0003kY\nq!\u00193baR,'O\u0003\u00028q\u000511\u000f\u001b:j]\u0016T\u0011!O\u0001\u0004]\u0016$8\u0001A\n\u0005\u0001q\u0012e\t\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teH\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0007\u0012k\u0011AM\u0005\u0003\u000bJ\u0012!\"\u00113baR,'\u000fR1p!\t9%*D\u0001I\u0015\tIe'A\u0002m_\u001eL!a\u0013%\u0003\u00111{wmZ1cY\u0016\f1\"\u001b8ji&\fG.\u001b>feB\u0011a*U\u0007\u0002\u001f*\u0011\u0011\u0007\u0015\u0006\u0003gYJ!AU(\u0003%M\u000bX/\u001a:zY&s\u0017\u000e^5bY&TXM]\u0001\u0007i\u0006\u0014G.Z:\u0011\u0005U;V\"\u0001,\u000b\u0005M\u0003\u0014B\u0001-W\u0005\u0019!\u0016M\u00197fg\u0006q!M]3bW\u0012|wO\u001c+za\u0016\u001c\bcA.cK:\u0011A\f\u0019\t\u0003;zj\u0011A\u0018\u0006\u0003?j\na\u0001\u0010:p_Rt\u0014BA1?\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0004'\u0016$(BA1?!\t1\u0017.D\u0001h\u0015\tAg'\u0001\u0005qe>$xnY8m\u0013\tQwM\u0001\tSKN,H\u000e^(viB,H\u000fV=qK\u00061A(\u001b8jiz\"2!\\9s)\tq\u0007\u000f\u0005\u0002p\u00015\t\u0001\u0007C\u0003Z\t\u0001\u000f!\fC\u0003M\t\u0001\u0007Q\nC\u0003T\t\u0001\u0007A+A\u0007j]R\u0013\u0018M\\:bGRLwN\\\u000b\u0003kb$2A^A\u0002!\t9\b\u0010\u0004\u0001\u0005\u000be,!\u0019\u0001>\u0003\u0003Q\u000b\"a\u001f@\u0011\u0005ub\u0018BA??\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!P@\n\u0007\u0005\u0005aHA\u0002B]fD\u0001\"!\u0002\u0006\t\u0003\u0007\u0011qA\u0001\u0002MB!Q(!\u0003w\u0013\r\tYA\u0010\u0002\ty\tLh.Y7f}\u0005Ia\r\\1h#V,'/\u001f\u000b\u0007\u0003#\t9\"!\t\u0011\u0007u\n\u0019\"C\u0002\u0002\u0016y\u0012A!\u00168ji\"9\u0011\u0011\u0004\u0004A\u0002\u0005m\u0011A\u00048fi^|'o[)vKJL\u0018\n\u001a\t\u0004{\u0005u\u0011bAA\u0010}\t!Aj\u001c8h\u0011\u001d\t\u0019C\u0002a\u0001\u0003K\t1B\u001a7bO6+7o]1hKB)Q(a\n\u0002,%\u0019\u0011\u0011\u0006 \u0003\r=\u0003H/[8o!\rY\u0016QF\u0005\u0004\u0003_!'AB*ue&tw-A\u0006v]\u001ac\u0017mZ)vKJLH\u0003BA\t\u0003kAq!!\u0007\b\u0001\u0004\tY\"A\bnkR\fG/\u001a$mC\u001e4\u0015.\u001a7e)!\t\t\"a\u000f\u0002>\u0005\u001d\u0003bBA\r\u0011\u0001\u0007\u00111\u0004\u0005\b\u0003\u007fA\u0001\u0019AA!\u00031qWm^%t\r2\fwmZ3e!\ri\u00141I\u0005\u0004\u0003\u000br$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0013B\u0001\u0019AA\u0013\u00039qWm\u001e$mC\u001elUm]:bO\u0016\fAb\u001d;pe\u0016\u0014Vm];miN$B#!\u0005\u0002P\u0005e\u0013QLA0\u0003_\nY)a$\u0002\u0016\u0006\u0015\u0006bBA)\u0013\u0001\u0007\u00111K\u0001\u0006CV$\bN\u001c\t\u0004M\u0006U\u0013bAA,O\n\u0011\u0012)\u001e;iK:$\u0018nY1uS>t\u0017J\u001c4p\u0011\u001d\tY&\u0003a\u0001\u0003W\t\u0001\"\\1ti\u0016\u0014\u0018\n\u001a\u0005\b\u00033I\u0001\u0019AA\u000e\u0011\u001d\t\t'\u0003a\u0001\u0003G\nq\"];fef$UMZ5oSRLwN\u001c\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011N4\u0002\u000bE,XM]=\n\t\u00055\u0014q\r\u0002\u0010#V,'/\u001f#fM&t\u0017\u000e^5p]\"9\u0011\u0011O\u0005A\u0002\u0005M\u0014a\u0004:boF+XM]=SKN,H\u000e^:\u0011\r\u0005U\u0014qPAC\u001d\u0011\t9(a\u001f\u000f\u0007u\u000bI(C\u0001@\u0013\r\tiHP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t)a!\u0003\u0007M+\u0017OC\u0002\u0002~y\u00022AZAD\u0013\r\tIi\u001a\u0002\f#V,'/\u001f*fgVdG\u000fC\u0004\u0002\u000e&\u0001\r!a\u001d\u0002-=\u0014g-^:dCR,G-U;fef\u0014Vm];miNDq!!%\n\u0001\u0004\t\u0019*\u0001\u000bgC&dW\r\u001a\"sK\u0006\\Gm\\<o)f\u0004Xm\u001d\t\u0006\u0003k\ny(\u001a\u0005\b\u0003/K\u0001\u0019AAM\u0003AiWM]4fI\n\u0013X-Y6e_^t7\u000f\u0005\u0004\\\u00037+\u0017qT\u0005\u0004\u0003;#'aA'baB\u0019a-!)\n\u0007\u0005\rvM\u0001\nJe\t\u0014$+Z:vYR,eN^3m_B,\u0007bBAT\u0013\u0001\u0007\u0011\u0011T\u0001\u0015_\n4Wo]2bi\u0016$'I]3bW\u0012|wO\\:\u0002#M$xN]3D_VtGOU3tk2$8\u000f\u0006\u0005\u0002\u0012\u00055\u0016\u0011WA[\u0011\u001d\tyK\u0003a\u0001\u0003g\n1A]1x\u0011\u001d\t\u0019L\u0003a\u0001\u0003g\n!b\u001c2gkN\u001c\u0017\r^3e\u0011\u001d\t9L\u0003a\u0001\u0003s\u000b1\"\u001b8tKJ$X\rZ%egB11,a'f\u0003w\u0003b!!\u001e\u0002\u0000\u0005u\u0006cA\u001f\u0002@&\u0019\u0011\u0011\u0019 \u0003\u0007%sG/A\tti>\u0014X-\u0012:s_J\u0014Vm];miN$b!!\u0005\u0002H\u0006-\u0007bBAe\u0017\u0001\u0007\u00111O\u0001\be\u0016\u001cX\u000f\u001c;t\u0011\u001d\t9l\u0003a\u0001\u0003s\u000bac\u001d;pe\u0016\u0014%/Z1lI><hNR1jYV\u0014Xm\u001d\u000b\u0007\u0003#\t\t.a5\t\r\u0005EE\u00021\u0001[\u0011\u001d\t9\f\u0004a\u0001\u0003s\u000b\u0011CZ5oIJ+7-\u001a8u#V,'/[3t)\u0011\tI.a:\u0011\r\u0005U\u0014qPAn!\u0011\ti.a9\u000e\u0005\u0005}'bAAqe\u0005)Qn\u001c3fY&!\u0011Q]Ap\u0005-\u0019\u0006N]5oKF+XM]=\t\u000f\u0005%X\u00021\u0001\u0002>\u00069\u0001n\\<NC:L\u0018!\u00044j]\u0012\fE\u000e\\\"pk:$8\u000f\u0006\u0002\u0002pB1\u0011QOA@\u0003c\u0004B!a=\u0002x6\u0011\u0011Q\u001f\u0006\u0004c\u0005}\u0017\u0002BA}\u0003k\u0014qbU9vKJLHnQ8v]R\u0014vn^\u0001\fe\u0016t\u0017-\\3Rk\u0016\u0014\u0018\u0010\u0006\u0004\u0002\u0012\u0005}(\u0011\u0001\u0005\b\u00033y\u0001\u0019AA\u000e\u0011\u001d\u0011\u0019a\u0004a\u0001\u0003W\tqA\\3x\u001d\u0006lW-A\u0006eK2,G/Z)vKJLH\u0003BA\t\u0005\u0013Aq!!\u0007\u0011\u0001\u0004\tY\"A\u000beK2,G/Z)vKJL(+Z:vYR\u001chi\u001c:\u0015\t\u0005E!q\u0002\u0005\b\u00033\t\u0002\u0019AA\u000e\u0003=\t7o\u001b+iK\u000e\u00138m\u0015;bi\u0016\u001cXC\u0001B\u000b!\u0019\u00119B!\b\u0002,5\u0011!\u0011\u0004\u0006\u0004\u00057q\u0014AC2pY2,7\r^5p]&!\u0011\u0011\u0011B\r\u0003I1\u0017N\u001c3Rk\u0016,X\rZ)vKJL\u0018\nZ:\u0016\u0005\t\r\u0002CBA;\u0003\u007f\u0012)\u0003E\u0002D\u0005OI1A!\u000b3\u0005E\tV/\u001a:z%\u0016\u001cX\u000f\u001c;Ti\u0006$Xo]\u0001\u000bG\",7m[%g\u0005>$HCBA\t\u0005_\u0011\t\u0004C\u0004\u0002RQ\u0001\r!a\u0015\t\u000f\tMB\u00031\u0001\u00036\u0005\t\"m\u001c;US6,G\u000b\u001b:fg\"|G\u000eZ:\u0011\r\u0005U\u0014q\u0010B\u001c!\u001di$\u0011HA\u000e\u0005{I1Aa\u000f?\u0005\u0019!V\u000f\u001d7feA!!q\bB%\u001b\t\u0011\tE\u0003\u0003\u0003D\t\u0015\u0013\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\t\u001dc(\u0001\u0006d_:\u001cWO\u001d:f]RLAAa\u0013\u0003B\tAA)\u001e:bi&|g\u000e\u0006\u0004\u0002\u0012\t=#1\r\u0005\b\u0005#*\u0002\u0019\u0001B*\u0003)\u0011Xm]3be\u000eDWM\u001d\t\u0005\u0005+\u0012y&\u0004\u0002\u0003X)!!\u0011\fB.\u0003\t1\u0018GC\u0002\u0003^\u001d\fqA^3sg&|g.\u0003\u0003\u0003b\t]#A\u0003*fg\u0016\f'o\u00195fe\"9!QM\u000bA\u0002\tU\u0012aE2pk:$H+[7f)\"\u0014Xm\u001d5pY\u0012\u001c\u0018aC5og\u0016\u0014H/U;fef$\u0002#!0\u0003l\t=$1\u000fB;\u0005o\u0012YHa \t\u000f\t5d\u00031\u0001\u0002,\u0005iAn\\2bY6\u000b7\u000f^3s\u0013\u0012DqA!\u001d\u0017\u0001\u0004\tY\"A\u0005oKR<xN]6JI\"9\u0011\u0011\u000b\fA\u0002\u0005M\u0003bBA1-\u0001\u0007\u00111\r\u0005\b\u0005s2\u0002\u0019AA!\u0003%I7O\u00127bO\u001e,G\rC\u0004\u0003~Y\u0001\r!!\u0011\u0002\u0015!\f7OQ3f]J+h\u000eC\u0004\u0002$Y\u0001\r!!\n\u0002%%t7/\u001a:u#V,'/\u001f*fgVdGo\u001d\u000b\u0007\u0003s\u0013)I!#\t\u000f\t\u001du\u00031\u0001\u0002>\u0006i\u0001/\u0019:f]R\fV/\u001a:z\u0013\u0012Dq!!3\u0018\u0001\u0004\t\u0019(A\tj]N,'\u000f^\"pk:$(+Z:vYR$\u0002\"!\u0005\u0003\u0010\nM%q\u0013\u0005\b\u0005#C\u0002\u0019AA_\u0003!\u0011Xm];mi&#\u0007b\u0002BK1\u0001\u0007\u00111D\u0001\u000e_JLw-\u001b8bY\u000e{WO\u001c;\t\u000f\te\u0005\u00041\u0001\u0002\u001c\u0005yqN\u00194vg\u000e\fG/\u001a3D_VtG/\u0001\fj]N,'\u000f\u001e\"sK\u0006\\Gm\\<o%\u0016\u001cX\u000f\u001c;t)!\t\tBa(\u0003$\n\u001d\u0006b\u0002BQ3\u0001\u0007\u0011\u0011X\u0001\u0010a\u0006\u0014XM\u001c;SKN,H\u000e^%eg\"9!QU\rA\u0002\u0005e\u0015AE8sS\u001eLg.\u00197Ce\u0016\f7\u000eZ8x]NDq!a*\u001a\u0001\u0004\tI*A\tj]N,'\u000f^#se>\u0014(+Z:vYR$\u0002#!\u0005\u0003.\nE&Q\u0017B]\u0005{\u0013\tM!2\t\u000f\t=&\u00041\u0001\u0002>\u0006q\u0001/\u0019:f]R\u0014Vm];mi&#\u0007b\u0002BZ5\u0001\u0007\u00111F\u0001\rKJ\u0014xN]'fgN\fw-\u001a\u0005\b\u0005oS\u0002\u0019AA\u0016\u0003\u0015\u0019w\u000eZ3d\u0011\u001d\u0011YL\u0007a\u0001\u0003W\t\u0011b\u001d;b[B$V\r\u001f;\t\u000f\t}&\u00041\u0001\u0002,\u000591/^7nCJL\bb\u0002Bb5\u0001\u0007\u00111F\u0001\u0012I&<Wm\u001d;EKN\u001c'/\u001b9uS>t\u0007b\u0002Bd5\u0001\u0007!\u0011Z\u0001\u000bI\u0016$\u0018-\u001b7t16d\u0007\u0003\u0002Bf\u0005#l!A!4\u000b\u0007\t=g(A\u0002y[2LAAa5\u0003N\n9aj\u001c3f'\u0016\f\u0018\u0001\u00064j]\u0012\fV/\u001a:z\u0005ftU\r^<pe.LE\r\u0006\u0003\u0003Z\nm\u0007#B\u001f\u0002(\u0005m\u0007bBA\r7\u0001\u0007\u00111D\u0001\u001bM&tG-U;fe&,7OQ=Vg\u0016\u0014\u0018I\u001c3E_6\f\u0017N\u001c\u000b\t\u00033\u0014\tO!:\u0003j\"9!1\u001d\u000fA\u0002\u0005-\u0012A\u00023p[\u0006Lg\u000eC\u0004\u0003hr\u0001\r!a\u000b\u0002\u0011U\u001cXM\u001d8b[\u0016Dq!!;\u001d\u0001\u0004\ti,A\ngS:$\u0017+^3sS\u0016\u001c()\u001f#p[\u0006Lg\u000e\u0006\u0003\u0002Z\n=\bb\u0002Br;\u0001\u0007\u00111F\u0001\u000fM&tGMU3tk2$8OR8s)\u0011\u0011)P!@\u0011\u000bu\n9Ca>\u0011\t\u0005u'\u0011`\u0005\u0005\u0005w\fyNA\tTQJLg.Z)vKJL(+Z:vYRDq!!\u0007\u001f\u0001\u0004\tY\"A\u0004Rk\u0016\u0014\u0018.Z:\u0011\u0007\r\r\u0001%D\u0001\u0001\u0005\u001d\tV/\u001a:jKN\u001c\"\u0001\t\u001f\u0015\u0005\r\u0005\u0011\u0001G2pk:$\u0018+^3sS\u0016\u001chi\u001c:Vg\u0016\u00148+\u001b8dKRA1qBB\u0015\u0007W\u0019i\u0003\u0005\u0004\u0004\u0012\re1QD\u0007\u0003\u0007'Q1!MB\u000b\u0015\t\u00199\"A\u0002pe\u001eLAaa\u0007\u0004\u0014\t)\u0011+^3ssB11qDB\u0013\u00037i!a!\t\u000b\t\r\r21C\u0001\u0004INd\u0017\u0002BB\u0014\u0007C\u0011\u0001\"T3bgV\u0014Xm\u001d\u0005\b\u0005G\u0014\u0003\u0019AA\u0016\u0011\u001d\u00119O\ta\u0001\u0003WAqaa\f#\u0001\u0004\tY\"A\u0004tS:\u001cW-T:\u0002%E,XM]5fg\u001a{'/\u00117m+N,'o]\u000b\u0003\u0007k\u0001ba!\u0005\u0004\u001a\r]\u0002\u0003BAz\u0007sIAaa\u000f\u0002v\n\u00112+];fefd7\u000b\u001b:j]\u0016\fV/\u001a:z\u0003M\tX/\u001a:jKN4uN]!mYV\u001bXM]:!\u00039\tX/\u001a:jKN4uN]+tKJ$ba!\u000e\u0004D\r\u0015\u0003b\u0002BtK\u0001\u0007\u00111\u0006\u0005\b\u0005G,\u0003\u0019AA\u0016\u0003A\tX/\u001a:jKN4uN\u001d#p[\u0006Lg\u000e\u0006\u0003\u00046\r-\u0003b\u0002BrM\u0001\u0007\u00111F\u0001\u0010C2d7i\\;oiJ+7/\u001e7ugV\u00111\u0011\u000b\t\u0007\u0007#\u0019I\"!=\u0002!\u0005dGnQ8v]R\u0014Vm];miN\u0004\u0013AE9vKJLWm\u001d\"z\u001d\u0016$xo\u001c:l\u0013\u0012$Ba!\u000e\u0004Z!9\u0011\u0011D\u0015A\u0002\u0005m\u0011!F9vKJLh*Y7fg\nKh*\u001a;x_J\\\u0017\n\u001a\u000b\u0005\u0007?\u001a\t\u0007\u0005\u0004\u0004\u0012\re\u00111\u0006\u0005\b\u00033Q\u0003\u0019AA\u000e\u0003=\u0011Xm];miN4uN])vKJLH\u0003BB4\u0007_\u0002ba!\u0005\u0004\u001a\r%\u0004\u0003BAz\u0007WJAa!\u001c\u0002v\n)2+];fefd\u0017+^3ssJ+7/\u001e7u%><\bbBA\rW\u0001\u0007\u00111D\u0001\rG>,h\u000e\u001e*fgVdGo\u001d\u000b\u0005\u0007#\u001a)\bC\u0004\u0002\u001a1\u0002\r!a\u0007\u0002\u0019\u0015\u0014(o\u001c:SKN,H\u000e^:\u0015\t\rm41\u0011\t\u0007\u0007#\u0019Ib! \u0011\t\u0005M8qP\u0005\u0005\u0007\u0003\u000b)P\u0001\nTcV,'/\u001f7TQJLg.Z#se>\u0014\bbBA\r[\u0001\u0007\u00111D\u0001\u0011EJ,\u0017m\u001b3po:\u0014Vm];miN$Ba!#\u0004\u0014B11\u0011CB\r\u0007\u0017\u0003r!\u0010B\u001d\u0007S\u001ai\t\u0005\u0003\u0002t\u000e=\u0015\u0002BBI\u0003k\u0014\u0011dU9vKJLHN\u0011:fC.$wn\u001e8SKN,H\u000e\u001e*po\"9\u0011\u0011\u0004\u0018A\u0002\u0005m\u0001")
public final class SquerylAdapterDao
implements AdapterDao,
Loggable {
    private Seq<String> askTheCrcStates;
    private volatile SquerylAdapterDao$Queries$ Queries$module;
    public final Tables net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables;
    private final Set<ResultOutputType> breakdownTypes;
    private Logger net$shrine$log$Loggable$$internalLogger;
    private volatile byte bitmap$0;
    private volatile boolean bitmap$init$0;

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    public SquerylAdapterDao$Queries$ Queries() {
        if (this.Queries$module == null) {
            this.Queries$lzycompute$1();
        }
        return this.Queries$module;
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        SquerylAdapterDao squerylAdapterDao = this;
        synchronized (squerylAdapterDao) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.net$shrine$log$Loggable$$internalLogger$lzycompute() : this.net$shrine$log$Loggable$$internalLogger;
    }

    @Override
    public <T> T inTransaction(Function0<T> f) {
        return (T)SquerylEntryPoint$.MODULE$.inTransaction(f);
    }

    @Override
    public void flagQuery(long networkQueryId, Option<String> flagMessage) {
        this.mutateFlagField(networkQueryId, true, flagMessage);
    }

    @Override
    public void unFlagQuery(long networkQueryId) {
        this.mutateFlagField(networkQueryId, false, (Option<String>)None$.MODULE$);
    }

    private void mutateFlagField(long networkQueryId, boolean newIsFlagged, Option<String> newFlagMessage) {
        this.inTransaction((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> SquerylEntryPoint$.MODULE$.update($this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.shrineQueries(), (Function1 & Serializable & scala.Serializable)queryRow -> SquerylEntryPoint$.MODULE$.where((Function0 & Serializable & scala.Serializable)() -> SquerylEntryPoint$.MODULE$.longToTE(queryRow.networkId()).$eq$eq$eq(SquerylEntryPoint$.MODULE$.longToTE(networkQueryId), SquerylEntryPoint$.MODULE$.numericComparisonEvidence())).set((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAssignment[]{SquerylEntryPoint$.MODULE$.booleanToTE(queryRow.isFlagged()).$colon$eq((Object)BoxesRunTime.boxToBoolean((boolean)newIsFlagged), (Function1 & Serializable & scala.Serializable)s -> SquerylEntryPoint$.MODULE$.booleanToTE(BoxesRunTime.unboxToBoolean((Object)s))), SquerylEntryPoint$.MODULE$.optionStringToTE(queryRow.flagMessage()).$colon$eq((Object)newFlagMessage, (Function1 & Serializable & scala.Serializable)s -> SquerylEntryPoint$.MODULE$.optionStringToTE(s))}), Predef.$eq$colon$eq$.MODULE$.tpEquals())));
    }

    @Override
    public void storeResults(AuthenticationInfo authn, String masterId, long networkQueryId, QueryDefinition queryDefinition, Seq<QueryResult> rawQueryResults, Seq<QueryResult> obfuscatedQueryResults, Seq<ResultOutputType> failedBreakdownTypes, Map<ResultOutputType, I2b2ResultEnvelope> mergedBreakdowns, Map<ResultOutputType, I2b2ResultEnvelope> obfuscatedBreakdowns) {
        this.inTransaction((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int insertedQueryId = this.insertQuery(masterId, networkQueryId, authn, queryDefinition, false, true, (Option<String>)None$.MODULE$);
            Map<ResultOutputType, Seq<Object>> insertedQueryResultIds = this.insertQueryResults(insertedQueryId, rawQueryResults);
            this.storeCountResults(rawQueryResults, obfuscatedQueryResults, insertedQueryResultIds);
            this.storeErrorResults(rawQueryResults, insertedQueryResultIds);
            this.storeBreakdownFailures((Set<ResultOutputType>)failedBreakdownTypes.toSet(), insertedQueryResultIds);
            this.insertBreakdownResults(insertedQueryResultIds, mergedBreakdowns, obfuscatedBreakdowns);
        });
    }

    public void storeCountResults(Seq<QueryResult> raw, Seq<QueryResult> obfuscated, Map<ResultOutputType, Seq<Object>> insertedIds) {
        Seq notErrors = (Seq)raw.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.$anonfun$storeCountResults$1(x$1)));
        Seq obfuscatedNotErrors = (Seq)obfuscated.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.$anonfun$storeCountResults$2(x$2)));
        if (notErrors.size() > 1) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Got ").append(notErrors.size()).append(" raw (hopefully-)count results; more than 1 is unusual.").toString());
        }
        if (obfuscatedNotErrors.size() > 1) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Got ").append(obfuscatedNotErrors.size()).append(" obfuscated (hopefully-)count results; more than 1 is unusual.").toString());
        }
        if (notErrors.size() != obfuscatedNotErrors.size()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Got ").append(notErrors.size()).append(" raw and ").append(obfuscatedNotErrors.size()).append(" obfuscated (hopefully-)count results; that these numbers are different is unusual.").toString());
        }
        this.inTransaction((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> insertedIds.get((Object)ResultOutputType$.MODULE$.PATIENT_COUNT_XML()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.$anonfun$storeCountResults$7(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            SquerylAdapterDao.$anonfun$storeCountResults$8(this, notErrors, obfuscatedNotErrors, x$3);
            return BoxedUnit.UNIT;
        }));
    }

    public void storeErrorResults(Seq<QueryResult> results, Map<ResultOutputType, Seq<Object>> insertedIds) {
        Seq errors = (Seq)results.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isError()));
        Seq insertedErrorResultIds = (Seq)insertedIds.getOrElse((Object)ResultOutputType$.MODULE$.ERROR(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq insertedIdsToErrors = (Seq)insertedErrorResultIds.zip((GenIterable)errors, Seq$.MODULE$.canBuildFrom());
        this.inTransaction((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> insertedIdsToErrors.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.$anonfun$storeErrorResults$4(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            SquerylAdapterDao.$anonfun$storeErrorResults$5(this, x$5);
            return BoxedUnit.UNIT;
        }));
    }

    public void storeBreakdownFailures(Set<ResultOutputType> failedBreakdownTypes, Map<ResultOutputType, Seq<Object>> insertedIds) {
        Map insertedIdsForFailedBreakdownTypes = insertedIds.filterKeys((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)failedBreakdownTypes.contains((Object)elem)));
        this.inTransaction((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> insertedIdsForFailedBreakdownTypes.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.$anonfun$storeBreakdownFailures$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            SquerylAdapterDao.$anonfun$storeBreakdownFailures$4(this, x$6);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public Seq<ShrineQuery> findRecentQueries(int howMany) {
        return (Seq)this.inTransaction((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)SquerylEntryPoint$.MODULE$.queryToIterable(this.Queries().queriesForAllUsers()).take(howMany)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toShrineQuery(), Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    public Seq<SquerylCountRow> findAllCounts() {
        return (Seq)this.inTransaction((Function0 & Serializable & scala.Serializable)() -> SquerylEntryPoint$.MODULE$.queryToIterable(this.Queries().allCountResults()).toSeq());
    }

    @Override
    public void renameQuery(long networkQueryId, String newName) {
        this.inTransaction((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> SquerylEntryPoint$.MODULE$.update($this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.shrineQueries(), (Function1 & Serializable & scala.Serializable)queryRow -> SquerylEntryPoint$.MODULE$.where((Function0 & Serializable & scala.Serializable)() -> SquerylEntryPoint$.MODULE$.longToTE(queryRow.networkId()).$eq$eq$eq(SquerylEntryPoint$.MODULE$.longToTE(networkQueryId), SquerylEntryPoint$.MODULE$.numericComparisonEvidence())).set((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAssignment[]{SquerylEntryPoint$.MODULE$.stringToTE(queryRow.name()).$colon$eq((Object)newName, (Function1 & Serializable & scala.Serializable)s -> SquerylEntryPoint$.MODULE$.stringToTE(s))}), Predef.$eq$colon$eq$.MODULE$.tpEquals())));
    }

    @Override
    public void deleteQuery(long networkQueryId) {
        this.inTransaction((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.shrineQueries().deleteWhere((Function1 & Serializable & scala.Serializable)x$8 -> SquerylEntryPoint$.MODULE$.longToTE(x$8.networkId()).$eq$eq$eq(SquerylEntryPoint$.MODULE$.longToTE(networkQueryId), SquerylEntryPoint$.MODULE$.numericComparisonEvidence()), SquerylEntryPoint$.MODULE$.__thisDsl()));
    }

    @Override
    public void deleteQueryResultsFor(long networkQueryId) {
        this.inTransaction((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Set resultIdsForNetworkQueryId = SquerylEntryPoint$.MODULE$.queryToIterable(SquerylEntryPoint$.MODULE$.join($this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.shrineQueries(), (JoinedQueryable)SquerylEntryPoint$.MODULE$.queryable2RightInnerJoinedQueryable($this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.queryResults()), (Function2 & Serializable & scala.Serializable)(queryRow, resultRow) -> SquerylEntryPoint$.MODULE$.where((Function0 & Serializable & scala.Serializable)() -> SquerylEntryPoint$.MODULE$.longToTE(queryRow.networkId()).$eq$eq$eq(SquerylEntryPoint$.MODULE$.longToTE(networkQueryId), SquerylEntryPoint$.MODULE$.numericComparisonEvidence())).select((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> resultRow.id()).on((Function0 & Serializable & scala.Serializable)() -> SquerylEntryPoint$.MODULE$.intToTE(queryRow.id()).$eq$eq$eq(SquerylEntryPoint$.MODULE$.intToTE(resultRow.queryId()), SquerylEntryPoint$.MODULE$.numericComparisonEvidence())))).toSet();
            return $this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.queryResults().deleteWhere((Function1 & Serializable & scala.Serializable)x$9 -> SquerylEntryPoint$.MODULE$.intToTE(x$9.id()).in((Iterable)resultIdsForNetworkQueryId, SquerylEntryPoint$.MODULE$.numericComparisonEvidence()), SquerylEntryPoint$.MODULE$.__thisDsl());
        });
    }

    private Seq<String> askTheCrcStates$lzycompute() {
        SquerylAdapterDao squerylAdapterDao = this;
        synchronized (squerylAdapterDao) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.askTheCrcStates = (Seq)((TraversableLike)QueryResult.StatusType$.MODULE$.values().filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.crcPromisedToFinishAfterReply()))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.name(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.askTheCrcStates;
    }

    private Seq<String> askTheCrcStates() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.askTheCrcStates$lzycompute() : this.askTheCrcStates;
    }

    @Override
    public Seq<QueryResultStatus> findQueuedQueryIds() {
        return (Seq)this.inTransaction((Function0 & Serializable & scala.Serializable)() -> {
            Query dbQuery = SquerylEntryPoint$.MODULE$.join($this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.shrineQueries(), (JoinedQueryable)SquerylEntryPoint$.MODULE$.queryable2RightInnerJoinedQueryable($this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.queryResults()), (Function2 & Serializable & scala.Serializable)(queryRow, resultRow) -> SquerylEntryPoint$.MODULE$.where((Function0 & Serializable & scala.Serializable)() -> SquerylEntryPoint$.MODULE$.stringToTE(resultRow.status()).in(this.askTheCrcStates(), SquerylEntryPoint$.MODULE$.stringComparisonEvidence())).select((Function0 & Serializable & scala.Serializable)() -> new Tuple5((Object)BoxesRunTime.boxToLong((long)queryRow.networkId()), (Object)resultRow.lastUpdated(), (Object)queryRow.username(), (Object)queryRow.domain(), (Object)resultRow.status())).on((Function0 & Serializable & scala.Serializable)() -> SquerylEntryPoint$.MODULE$.intToTE(queryRow.id()).$eq$eq$eq(SquerylEntryPoint$.MODULE$.intToTE(resultRow.queryId()), SquerylEntryPoint$.MODULE$.numericComparisonEvidence())));
            return (Seq)SquerylEntryPoint$.MODULE$.queryToIterable(dbQuery).toList().map((Function1 & Serializable & scala.Serializable)row -> new QueryResultStatus(BoxesRunTime.unboxToLong((Object)row._1()), (Timestamp)row._2(), (String)row._3(), (String)row._4(), (String)row._5()), List$.MODULE$.canBuildFrom());
        });
    }

    @Override
    public void checkIfBot(AuthenticationInfo authn, Seq<Tuple2<Object, Duration>> botTimeThresholds) {
        long now = System.currentTimeMillis();
        botTimeThresholds.foreach((Function1 & Serializable & scala.Serializable)countDuration -> {
            this.inTransaction((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                long sinceMs = now$1 - ((Duration)countDuration._2()).toMillis();
                Query<Measures<Object>> query = $this.Queries().countQueriesForUserSince(authn$2.domain(), authn$2.username(), sinceMs);
                long queriesSince = BoxesRunTime.unboxToLong((Object)query.headOption().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)SquerylAdapterDao.$anonfun$checkIfBot$3(x$12))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                if (queriesSince >= countDuration._1$mcJ$sp()) {
                    throw new BotDetectedException(authn$2.domain(), authn$2.username(), queriesSince, sinceMs, countDuration._1$mcJ$sp());
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void checkIfBot(Researcher researcher, Seq<Tuple2<Object, Duration>> countTimeThresholds) {
        long now = System.currentTimeMillis();
        countTimeThresholds.foreach((Function1 & Serializable & scala.Serializable)countDuration -> {
            this.inTransaction((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                long sinceMs = now$2 - ((Duration)countDuration._2()).toMillis();
                Query<Measures<Object>> query = $this.Queries().countQueriesForUserSince(researcher$1.userDomainName(), researcher$1.userName(), sinceMs);
                long queriesSince = BoxesRunTime.unboxToLong((Object)query.headOption().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)SquerylAdapterDao.$anonfun$checkIfBot$7(x$13))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                if (queriesSince >= countDuration._1$mcJ$sp()) {
                    throw new BotDetectedException(researcher$1.userDomainName(), researcher$1.userName(), queriesSince, sinceMs, countDuration._1$mcJ$sp());
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public int insertQuery(String localMasterId, long networkId, AuthenticationInfo authn, QueryDefinition queryDefinition, boolean isFlagged, boolean hasBeenRun, Option<String> flagMessage) {
        return BoxesRunTime.unboxToInt(this.inTransaction((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            SquerylShrineQuery inserted = (SquerylShrineQuery)$this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.shrineQueries().insert((Object)new SquerylShrineQuery(0, localMasterId, networkId, authn.username(), authn.domain(), XmlDateHelper$.MODULE$.now(), isFlagged, flagMessage, hasBeenRun, queryDefinition));
            return inserted.id();
        }));
    }

    @Override
    public Map<ResultOutputType, Seq<Object>> insertQueryResults(int parentQueryId, Seq<QueryResult> results) {
        Seq typeToIdTuples = (Seq)this.inTransaction((Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)results.map((Function1 & Serializable & scala.Serializable)result -> {
            ResultOutputType resultType = (ResultOutputType)result.resultType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ResultOutputType$.MODULE$.ERROR());
            Option elapsed = SquerylAdapterDao.execTime$1(result);
            return new Tuple3(result, (Object)resultType, (Object)elapsed);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$14 -> {
            Tuple3 tuple3 = x$14;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            QueryResult result = (QueryResult)tuple3._1();
            ResultOutputType resultType = (ResultOutputType)tuple3._2();
            Option elapsed = (Option)tuple3._3();
            SquerylQueryResultRow lastInsertedQueryResultRow = (SquerylQueryResultRow)$this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.queryResults().insert((Object)new SquerylQueryResultRow(0, result.resultId(), parentQueryId, resultType, result.statusType(), (Option<Object>)elapsed, XmlDateHelper$.MODULE$.now()));
            Tuple2 tuple2 = new Tuple2((Object)resultType, (Object)BoxesRunTime.boxToInteger((int)lastInsertedQueryResultRow.id()));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom()));
        return typeToIdTuples.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResultOutputType resultType;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResultOutputType resultOutputType = resultType = (ResultOutputType)tuple2._1();
            return resultOutputType;
        }).mapValues((Function1 & Serializable & scala.Serializable)x$15 -> (Seq)x$15.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)SquerylAdapterDao.$anonfun$insertQueryResults$9(x0$2)), Seq$.MODULE$.canBuildFrom()));
    }

    @Override
    public void insertCountResult(int resultId, long originalCount, long obfuscatedCount) {
        this.inTransaction((Function0 & Serializable & scala.Serializable)() -> (SquerylCountRow)$this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.countResults().insert((Object)new SquerylCountRow(0, resultId, originalCount, obfuscatedCount, XmlDateHelper$.MODULE$.now())));
    }

    @Override
    public void insertBreakdownResults(Map<ResultOutputType, Seq<Object>> parentResultIds, Map<ResultOutputType, I2b2ResultEnvelope> originalBreakdowns, Map<ResultOutputType, I2b2ResultEnvelope> obfuscatedBreakdowns) {
        this.inTransaction((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parentResultIds.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.$anonfun$insertBreakdownResults$5(check$ifrefutable$5))).withFilter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.$anonfun$insertBreakdownResults$6(x$17))).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            SquerylAdapterDao.$anonfun$insertBreakdownResults$7(this, originalBreakdowns, obfuscatedBreakdowns, x$19);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public void insertErrorResult(int parentResultId, String errorMessage, String codec, String stampText, String summary, String digestDescription, NodeSeq detailsXml) {
        this.inTransaction((Function0 & Serializable & scala.Serializable)() -> (SquerylShrineError)$this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.errorResults().insert((Object)new SquerylShrineError(0, parentResultId, errorMessage, codec, stampText, summary, digestDescription, detailsXml.toString())));
    }

    @Override
    public Option<ShrineQuery> findQueryByNetworkId(long networkQueryId) {
        return (Option)this.inTransaction((Function0 & Serializable & scala.Serializable)() -> this.Queries().queriesByNetworkId(networkQueryId).headOption().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.toShrineQuery()));
    }

    @Override
    public Seq<ShrineQuery> findQueriesByUserAndDomain(String domain, String username, int howMany) {
        return (Seq)this.inTransaction((Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableOnce)SquerylEntryPoint$.MODULE$.queryToIterable(this.Queries().queriesForUser(username, domain)).take(howMany)).toSeq().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.toShrineQuery(), Seq$.MODULE$.canBuildFrom()));
    }

    @Override
    public Seq<ShrineQuery> findQueriesByDomain(String domain) {
        return (Seq)this.inTransaction((Function0 & Serializable & scala.Serializable)() -> (Seq)SquerylEntryPoint$.MODULE$.queryToIterable(this.Queries().queriesForDomain(domain)).toList().map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.toShrineQuery(), List$.MODULE$.canBuildFrom()));
    }

    @Override
    public Option<ShrineQueryResult> findResultsFor(long networkQueryId) {
        return (Option)this.inTransaction((Function0 & Serializable & scala.Serializable)() -> {
            Map breakdownRowsByType = SquerylEntryPoint$.MODULE$.queryToIterable(this.Queries().breakdownResults(networkQueryId)).toSeq().groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SquerylQueryResultRow outputType = (SquerylQueryResultRow)tuple2._1();
                ResultOutputType resultOutputType = outputType.toQueryResultRow($this.breakdownTypes).resultType();
                return resultOutputType;
            }).mapValues((Function1 & Serializable & scala.Serializable)x$23 -> (Seq)x$23.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SquerylBreakdownResultRow row = (SquerylBreakdownResultRow)tuple2._2();
                BreakdownResultRow breakdownResultRow = row.toBreakdownResultRow();
                return breakdownResultRow;
            }, Seq$.MODULE$.canBuildFrom()));
            Option queryRowOption = this.Queries().queriesByNetworkId(networkQueryId).headOption().map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.toShrineQuery());
            Option countRowOption = this.Queries().countResults(networkQueryId).headOption().map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.toCountRow());
            Seq queryResultRows = (Seq)SquerylEntryPoint$.MODULE$.queryToIterable(this.Queries().resultsForQuery(networkQueryId)).toSeq().map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.toQueryResultRow($this.breakdownTypes), Seq$.MODULE$.canBuildFrom());
            Seq errorResultRows = (Seq)SquerylEntryPoint$.MODULE$.queryToIterable(this.Queries().errorResults(networkQueryId)).toSeq().map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.toShrineError(), Seq$.MODULE$.canBuildFrom());
            return queryRowOption.flatMap((Function1 & Serializable & scala.Serializable)queryRow -> ShrineQueryResult$.MODULE$.fromRows((ShrineQuery)queryRow, (Seq<QueryResultRow>)queryResultRows, (Option<CountRow>)countRowOption, (Map<ResultOutputType, Seq<BreakdownResultRow>>)breakdownRowsByType, (Seq<ShrineError>)errorResultRows).map((Function1 & Serializable & scala.Serializable)shrineQueryResult -> shrineQueryResult));
        });
    }

    private final void Queries$lzycompute$1() {
        SquerylAdapterDao squerylAdapterDao = this;
        synchronized (squerylAdapterDao) {
            if (this.Queries$module == null) {
                this.Queries$module = new SquerylAdapterDao$Queries$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$storeCountResults$1(QueryResult x$1) {
        return !x$1.isError();
    }

    public static final /* synthetic */ boolean $anonfun$storeCountResults$2(QueryResult x$2) {
        return !x$2.isError();
    }

    private static final boolean isCount$1(QueryResult qr) {
        return qr.resultType().contains((Object)ResultOutputType$.MODULE$.PATIENT_COUNT_XML());
    }

    public static final /* synthetic */ boolean $anonfun$storeCountResults$7(Seq check$ifrefutable$1) {
        Seq seq = check$ifrefutable$1;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        boolean bl = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$storeCountResults$10(SquerylAdapterDao $this, Seq obfuscatedNotErrors$1, int insertedCountQueryResultId$1, QueryResult notError) {
        obfuscatedNotErrors$1.find((Function1 & Serializable & scala.Serializable)qr -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.isCount$1(qr))).foreach((Function1 & Serializable & scala.Serializable)obfuscatedNotError -> {
            $this.insertCountResult(insertedCountQueryResultId$1, notError.setSize(), obfuscatedNotError.setSize());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$storeCountResults$8(SquerylAdapterDao $this, Seq notErrors$1, Seq obfuscatedNotErrors$1, Seq x$3) {
        Seq seq = x$3;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)seq);
        }
        int insertedCountQueryResultId = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(0));
        notErrors$1.find((Function1 & Serializable & scala.Serializable)qr -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.isCount$1(qr))).foreach((Function1 & Serializable & scala.Serializable)notError -> {
            SquerylAdapterDao.$anonfun$storeCountResults$10($this, obfuscatedNotErrors$1, insertedCountQueryResultId, notError);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$storeErrorResults$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$storeErrorResults$5(SquerylAdapterDao $this, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int insertedErrorResultId = tuple2._1$mcI$sp();
        QueryResult errorQueryResult = (QueryResult)tuple2._2();
        Problem pd = (Problem)errorQueryResult.problem().get();
        $this.insertErrorResult(insertedErrorResultId, (String)errorQueryResult.statusMessage().getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown failure"), pd.codec(), pd.stampText(), pd.summary(), pd.description(), pd.detailsXml());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$storeBreakdownFailures$3(Tuple2 check$ifrefutable$3) {
        Seq seq;
        Some some;
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)tuple2._2())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0;
        return bl;
    }

    private static final /* synthetic */ SquerylAdapterDao$BreakdownFailure$1$ BreakdownFailure$lzycompute$1(LazyRef BreakdownFailure$module$1, ResultOutputType failedBreakdownType$1) {
        SquerylAdapterDao$BreakdownFailure$1$ squerylAdapterDao$BreakdownFailure$1$;
        LazyRef lazyRef = BreakdownFailure$module$1;
        synchronized (lazyRef) {
            squerylAdapterDao$BreakdownFailure$1$ = BreakdownFailure$module$1.initialized() ? (SquerylAdapterDao$BreakdownFailure$1$)((Object)BreakdownFailure$module$1.value()) : (SquerylAdapterDao$BreakdownFailure$1$)((Object)BreakdownFailure$module$1.initialize((Object)new SquerylAdapterDao$BreakdownFailure$1$(null, failedBreakdownType$1)));
        }
        return squerylAdapterDao$BreakdownFailure$1$;
    }

    private final SquerylAdapterDao$BreakdownFailure$1$ BreakdownFailure$2(LazyRef BreakdownFailure$module$1, ResultOutputType failedBreakdownType$1) {
        return BreakdownFailure$module$1.initialized() ? (SquerylAdapterDao$BreakdownFailure$1$)((Object)BreakdownFailure$module$1.value()) : SquerylAdapterDao.BreakdownFailure$lzycompute$1(BreakdownFailure$module$1, failedBreakdownType$1);
    }

    public static final /* synthetic */ void $anonfun$storeBreakdownFailures$4(SquerylAdapterDao $this, Tuple2 x$6) {
        Some some;
        ResultOutputType failedBreakdownType;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$6;
                if (tuple2 == null) break block2;
                failedBreakdownType = (ResultOutputType)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        int resultId = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(0));
        LazyRef BreakdownFailure$module = new LazyRef();
        XmlProblemDigest pd = XmlProblemDigest$.MODULE$.create((RawProblem)$this.BreakdownFailure$2(BreakdownFailure$module, failedBreakdownType));
        $this.insertErrorResult(resultId, new StringBuilder(38).append("Couldn't retrieve breakdown of type '").append(failedBreakdownType).append("'").toString(), pd.codec(), pd.stampText(), pd.summary(), pd.description(), pd.detailsXml());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ long $anonfun$checkIfBot$3(Measures x$12) {
        return BoxesRunTime.unboxToLong((Object)x$12.measures());
    }

    public static final /* synthetic */ long $anonfun$checkIfBot$7(Measures x$13) {
        return BoxesRunTime.unboxToLong((Object)x$13.measures());
    }

    private static final long toMillis$1(XMLGregorianCalendar xmlGc) {
        return xmlGc.toGregorianCalendar().getTimeInMillis();
    }

    public static final /* synthetic */ long $anonfun$insertQueryResults$2(XMLGregorianCalendar start$1, XMLGregorianCalendar end) {
        return SquerylAdapterDao.toMillis$1(end) - SquerylAdapterDao.toMillis$1(start$1);
    }

    private static final Option execTime$1(QueryResult result) {
        return result.startDate().flatMap((Function1 & Serializable & scala.Serializable)start -> result.endDate().map((Function1 & Serializable & scala.Serializable)end -> BoxesRunTime.boxToLong((long)SquerylAdapterDao.$anonfun$insertQueryResults$2(start, end))));
    }

    public static final /* synthetic */ int $anonfun$insertQueryResults$9(Tuple2 x0$2) {
        int count;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = count = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$insertBreakdownResults$1(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$insertBreakdownResults$3(String key$1, long originalValue$1, long obfuscatedValue) {
        return new Tuple2((Object)key$1, (Object)new ObfuscatedPair(originalValue$1, obfuscatedValue));
    }

    private static final Map merge$1(I2b2ResultEnvelope original, I2b2ResultEnvelope obfuscated) {
        return Predef$.MODULE$.Map().empty().$plus$plus((GenTraversableOnce)original.data().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.$anonfun$insertBreakdownResults$1(check$ifrefutable$4))).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
            Tuple2 tuple2 = x$16;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            long originalValue = tuple2._2$mcJ$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(obfuscated.data().get((Object)key).map((Function1 & Serializable & scala.Serializable)obfuscatedValue -> SquerylAdapterDao.$anonfun$insertBreakdownResults$3(key, originalValue, BoxesRunTime.unboxToLong((Object)obfuscatedValue))));
            return iterable;
        }, Map$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$insertBreakdownResults$5(Tuple2 check$ifrefutable$5) {
        Seq seq;
        Some some;
        Tuple2 tuple2 = check$ifrefutable$5;
        boolean bl = tuple2 != null && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)tuple2._2())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$insertBreakdownResults$6(Tuple2 x$17) {
        ResultOutputType resultType;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$17;
                if (tuple2 == null) break block2;
                resultType = (ResultOutputType)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        boolean bl = resultType.isBreakdown();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$insertBreakdownResults$10(Tuple2 check$ifrefutable$6) {
        ObfuscatedPair obfuscatedPair;
        Tuple2 tuple2 = check$ifrefutable$6;
        boolean bl = tuple2 != null && (obfuscatedPair = (ObfuscatedPair)tuple2._2()) != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$insertBreakdownResults$9(SquerylAdapterDao $this, I2b2ResultEnvelope originalBreakdown$1, int resultId$2, I2b2ResultEnvelope obfuscatedBreakdown) {
        SquerylAdapterDao.merge$1(originalBreakdown$1, obfuscatedBreakdown).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)SquerylAdapterDao.$anonfun$insertBreakdownResults$10(check$ifrefutable$6))).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            ObfuscatedPair obfuscatedPair;
            String key;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$18;
                    if (tuple2 == null) break block2;
                    key = (String)tuple2._1();
                    obfuscatedPair = (ObfuscatedPair)tuple2._2();
                    if (obfuscatedPair != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            long obfuscated = obfuscatedPair.obfuscated();
            SquerylBreakdownResultRow squerylBreakdownResultRow = (SquerylBreakdownResultRow)$this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables.breakdownResults().insert((Object)new SquerylBreakdownResultRow(0, resultId$2, key, obfuscated));
            return squerylBreakdownResultRow;
        });
    }

    public static final /* synthetic */ void $anonfun$insertBreakdownResults$8(SquerylAdapterDao $this, Map obfuscatedBreakdowns$2, ResultOutputType resultType$1, int resultId$2, I2b2ResultEnvelope originalBreakdown) {
        obfuscatedBreakdowns$2.get((Object)resultType$1).foreach((Function1 & Serializable & scala.Serializable)obfuscatedBreakdown -> {
            SquerylAdapterDao.$anonfun$insertBreakdownResults$9($this, originalBreakdown, resultId$2, obfuscatedBreakdown);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$insertBreakdownResults$7(SquerylAdapterDao $this, Map originalBreakdowns$1, Map obfuscatedBreakdowns$2, Tuple2 x$19) {
        Some some;
        ResultOutputType resultType;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$19;
                if (tuple2 == null) break block2;
                resultType = (ResultOutputType)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        int resultId = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(0));
        originalBreakdowns$1.get((Object)resultType).foreach((Function1 & Serializable & scala.Serializable)originalBreakdown -> {
            SquerylAdapterDao.$anonfun$insertBreakdownResults$8($this, obfuscatedBreakdowns$2, resultType, resultId, originalBreakdown);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SquerylAdapterDao(SquerylInitializer initializer, Tables tables, Set<ResultOutputType> breakdownTypes) {
        this.net$shrine$adapter$dao$squeryl$SquerylAdapterDao$$tables = tables;
        this.breakdownTypes = breakdownTypes;
        AdapterDao.$init$(this);
        Loggable.$init$((Loggable)this);
        initializer.init();
    }
}

