/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.mappings;

import cats.effect.IO;
import cats.effect.IO$;
import ch.qos.logback.classic.Logger;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import net.shrine.adapter.mappings.AdapterMappings;
import net.shrine.adapter.mappings.AdapterMappingsDb$;
import net.shrine.adapter.mappings.LazyCsvIterator;
import net.shrine.log.Loggable;
import net.shrine.problem.RawProblem;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyLong;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class AdapterMappings$
implements Loggable,
Serializable {
    public static final AdapterMappings$ MODULE$ = new AdapterMappings$();
    private static Logger net$shrine$log$Loggable$$internalLogger;
    private static volatile boolean bitmap$0;

    static {
        Loggable.$init$((Loggable)MODULE$);
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        AdapterMappings$ adapterMappings$ = this;
        synchronized (adapterMappings$) {
            if (!bitmap$0) {
                net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                bitmap$0 = true;
            }
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        if (!bitmap$0) {
            return this.net$shrine$log$Loggable$$internalLogger$lzycompute();
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public final String Unknown() {
        return "Unknown";
    }

    public final long Unmodified() {
        return -1L;
    }

    public AdapterMappings apply(String source) {
        Option<URL> url2 = this.sourceToUrl(source);
        return new AdapterMappings(source, BoxesRunTime.unboxToLong((Object)url2.fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L, (Function1 & Serializable)url -> BoxesRunTime.boxToLong((long)AdapterMappings$.MODULE$.lastModified(url)))), (String)url2.fold((Function0 & Serializable)() -> "Unknown", (Function1 & Serializable)url -> MODULE$.mappingsVersion((URL)url)));
    }

    public IO<BoxedUnit> compareAndReloadMappings(String source) {
        Option<URL> url2 = this.sourceToUrl(source);
        return (IO)url2.fold((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(48).append("Cannot find adapter mapping file ").append(source).append(" on class path.").toString());
        }, (Function1 & Serializable)url -> {
            LazyRef fsFilename$lzy = new LazyRef();
            LazyLong fsModified$lzy = new LazyLong();
            LazyLong fsChecksum$lzy = new LazyLong();
            return AdapterMappings$.reloadOnPropChange$1(AdapterMappingsDb$.MODULE$.db().filename(), AdapterMappings$.fsFilename$1(fsFilename$lzy, url), "filename", AdapterMappings$.reloadOnPropChange$1(AdapterMappingsDb$.MODULE$.db().fileLastModified(), BoxesRunTime.boxToLong((long)AdapterMappings$.fsModified$1(fsModified$lzy, url)), "modification date", AdapterMappings$.reloadOnPropChange$1(AdapterMappingsDb$.MODULE$.db().checksum(), BoxesRunTime.boxToLong((long)AdapterMappings$.fsChecksum$1(fsChecksum$lzy, url)), "checksum", IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Adapter mappings file ").append(source).append(" is unchanged. Mappings were not reloaded.").toString())), source, url, fsFilename$lzy, fsModified$lzy, fsChecksum$lzy), source, url, fsFilename$lzy, fsModified$lzy, fsChecksum$lzy), source, url, fsFilename$lzy, fsModified$lzy, fsChecksum$lzy);
        });
    }

    private long checksum(URL url) {
        FileInputStream inputStream = new FileInputStream(url.getFile());
        FileChannel fileChannel = inputStream.getChannel();
        long len = fileChannel.size();
        MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, len);
        CRC32 crc = new CRC32();
        int current = 0;
        while ((long)current < len) {
            byte i = buffer.get(current);
            crc.update(i);
            int cfr_ignored_0 = ++current - 1;
        }
        return crc.getValue();
    }

    private Option<URL> sourceToUrl(String source) {
        return Option$.MODULE$.apply((Object)this.getClass().getClassLoader().getResource(source));
    }

    private long lastModified(URL url) {
        URLConnection conn = url.openConnection();
        long modified = conn.getLastModified();
        conn.getInputStream().close();
        return modified;
    }

    private String mappingsVersion(URL url) {
        return "Unknown";
    }

    public AdapterMappings apply(String source, long lastModified, String version) {
        return new AdapterMappings(source, lastModified, version);
    }

    public Option<Tuple3<String, Object, String>> unapply(AdapterMappings x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.source(), (Object)BoxesRunTime.boxToLong((long)x$0.lastModified()), (Object)x$0.version()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AdapterMappings$.class);
    }

    private static final /* synthetic */ String fsFilename$lzycompute$1(LazyRef fsFilename$lzy$1, URL url$1) {
        String string;
        LazyRef lazyRef = fsFilename$lzy$1;
        synchronized (lazyRef) {
            string = fsFilename$lzy$1.initialized() ? (String)fsFilename$lzy$1.value() : (String)fsFilename$lzy$1.initialize((Object)url$1.getFile());
        }
        return string;
    }

    private static final String fsFilename$1(LazyRef fsFilename$lzy$1, URL url$1) {
        if (fsFilename$lzy$1.initialized()) {
            return (String)fsFilename$lzy$1.value();
        }
        return AdapterMappings$.fsFilename$lzycompute$1(fsFilename$lzy$1, url$1);
    }

    private static final /* synthetic */ long fsModified$lzycompute$1(LazyLong fsModified$lzy$1, URL url$1) {
        long l;
        LazyLong lazyLong = fsModified$lzy$1;
        synchronized (lazyLong) {
            l = fsModified$lzy$1.initialized() ? fsModified$lzy$1.value() : fsModified$lzy$1.initialize(MODULE$.lastModified(url$1));
        }
        return l;
    }

    private static final long fsModified$1(LazyLong fsModified$lzy$1, URL url$1) {
        if (fsModified$lzy$1.initialized()) {
            return fsModified$lzy$1.value();
        }
        return AdapterMappings$.fsModified$lzycompute$1(fsModified$lzy$1, url$1);
    }

    private static final /* synthetic */ long fsChecksum$lzycompute$1(LazyLong fsChecksum$lzy$1, URL url$1) {
        long l;
        LazyLong lazyLong = fsChecksum$lzy$1;
        synchronized (lazyLong) {
            l = fsChecksum$lzy$1.initialized() ? fsChecksum$lzy$1.value() : fsChecksum$lzy$1.initialize(MODULE$.checksum(url$1));
        }
        return l;
    }

    private static final long fsChecksum$1(LazyLong fsChecksum$lzy$1, URL url$1) {
        if (fsChecksum$lzy$1.initialized()) {
            return fsChecksum$lzy$1.value();
        }
        return AdapterMappings$.fsChecksum$lzycompute$1(fsChecksum$lzy$1, url$1);
    }

    public static final /* synthetic */ IO $anonfun$compareAndReloadMappings$5(URL url$1, long upserted) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append(upserted).append(" rows from ").append(url$1.getFile()).append(" were loaded into the database.").toString())).map((Function1 & Serializable)x$1 -> {
            boxedUnit = x$1;
            return BoxedUnit.UNIT;
        });
    }

    private static final IO reloadOnPropChange$1(IO propFromDB, Object fsProp, String propName, IO ifNotChanged, String source$1, URL url$1, LazyRef fsFilename$lzy$1, LazyLong fsModified$lzy$1, LazyLong fsChecksum$lzy$1) {
        return propFromDB.flatMap((Function1 & Serializable)dbProp -> {
            if (!BoxesRunTime.equals((Object)dbProp, (Object)fsProp)) {
                MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Adapter mappings file ").append(source$1).append(" ").append(propName).append(" changed from ").append(dbProp).append(" to ").append(fsProp).append(". Reloading mappings").toString());
                return AdapterMappingsDb$.MODULE$.reloadMappings((Iterator<Tuple2<String, String>>)new LazyCsvIterator(new InputStreamReader(url$1.openStream())), AdapterMappings$.fsFilename$1(fsFilename$lzy$1, url$1), AdapterMappings$.fsModified$1(fsModified$lzy$1, url$1), AdapterMappings$.fsChecksum$1(fsChecksum$lzy$1, url$1)).flatMap((Function1 & Serializable)upserted -> AdapterMappings$.$anonfun$compareAndReloadMappings$5(url$1, BoxesRunTime.unboxToLong((Object)upserted)));
            }
            MODULE$.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Adapter mappings file ").append(source$1).append(" ").append(propName).append(" (").append(fsProp).append(") unchanged.").toString());
            return ifNotChanged;
        });
    }

    private AdapterMappings$() {
    }
}

