/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.i2b2Protocol.query;

import java.io.Serializable;
import net.shrine.adapter.i2b2Protocol.query.ValueConstraint;
import net.shrine.protocol.version.v2.querydefinition.ConceptConstraint;
import net.shrine.protocol.version.v2.querydefinition.DoubleNumberConstraint;
import net.shrine.protocol.version.v2.querydefinition.FlagConstraint;
import net.shrine.protocol.version.v2.querydefinition.FlagConstraints;
import net.shrine.protocol.version.v2.querydefinition.NumberConstraint;
import net.shrine.protocol.version.v2.querydefinition.SingleNumberConstraint;
import net.shrine.xml.NodeSeqEnrichments;
import net.shrine.xml.XmlUtil$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.xml.NodeSeq;

public final class ValueConstraint$
implements Serializable {
    public static final ValueConstraint$ MODULE$ = new ValueConstraint$();

    public ValueConstraint fromShrineV2(ConceptConstraint v2Constraint) {
        ConceptConstraint conceptConstraint = v2Constraint;
        if (conceptConstraint instanceof FlagConstraint) {
            FlagConstraint flagConstraint = (FlagConstraint)conceptConstraint;
            FlagConstraint flagConstraint2 = flagConstraint;
            if (FlagConstraints.Low$.MODULE$.equals(flagConstraint2)) {
                return new ValueConstraint("FLAG", (Option<String>)None$.MODULE$, "EQ", "L");
            }
            if (FlagConstraints.Normal$.MODULE$.equals(flagConstraint2)) {
                return new ValueConstraint("FLAG", (Option<String>)None$.MODULE$, "EQ", "@");
            }
            if (FlagConstraints.High$.MODULE$.equals(flagConstraint2)) {
                return new ValueConstraint("FLAG", (Option<String>)None$.MODULE$, "EQ", "H");
            }
            throw new MatchError((Object)flagConstraint2);
        }
        if (conceptConstraint instanceof SingleNumberConstraint) {
            String string;
            SingleNumberConstraint singleNumberConstraint = (SingleNumberConstraint)conceptConstraint;
            NumberConstraint.SingleNumberOperator singleNumberOperator = singleNumberConstraint.operator();
            if (NumberConstraint.GreaterThan$.MODULE$.equals(singleNumberOperator)) {
                string = "GT";
            } else if (NumberConstraint.GreaterThanOrEqual$.MODULE$.equals(singleNumberOperator)) {
                string = "GE";
            } else if (NumberConstraint.Equal$.MODULE$.equals(singleNumberOperator)) {
                string = "EQ";
            } else if (NumberConstraint.LessThanOrEqual$.MODULE$.equals(singleNumberOperator)) {
                string = "LE";
            } else if (NumberConstraint.LessThan$.MODULE$.equals(singleNumberOperator)) {
                string = "LT";
            } else {
                throw new MatchError((Object)singleNumberOperator);
            }
            String operator = string;
            return new ValueConstraint("NUMBER", (Option<String>)singleNumberConstraint.unit(), operator, Double.toString(singleNumberConstraint.value()));
        }
        if (conceptConstraint instanceof DoubleNumberConstraint) {
            DoubleNumberConstraint doubleNumberConstraint = (DoubleNumberConstraint)conceptConstraint;
            return new ValueConstraint("NUMBER", (Option<String>)doubleNumberConstraint.unit(), "BETWEEN", new StringBuilder(5).append(doubleNumberConstraint.value1()).append(" and ").append(doubleNumberConstraint.value2()).toString());
        }
        throw new MatchError((Object)conceptConstraint);
    }

    public Try<ValueConstraint> fromI2b2(NodeSeq xml) {
        return this.unmarshalXml(xml, "value_type", "value_unit_of_measure", "value_operator", "value_constraint");
    }

    public Try<ValueConstraint> fromXml(NodeSeq xml) {
        return this.unmarshalXml(xml, "valueType", "unitOfMeasure", "operator", "value");
    }

    private Try<ValueConstraint> unmarshalXml(NodeSeq xml, String valueTypeTagName, String unitTagName, String operatorTagName, String valueTagName) {
        return ValueConstraint$.tagValue$1(valueTypeTagName, xml).map((Function1 & Serializable)valueType -> {
            Option unit = ValueConstraint$.tagValue$1(unitTagName, xml).toOption();
            return new Tuple2(valueType, (Object)unit);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String valueType = (String)tuple2._1();
                Option unit = (Option)tuple2._2();
                return ValueConstraint$.tagValue$1(operatorTagName, xml).flatMap((Function1 & Serializable)operator -> ValueConstraint$.tagValue$1(valueTagName, xml).map((Function1 & Serializable)value -> new ValueConstraint(valueType, (Option<String>)unit, (String)operator, (String)value)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public ValueConstraint apply(String valueType, Option<String> unit, String operator, String value) {
        return new ValueConstraint(valueType, unit, operator, value);
    }

    public Option<Tuple4<String, Option<String>, String, String>> unapply(ValueConstraint x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.valueType(), x$0.unit(), (Object)x$0.operator(), (Object)x$0.value()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ValueConstraint$.class);
    }

    private static final Try tagValue$1(String tagName, NodeSeq xml$1) {
        return NodeSeqEnrichments.Strictness$.HasStrictNodeSeqEnrichments$.MODULE$.withChild$extension(NodeSeqEnrichments.Strictness$.MODULE$.HasStrictNodeSeqEnrichments(xml$1), tagName).map((Function1 & Serializable)xml -> XmlUtil$.MODULE$.trim(xml));
    }

    private ValueConstraint$() {
    }
}

