package net.shrine.adapter

import dao.AdapterDAO
import org.spin.node.actions.AbstractQueryAction
import org.spin.node.QueryContext
import java.lang.String
import org.springframework.transaction.annotation.Transactional
import org.spin.tools.crypto.signature.Identity
import net.shrine.config.I2B2HiveCredentials
import net.shrine.protocol.{ErrorResponse, ShrineResponse, BroadcastMessage}

/**
 * @author Bill Simons
 * @date 4/8/11
 * @link http://cbmi.med.harvard.edu
 * @link http://chip.org
 *       <p/>
 *       NOTICE: This software comes with NO guarantees whatsoever and is
 *       licensed as Lgpl Open Source
 * @link http://www.gnu.org/licenses/lgpl.html
 */
abstract class Adapter(
        protected val crcUrl: String,
        protected val dao: AdapterDAO,
        protected val hiveCredentials: I2B2HiveCredentials) extends AbstractQueryAction[BroadcastMessage] {
  final def unmarshal(serializedCriteria: String) = BroadcastMessage.fromXml(serializedCriteria)

  @Transactional
  final def perform(context: QueryContext, message: BroadcastMessage): String = {
    val shrineResponse = try {
      processRequest(context.getQueryInfo.getIdentity, message)
    } catch {
      case e: Exception => new ErrorResponse(e.getMessage)
    }

    shrineResponse.toI2b2.toString
  }

  protected def processRequest(identity: Identity, message: BroadcastMessage): ShrineResponse
}