package net.shrine.adapter.query;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryMasterType;
import net.shrine.adapter.dao.AdapterDAO;
import net.shrine.serializers.ShrineMessage;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import org.apache.log4j.Logger;
import org.spin.tools.crypto.signature.Identity;

import java.util.List;

import static org.spin.tools.Util.guardNotNull;

/**
 * @author clint
 *         <p/>
 *         Sep 8, 2010
 *         <p/>
 *         Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 */
public final class GetMasterIDsForUserQuery extends AdapterQuery
{
    private static final Logger log = Logger.getLogger(GetMasterIDsForUserQuery.class);

    private static final boolean DEBUG = log.isDebugEnabled();

    public GetMasterIDsForUserQuery(final AdapterDAO dao)
    {
        super("", dao);
    }

    /**
     * Don't invoke the CRC; get stored master definitions from the local adapter DB instead
     * <p/>
     * TODO: Should this expect a request with a UserRequestType payload?  I don't know, so it will
     * get user info from an Identity for now. -Clint
     */
    @Override
    protected ResponseMessageType callCRC(final Identity identity, final RequestMessageType request) throws Exception
    {
        guardNotNull(identity);
        guardNotNull(request);

        final ResponseMessageType response = CRCSerializer.getTemplateResponseMessageType(request);

        final MasterResponseType masterResponse = new MasterResponseType();

        masterResponse.setStatus(makeDoneStatus());

        final List<QueryMasterType> networkMasterDefinitions = dao.findNetworkMasterDefinitions(identity.getDomain(), identity.getUsername());

        if(DEBUG)
        {
            log.debug("Got " + networkMasterDefinitions.size() + " network master defs for user " + identity.getDomain() + ":" + identity.getUsername());
        }

        masterResponse.getQueryMaster().addAll(networkMasterDefinitions);

        CRCSerializer.addMasterResponse(response, masterResponse);

        HiveCommonSerializer.addResponseHeaderWithDoneStatus(response);

        return response;
    }

    /**
     * NOOP: don't do any mapping in this case
     */
    @Override
    void mapLocalIDsToNetworkIDs(final ShrineMessage<RequestMessageType> shrineMessage, final ResponseMessageType crcResponse) throws Exception
    {

    }

    /**
     * NOOP: don't do any mapping in this case
     */
    @Override
    void mapNetworkIDsToLocalIDs(final RequestMessageType request) throws Exception
    {

    }
}
