package net.shrine.adapter.query;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import net.shrine.adapter.dao.AdapterDAO;
import net.shrine.config.ShrineConfig;
import net.shrine.serializers.ShrineMessage;
import net.shrine.serializers.crc.CRCHttpClient;
import net.shrine.translators.Translator;
import net.shrine.translators.Translators;
import org.spin.node.QueryContext;
import org.spin.tools.crypto.signature.Identity;

/**
 * @author Justin Quan
 * @date: Mar 25, 2010
 * @link http://cbmi.med.harvard.edu
 * @link http://chip.org
 * <p/>
 * NOTICE: This software comes with NO guarantees whatsoever and is
 * licensed as Lgpl Open Source
 * @link http://www.gnu.org/licenses/lgpl.html
 */
public class GetPDOFromInputListQuery extends AdapterQuery
{
    protected final ShrineConfig shrineConfig;

    public GetPDOFromInputListQuery(final ShrineConfig shrineConfig, final Translator<RequestMessageType> requestTranslator, final AdapterDAO dao)
    {
        super(shrineConfig.getRealCRCEndpoint(), dao, requestTranslator, Translators.<ResponseMessageType>nullTranslator());

        this.shrineConfig = shrineConfig;
    }

    @Override
    protected void beforeQuery(final QueryContext queryContext, final ShrineMessage<RequestMessageType> request) throws Exception {
        super.beforeQuery(queryContext, request);

        updateRequestTimeout(request.getPayload());
    }

    private void updateRequestTimeout(RequestMessageType request)
    {
        request.getRequestHeader().setResultWaittimeMs(shrineConfig.getQueryTTL());
    }

    @Override
    protected ResponseMessageType callCRC(final Identity identity, final RequestMessageType request) throws Exception
    {
        return CRCHttpClient.getPDOFromInputList(shrineConfig.getRealCRCEndpoint(), request);
    }
}
