package net.shrine.adapter.query;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterRequestType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryMasterType;
import net.shrine.adapter.dao.AdapterDAO;
import net.shrine.adapter.dao.MasterQueryDefinition;
import net.shrine.serializers.ShrineMessage;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import org.spin.tools.crypto.signature.Identity;

/**
 * @author Bill Simons
 * @date Sep 15, 2010
 * @link http://cbmi.med.harvard.edu
 * @link http://chip.org
 * <p/>
 * NOTICE: This software comes with NO guarantees whatsoever and is
 * licensed as Lgpl Open Source
 * @link http://www.gnu.org/licenses/lgpl.html
 */
public class GetRequestXmlQuery extends AdapterQuery
{
    public GetRequestXmlQuery(final AdapterDAO dao)
    {
        super("", dao);
    }

    @Override
    protected ResponseMessageType callCRC(Identity identity, RequestMessageType request) throws Exception
    {
        final ResponseMessageType response = CRCSerializer.getTemplateResponseMessageType(request);

        final MasterResponseType responseType = new MasterResponseType();

        MasterRequestType masterRequest = CRCSerializer.getMasterRequest(request);
        Long masterId = Long.valueOf(masterRequest.getQueryMasterId());
        MasterQueryDefinition definition = dao.findMasterQueryDefinition(masterId);
        if(definition != null)
        {
            QueryMasterType queryMaster = definition.toQueryMasterType();
            responseType.getQueryMaster().add(queryMaster);
        }
        responseType.setStatus(makeDoneStatus());
        CRCSerializer.addAnyTypeToBodyNode(response.getMessageBody(), responseType);
        HiveCommonSerializer.addResponseHeaderWithDoneStatus(response);
        return response;
    }

    /**
     * NOOP: don't do any mapping in this case
     */
    @Override
    void mapLocalIDsToNetworkIDs(final ShrineMessage<RequestMessageType> shrineMessage, final ResponseMessageType crcResponse) throws Exception
    {

    }

    /**
     * NOOP: don't do any mapping in this case
     */
    @Override
    void mapNetworkIDsToLocalIDs(final RequestMessageType request) throws Exception
    {

    }
}
