package net.shrine.adapter.query;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterDeleteRequestType;
import net.shrine.adapter.dao.AdapterDAO;
import net.shrine.serializers.ShrineMessage;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.translators.Translator;
import org.spin.node.QueryContext;

/**
 * @author Bill Simons
 * @date Nov 15, 2010
 * @link http://cbmi.med.harvard.edu
 * @link http://chip.org
 * <p/>
 * NOTICE: This software comes with NO guarantees whatsoever and is
 * licensed as Lgpl Open Source
 * @link http://www.gnu.org/licenses/lgpl.html
 */
public class MasterDeleteQuery extends AdapterQuery
{
    protected MasterDeleteQuery(final String crcEndpointURL, final AdapterDAO dao, final Translator<RequestMessageType> requestTranslator, final Translator<ResponseMessageType> responseTranslator)
    {
        super(crcEndpointURL, dao, requestTranslator, responseTranslator);
    }

    @Override
    protected ResponseMessageType afterQuery(QueryContext queryContext, ShrineMessage<RequestMessageType> shrineMessage, ResponseMessageType response, long duration) throws Exception
    {
        ResponseMessageType result = super.afterQuery(queryContext, shrineMessage, response, duration);

        MasterDeleteRequestType deleteRequest = CRCSerializer.getMasterDeleteRequest(shrineMessage.getPayload());
        Long masterId = Long.valueOf(deleteRequest.getQueryMasterId());
        dao.removeMasterDefinitions(masterId);
        dao.removeUserToMasterMapping(masterId);

        return result;
    }
}
