package net.shrine.adapter.query;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterRenameRequestType;
import net.shrine.adapter.dao.AdapterDAO;
import net.shrine.serializers.ShrineMessage;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.translators.Translator;
import org.spin.node.QueryContext;

/**
 * @author Bill Simons
 * @date 2/7/11
 * @link http://cbmi.med.harvard.edu
 * @link http://chip.org
 * <p/>
 * NOTICE: This software comes with NO guarantees whatsoever and is
 * licensed as Lgpl Open Source
 * @link http://www.gnu.org/licenses/lgpl.html
 */
public class MasterRenameQuery extends AdapterQuery
{
    protected MasterRenameQuery(final String crcEndpointURL, final AdapterDAO dao, final Translator<RequestMessageType> requestTranslator, final Translator<ResponseMessageType> responseTranslator)
    {
        super(crcEndpointURL, dao, requestTranslator, responseTranslator);
    }

    @Override
    protected ResponseMessageType afterQuery(QueryContext queryContext, ShrineMessage<RequestMessageType> shrineMessage, ResponseMessageType response, long duration) throws Exception
    {
        ResponseMessageType result = super.afterQuery(queryContext, shrineMessage, response, duration);

        MasterRenameRequestType renameRequest = CRCSerializer.getMasterRenameRequest(shrineMessage.getPayload());
        Long masterId = Long.valueOf(renameRequest.getQueryMasterId());
        dao.updateUsersToMasterQueryName(masterId, renameRequest.getQueryName());

        return result;
    }
}
