package net.shrine.adapter.translators;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import net.shrine.config.I2B2HiveCredentials;
import net.shrine.translators.TranslationException;
import net.shrine.translators.Translator;

/**
 * This class converts translates the authentication between the incomming
 * message and the message that we send to the local CRC.
 * <p/>
 * This translator strips off the header that comes from the input side and
 */
public final class AuthenticationTranslator implements Translator<RequestMessageType>
{
    protected I2B2HiveCredentials credentials;

    public AuthenticationTranslator()
    {

    }

    @Override
    public void translate(final RequestMessageType original) throws TranslationException
    {
        final SecurityType security = original.getMessageHeader().getSecurity();

        security.setDomain(credentials.getDomain());
        security.setUsername(credentials.getUsername());
        security.setPassword(credentials.getPassword());
        original.getMessageHeader().setProjectId(credentials.getProject());
    }

    public void setCredentials(final I2B2HiveCredentials credentials)
    {
        this.credentials = credentials;
    }
}
