package net.shrine.adapter.translators;

import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.ResultResponseType;
import net.shrine.adapter.GaussianObfuscator;
import net.shrine.adapter.dao.AdapterDAO;
import net.shrine.dao.DAOException;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.translators.TranslationException;
import net.shrine.translators.Translator;
import org.spin.query.message.serializer.SerializationException;

/**
 * @author Clint Gilbert
 *         <p/>
 *         Sep 16, 2010
 *         <p/>
 *         Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 */
public final class ObfuscateQueryResultInstanceResponseTranslator implements Translator<ResponseMessageType>
{
    private AdapterDAO dao;

    public ObfuscateQueryResultInstanceResponseTranslator(AdapterDAO dao)
    {
        this.dao = dao;
    }

    @Override
    public void translate(final ResponseMessageType original) throws TranslationException
    {
        final ResultResponseType resultResponse;

        try
        {
            resultResponse = CRCSerializer.getResultResponse(original);
        }
        catch(SerializationException e)
        {
            throw new TranslationException("Error  obfuscating results", e);
        }

        for(final QueryResultInstanceType result : resultResponse.getQueryResultInstance())
        {
            try
            {
                Integer amount = dao.findObfuscationAmount(result.getResultInstanceId());
                if(amount != null)
                {
                    GaussianObfuscator.obfuscate(result, amount);
                }
                else
                {
                    int obfuscationAmount = GaussianObfuscator.obfuscate(result);
                    dao.updateObfuscationAmount(result.getResultInstanceId(), obfuscationAmount);
                }
            }
            catch(DAOException e)
            {
                throw new TranslationException(e);
            }
        }
    }
}
