CREATE TABLE REQUEST_RESPONSE_DATA (
  DOMAIN_NAME VARCHAR(254) NOT NULL,
  USERNAME VARCHAR(254) NOT NULL,
  BROADCAST_QUERY_MASTER_ID BIGINT NOT NULL,
  BROADCAST_QUERY_INSTANCE_ID BIGINT NOT NULL,
  BROADCAST_RESULT_INSTANCE_ID BIGINT NOT NULL,
  RESULT_STATUS VARCHAR(254) NOT NULL,
  RESULT_SET_SIZE NUMERIC(19,0) NOT NULL,
  TIME_ELAPSED NUMERIC (19,0) NOT NULL,
  SPIN_QUERY_ID VARCHAR(254) NOT NULL,
  QUERY_DATETIME TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  RESULT_XML MEDIUMTEXT,
  CONSTRAINT BROADCASTER_ID_MAPPING_PK PRIMARY KEY
  (DOMAIN_NAME, USERNAME, BROADCAST_QUERY_MASTER_ID, BROADCAST_QUERY_INSTANCE_ID, BROADCAST_RESULT_INSTANCE_ID)
) engine=innodb default charset=latin1;

CREATE TABLE MASTER_QUERY (
  BROADCAST_QUERY_MASTER_ID BIGINT NOT NULL,
  LOCAL_QUERY_MASTER_ID VARCHAR(254) NOT NULL,
  QUERY_DEFINITION TEXT,
  CONSTRAINT MASTER_ID_MAPPING_PK PRIMARY KEY (BROADCAST_QUERY_MASTER_ID),
  CONSTRAINT LOCAL_MASTER_ID_INDEX UNIQUE (LOCAL_QUERY_MASTER_ID)
) engine=innodb default charset=latin1;

CREATE TABLE INSTANCE_IDS (
  BROADCAST_QUERY_INSTANCE_ID BIGINT NOT NULL,
  LOCAL_QUERY_INSTANCE_ID VARCHAR(254) NOT NULL,
  CONSTRAINT INSTANCE_ID_MAPPING_PK PRIMARY KEY (BROADCAST_QUERY_INSTANCE_ID),
  CONSTRAINT LOCAL_INSTANCE_ID_INDEX UNIQUE (LOCAL_QUERY_INSTANCE_ID)
) engine=innodb default charset=latin1;

CREATE TABLE RESULT_IDS (
  BROADCAST_RESULT_INSTANCE_ID BIGINT NOT NULL,
  LOCAL_RESULT_INSTANCE_ID VARCHAR(254) NOT NULL,
  OBFUSCATION_AMOUNT INT,
  CONSTRAINT RESULT_ID_MAPPING_PK PRIMARY KEY (BROADCAST_RESULT_INSTANCE_ID),
  CONSTRAINT LOCAL_RESULT_ID_INDEX UNIQUE (LOCAL_RESULT_INSTANCE_ID)
) engine=innodb default charset=latin1;

CREATE TABLE USERS_TO_MASTER_QUERY (
  DOMAIN_NAME VARCHAR(254) NOT NULL,
  USERNAME VARCHAR(254) NOT NULL,
  BROADCAST_QUERY_MASTER_ID BIGINT NOT NULL,
  MASTER_NAME VARCHAR(254) NOT NULL,
  MASTER_CREATE_DATE DATETIME NOT NULL,
  CONSTRAINT USERS_TO_MASTER_QUERY_PK PRIMARY KEY (DOMAIN_NAME, USERNAME, BROADCAST_QUERY_MASTER_ID),
  CONSTRAINT USERS_TO_MASTER_BROADCAST_QUERY_MASTER_ID_INDEX UNIQUE (BROADCAST_QUERY_MASTER_ID)
) engine=innodb default charset=latin1;

CREATE TABLE PRIVILEGED_USER (
  ID int(10) not null AUTO_INCREMENT,
  USERNAME VARCHAR(254) NOT NULL,
  THRESHOLD MEDIUMINT NOT NULL,
  CONSTRAINT PRIVILEGED_USERS_PK PRIMARY KEY (ID),
  CONSTRAINT IX_PRIVILEGED_USER_USERNAME UNIQUE (USERNAME)
) engine=innodb default charset=latin1;
