CREATE TABLE "SHRINE_QUERY" ("ID" INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,"LOCAL_ID" VARCHAR NOT NULL,"NETWORK_ID" BIGINT NOT NULL,"QUERY_NAME" VARCHAR NOT NULL,"USERNAME" VARCHAR NOT NULL,"DOMAIN" VARCHAR NOT NULL,"QUERY_EXPRESSION" VARCHAR NOT NULL,"DATE_CREATED" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP)

CREATE TABLE "QUERY_RESULT" ("ID" INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,"LOCAL_ID" VARCHAR NOT NULL,"QUERY_ID" INTEGER NOT NULL,"TYPE" VARCHAR NOT NULL,"STATUS" VARCHAR NOT NULL,"TIME_ELAPSED" BIGINT NULL,"LAST_UPDATED" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP)
ALTER TABLE "QUERY_RESULT" ADD CONSTRAINT "QueryResultQueryId_FK" FOREIGN KEY("QUERY_ID") REFERENCES "SHRINE_QUERY"("ID") ON UPDATE NO ACTION ON DELETE CASCADE

CREATE TABLE "COUNT_RESULT" ("ID" INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,"RESULT_ID" INTEGER NOT NULL,"ORIGINAL_COUNT" BIGINT NOT NULL,"OBFUSCATED_COUNT" BIGINT NOT NULL,"DATE_CREATED" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP)
ALTER TABLE "COUNT_RESULT" ADD CONSTRAINT "CountResultResultId_FK" FOREIGN KEY("RESULT_ID") REFERENCES "QUERY_RESULT"("ID") ON UPDATE NO ACTION ON DELETE CASCADE

CREATE TABLE "BREAKDOWN_RESULT" ("ID" INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,"RESULT_ID" INTEGER NOT NULL,"DATA_KEY" VARCHAR NOT NULL,"ORIGINAL_VALUE" BIGINT NOT NULL,"OBFUSCATED_VALUE" BIGINT NOT NULL)
ALTER TABLE "BREAKDOWN_RESULT" ADD CONSTRAINT "BreakdownResultResultId_FK" FOREIGN KEY("RESULT_ID") REFERENCES "QUERY_RESULT"("ID") ON UPDATE NO ACTION ON DELETE CASCADE

CREATE TABLE "ERROR_RESULT" ("ID" INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,"RESULT_ID" INTEGER NOT NULL,"MESSAGE" VARCHAR NOT NULL)
ALTER TABLE "ERROR_RESULT" ADD CONSTRAINT "ErrorResultResultId_FK" FOREIGN KEY("RESULT_ID") REFERENCES "QUERY_RESULT"("ID") ON UPDATE NO ACTION ON DELETE CASCADE

CREATE TABLE "PATIENT_SET" ("ID" INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,"RESULT_ID" INTEGER NOT NULL,"PATIENT_NUM" VARCHAR NOT NULL)
ALTER TABLE "PATIENT_SET" ADD CONSTRAINT "PatientSetResultId_FK" FOREIGN KEY("RESULT_ID") REFERENCES "QUERY_RESULT"("ID") ON UPDATE NO ACTION ON DELETE CASCADE

CREATE TABLE "PRIVILEGED_USER" ("ID" INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,"USERNAME" VARCHAR NOT NULL,"DOMAIN" VARCHAR NOT NULL,"THRESHOLD" INTEGER NOT NULL,"OVERRIDE_DATE" TIMESTAMP)
CREATE UNIQUE INDEX "usernameAndDomainIndex" ON "PRIVILEGED_USER"("USERNAME","DOMAIN")
