/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.agent;

import java.net.URL;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.SpinNode;
import org.spin.node.acknack.AckNack;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.cache.CacheEntry;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.query.message.serializer.BasicSerializer;
import org.spin.query.message.serializer.SerializerException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.Util;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent {
    private static final Logger log = Logger.getLogger(Agent.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private final AgentConfig agentConfig;
    private final SpinNode spinNode;

    public Agent() throws ConfigException, NodeException {
        this(ConfigTool.loadAgentConfig());
    }

    public Agent(AgentConfig agentConfig) throws ConfigException, NodeException {
        this(agentConfig, (SpinNode)NodeConnector.instance((String)agentConfig.getNodeConnectorEndpoint().getAddress()));
    }

    public Agent(AgentConfig agentConfig, URL nodeWsdlURL) throws ConfigException, NodeException {
        this(agentConfig, (SpinNode)NodeConnector.instance((URL)nodeWsdlURL));
    }

    public Agent(AgentConfig agentConfig, SpinNode spinNode) throws ConfigException {
        if (agentConfig == null) {
            throw new ConfigException("Null AgentConfig passed in");
        }
        if (spinNode == null) {
            throw new ConfigException("Null SpinNode passed in");
        }
        this.agentConfig = agentConfig;
        this.spinNode = spinNode;
        if (INFO) {
            log.info((Object)"Initialized Agent");
        }
    }

    public AgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public Identity certify(String username, String password, String role) throws IdentityServiceException {
        return this.spinNode.certify(username, password, role);
    }

    public AckNack send(QueryInfo queryInfo, String conditions) throws SerializerException, AgentException, CacheException {
        return this.send(queryInfo, conditions, NullSerializer.Instance);
    }

    public <Conditions> AckNack send(QueryInfo queryInfo, Conditions conditions) throws SerializerException, AgentException, CacheException {
        return this.send(queryInfo, conditions, new SerializeOnlyJAXBSerializer());
    }

    public <Conditions> AckNack send(QueryInfo queryInfo, Conditions conditions, BasicSerializer<Conditions> serializer) throws SerializerException, AgentException, CacheException {
        this.setupQueryInfo(queryInfo);
        try {
            AckNack result = this.spinNode.query(queryInfo, serializer.toXMLString(conditions));
            if (INFO) {
                log.info((Object)Util.concat((Object[])new Object[]{"Sent query ", result.getQueryID(), ". Node response: ", result.getStatuses()}));
            }
            return result;
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    protected void setupQueryInfo(QueryInfo queryInfo) {
        if (queryInfo.getPeerGroup() == null) {
            queryInfo.setPeerGroup(this.agentConfig.getPeerGroupToQuery());
        }
        if (queryInfo.getAggregator() == null) {
            queryInfo.setAggregator(this.agentConfig.getRootAggregatorEndpoint());
        }
    }

    public QueryInfo getDefaultQueryInfo(String queryType) {
        QueryInfo qInfo = new QueryInfo();
        qInfo.setAggregator(this.agentConfig.getRootAggregatorEndpoint());
        qInfo.setPeerGroup(this.agentConfig.getPeerGroupToQuery());
        qInfo.setQueryType(queryType);
        return qInfo;
    }

    public CacheEntry receive(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.receive(queryID, requestorID, this.agentConfig.getMaxWaitTime());
    }

    public CacheEntry receive(String queryID, Identity requestorID, long waitTime) throws CacheException, QueryNotFoundException {
        return this.receive(queryID, requestorID, waitTime, 0);
    }

    public CacheEntry receive(String queryID, Identity requestorID, long waitTime, int numExpectedResponses) throws CacheException, QueryNotFoundException {
        if (DEBUG) {
            log.debug((Object)Util.concat((Object[])new Object[]{"Agent receiving query ", queryID}));
        }
        long sleepTime = this.computeWaitTime();
        if (DEBUG) {
            log.debug((Object)Util.concat((Object[])new Object[]{"Agent waiting ", sleepTime, "ms between polling attempts"}));
        }
        long timeToStopWaiting = System.currentTimeMillis() + waitTime;
        while (this.queryIsNotComplete(queryID, numExpectedResponses)) {
            this.checkForTimeout(queryID, waitTime, timeToStopWaiting);
            this.sleepFor(sleepTime);
        }
        return this.getResultNoDelete(queryID, requestorID);
    }

    private final void checkForTimeout(String queryID, long waitTime, long timeToStopWaiting) throws CacheException {
        if (System.currentTimeMillis() > timeToStopWaiting) {
            throw new CacheException(Util.concat((Object[])new Object[]{"Could not complete query ", queryID, " in ", waitTime, " (ms)"}));
        }
    }

    private final void sleepFor(long sleepTime) throws CacheException {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted while trying to receive", (Throwable)e);
        }
    }

    private final boolean queryIsNotComplete(String queryID, int numExpectedResponses) throws CacheException, QueryNotFoundException {
        return Agent.notSpecified(numExpectedResponses) ? !this.isComplete(queryID) : this.countResponders(queryID) < numExpectedResponses;
    }

    private static final boolean notSpecified(int numExpectedResponses) {
        return numExpectedResponses < 1;
    }

    private final long computeWaitTime() {
        return (long)(1.0f / this.getPollingFrequency() * 1000.0f);
    }

    private final float getPollingFrequency() {
        return this.agentConfig.getPollingFrequency() != null ? this.agentConfig.getPollingFrequency().floatValue() : 1.0f;
    }

    public CacheEntry getResult(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        if (DEBUG) {
            log.debug((Object)Util.concat((Object[])new Object[]{"Getting results (and deleting) for query ", queryID}));
        }
        return this.spinNode.getResult(queryID, requestorID);
    }

    public CacheEntry getResultNoDelete(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
        if (DEBUG) {
            log.debug((Object)Util.concat((Object[])new Object[]{"Getting results (NOT deleting) for query ", queryID}));
        }
        return this.spinNode.getResultNoDelete(queryID, requestorID);
    }

    public boolean isComplete(String queryID) throws CacheException, QueryNotFoundException {
        boolean complete = this.spinNode.isComplete(queryID);
        if (DEBUG) {
            log.debug((Object)Util.concat((Object[])new Object[]{"Query ", queryID, " has ", complete ? "" : "NOT", " completed"}));
        }
        return complete;
    }

    public int countResponders(String queryID) throws CacheException, QueryNotFoundException {
        int numResponses = this.spinNode.countResponses(queryID);
        if (DEBUG) {
            log.debug((Object)Util.concat((Object[])new Object[]{"Query ", queryID, " has ", numResponses, " responses so far"}));
        }
        return numResponses;
    }

    public boolean hasUpdate(String queryID, int numResponders) throws CacheException, QueryNotFoundException {
        boolean hasUpdate = this.spinNode.hasUpdate(queryID, numResponders);
        if (DEBUG) {
            log.debug((Object)Util.concat((Object[])new Object[]{"Query ", queryID, hasUpdate ? " has updates " : " has NO updates"}));
        }
        return hasUpdate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class NullSerializer
    implements BasicSerializer<String> {
        protected static final NullSerializer Instance = new NullSerializer();

        private NullSerializer() {
        }

        public String fromXML(String string) throws SerializerException {
            return string;
        }

        public String toXMLString(String string) throws SerializerException {
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class SerializeOnlyJAXBSerializer<T>
    implements BasicSerializer<T> {
        protected SerializeOnlyJAXBSerializer() {
        }

        public String toXMLString(T object) throws SerializerException {
            try {
                return JAXBUtils.marshalToString(object);
            }
            catch (JAXBException e) {
                throw new SerializerException((Exception)((Object)e));
            }
        }

        public T fromXML(String xml) throws SerializerException {
            throw new SerializerException("Not implemented; See JAXBBasicSerializer");
        }
    }
}

