/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.SpinNode;
import org.spin.node.acknack.AckNack;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.agent.Agent;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.criteria.EncryptableCriteria;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.Result;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.serializer.SerializerException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.Util;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.PKCryptor;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Querier {
    private static final Logger log = Logger.getLogger(Querier.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    protected final AgentConfig agentConfig;
    protected final Agent agent;
    protected final IdentityService identityService;
    protected final PKCryptor cryptor;

    public Querier(IdentityService identityService) throws ConfigException, NodeException {
        this(ConfigTool.loadAgentConfig(), identityService);
    }

    public Querier(AgentConfig agentConfig, IdentityService identityService) throws ConfigException, NodeException {
        this(agentConfig, identityService, NodeConnector.instance((String)agentConfig.getNodeConnectorEndpoint().getAddress()));
    }

    public Querier(AgentConfig agentConfig, IdentityService identityService, NodeConnector nodeConnector) throws ConfigException {
        if (agentConfig == null) {
            throw new ConfigException("Null AgentConfig passed in.");
        }
        if (identityService == null) {
            throw new ConfigException("Null IdentityService passed in");
        }
        if (nodeConnector == null) {
            throw new ConfigException("Null NodeConnector passed in");
        }
        this.agentConfig = agentConfig;
        this.identityService = identityService;
        this.cryptor = new PKCryptor();
        if (DEBUG) {
            log.debug((Object)"Loaded PKITool");
        }
        this.agent = new Agent(agentConfig, (SpinNode)nodeConnector);
        if (DEBUG) {
            log.debug((Object)"Created agent");
        }
    }

    public <Conditions extends EncryptableCriteria> List<String> query(String queryType, Credentials credentials, Conditions conditions) throws AgentException {
        return this.query(queryType, credentials, conditions, Encryption.None);
    }

    public List<String> query(String queryType, Credentials credentials, String conditions) throws AgentException {
        return this.query(queryType, credentials, conditions, Encryption.None);
    }

    public <Conditions extends EncryptableCriteria> List<String> query(String queryType, Credentials credentials, Conditions conditions, Encryption encryptionRequested) throws AgentException {
        return this.query(queryType, credentials, conditions, encryptionRequested, new UnserializedConditionsQuerySendingStrategy());
    }

    public List<String> query(String queryType, Credentials credentials, String conditions, Encryption encryptionRequested) throws AgentException {
        return this.query(queryType, credentials, conditions, encryptionRequested, new PreSerializedConditionsQuerySendingStrategy());
    }

    private <Conditions> List<String> query(String queryType, Credentials credentials, Conditions conditions, Encryption encryptionRequested, QuerySendingStrategy<Conditions> queryStrategy) throws AgentException {
        try {
            AckNack ack = queryStrategy.sendAsync(queryType, credentials, conditions, encryptionRequested);
            Identity requestorID = this.identityService.certify(credentials.getDomain(), credentials.getUsername(), credentials.getPassword());
            return this.receive(ack, requestorID);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    public List<String> receive(AckNack ack, Identity requestorID) throws AgentException {
        if (ack == null) {
            throw new AgentException("Null AckNack!");
        }
        return this.receive(ack.getQueryID(), requestorID);
    }

    public List<String> receive(String queryID, Identity requestorID) throws AgentException {
        Collection results;
        try {
            results = this.agent.receive(queryID, requestorID).getResponses();
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
        if (results == null) {
            throw new AgentException("Null result!");
        }
        if (INFO) {
            log.info((Object)"Got result");
        }
        if (DEBUG) {
            for (String result : results) {
                log.debug((Object)("Raw result XML: " + result));
            }
        }
        return this.processResults(results);
    }

    public AckNack queryAsync(String queryType, Credentials credentials, String conditions) throws AgentException {
        return this.queryAsync(queryType, credentials, conditions, Encryption.None);
    }

    public <Conditions extends EncryptableCriteria> AckNack queryAsync(String queryType, Credentials credentials, Conditions conditions) throws AgentException {
        return this.queryAsync(queryType, credentials, conditions, Encryption.None);
    }

    public AckNack queryAsync(String queryType, Credentials credentials, String conditions, Encryption encryptionRequested) throws AgentException {
        return this.queryAsync(queryType, credentials, conditions, encryptionRequested, new NullCryptoSetupStrategy(), new StringConditionsAgentInvocationStrategy());
    }

    public <Conditions extends EncryptableCriteria> AckNack queryAsync(String queryType, Credentials credentials, Conditions conditions, Encryption encryptionRequested) throws AgentException {
        return this.queryAsync(queryType, credentials, conditions, encryptionRequested, new PKCryptoSetupStrategy(), new GenericConditionsAgentInvocationStrategy());
    }

    private <Conditions> AckNack queryAsync(String queryType, Credentials credentials, Conditions conditions, Encryption encryptionRequested, CryptoSetupStrategy<Conditions> cryptoStrategy, AgentInvocationStrategy<Conditions> agentStrategy) throws AgentException {
        try {
            QueryInfo queryInfo = this.makeQueryInfo(queryType);
            queryInfo.setIdentity(this.identityService.certify(credentials.getDomain(), credentials.getUsername(), credentials.getPassword()));
            AckNack ack = agentStrategy.send(queryInfo, cryptoStrategy.setupCryptoFields(conditions, encryptionRequested));
            if (INFO) {
                log.info((Object)("Sent query: " + ack.getQueryID()));
            }
            return ack;
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    public boolean isComplete(String queryID) throws AgentException {
        try {
            return this.agent.isComplete(queryID);
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    public final List<String> processResults(Collection<String> rawResults) throws AgentException {
        if (rawResults == null) {
            return null;
        }
        if (DEBUG) {
            log.debug((Object)("Processing " + rawResults.size() + " results"));
        }
        ArrayList processedResults = Util.makeArrayList((int)rawResults.size());
        for (String resultXML : rawResults) {
            if (resultXML != null) {
                Result result = null;
                try {
                    result = (Result)JAXBUtils.unmarshal((String)resultXML, Result.class);
                    if (DEBUG) {
                        log.debug((Object)("nodeName: '" + result.getNodeID() + "'"));
                        log.debug((Object)("encrypted: " + result.isEncrypted()));
                        log.debug((Object)("payload: " + result.getPayload().length() + " characters long"));
                        String payload = result.getPayload();
                        int numChars = Math.min(payload.length(), 200);
                        log.debug((Object)("first " + numChars + ": " + payload.substring(0, numChars)));
                    }
                    processedResults.add(this.getPlaintextResults(result));
                }
                catch (Exception e) {
                    log.error((Object)("Error decrypting result from node '" + (result != null ? result.getNodeID() : "unknown") + "', continuing with other results"), (Throwable)e);
                }
                continue;
            }
            log.warn((Object)"Null resultXML");
        }
        return processedResults;
    }

    private final String getPlaintextResults(Result rawResult) throws CryptoException {
        if (rawResult.isEncrypted()) {
            return this.cryptor.decryptAndVerify(rawResult.getPayload());
        }
        return rawResult.getPayload();
    }

    public static <T> List<T> unmarshallResults(List<String> xmlResults, Class<T> resultClass) throws JAXBException {
        ArrayList result = Util.makeArrayList();
        for (String xml : xmlResults) {
            if (xml == null || xml.length() <= 0) continue;
            result.add(JAXBUtils.unmarshal((String)xml, resultClass));
        }
        return result;
    }

    protected String decryptResults(String encrypted) throws CryptoException {
        return this.cryptor.decryptAndVerify(encrypted);
    }

    private final QueryInfo makeQueryInfo(String queryType) {
        QueryInfo queryInfo = new QueryInfo();
        queryInfo.setQueryType(queryType);
        queryInfo.setPeerGroup(this.agentConfig.getPeerGroupToQuery());
        queryInfo.setAggregator(this.agentConfig.getRootAggregatorEndpoint());
        return queryInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GenericConditionsAgentInvocationStrategy<C>
    extends AgentInvocationStrategy<C> {
        private GenericConditionsAgentInvocationStrategy() {
        }

        @Override
        protected AckNack send(QueryInfo queryInfo, C conditions) throws AgentException, CacheException, SerializerException {
            return Querier.this.agent.send(queryInfo, conditions);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringConditionsAgentInvocationStrategy
    extends AgentInvocationStrategy<String> {
        private StringConditionsAgentInvocationStrategy() {
        }

        @Override
        protected AckNack send(QueryInfo queryInfo, String conditions) throws AgentException, CacheException, SerializerException {
            return Querier.this.agent.send(queryInfo, conditions);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AgentInvocationStrategy<C> {
        private AgentInvocationStrategy() {
        }

        protected abstract AckNack send(QueryInfo var1, C var2) throws AgentException, CacheException, SerializerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PKCryptoSetupStrategy<Conditions extends EncryptableCriteria>
    extends CryptoSetupStrategy<Conditions> {
        private PKCryptoSetupStrategy() {
        }

        @Override
        protected Conditions setupCryptoFields(Conditions criteria, Encryption encryptionRequested) {
            if (criteria != null) {
                boolean requireEncryptedResults = encryptionRequested.getBooleanValue();
                criteria.setShouldEncryptResults(requireEncryptedResults);
                if (requireEncryptedResults) {
                    criteria.setEncryptResultsFor(Querier.this.cryptor.getPKITool().getMyCertID());
                }
            }
            return criteria;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NullCryptoSetupStrategy
    extends CryptoSetupStrategy<String> {
        private NullCryptoSetupStrategy() {
        }

        @Override
        protected String setupCryptoFields(String conditions, Encryption ignored) {
            return conditions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CryptoSetupStrategy<T> {
        private CryptoSetupStrategy() {
        }

        protected abstract T setupCryptoFields(T var1, Encryption var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnserializedConditionsQuerySendingStrategy<Conditions extends EncryptableCriteria>
    extends QuerySendingStrategy<Conditions> {
        private UnserializedConditionsQuerySendingStrategy() {
        }

        @Override
        protected AckNack sendAsync(String queryType, Credentials credentials, Conditions conditions, Encryption encryptionRequested) throws AgentException {
            return Querier.this.queryAsync(queryType, credentials, conditions, encryptionRequested);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreSerializedConditionsQuerySendingStrategy
    extends QuerySendingStrategy<String> {
        private PreSerializedConditionsQuerySendingStrategy() {
        }

        @Override
        protected AckNack sendAsync(String queryType, Credentials credentials, String conditions, Encryption encryptionRequested) throws AgentException {
            return Querier.this.queryAsync(queryType, credentials, conditions, encryptionRequested);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class QuerySendingStrategy<T> {
        private QuerySendingStrategy() {
        }

        protected abstract AckNack sendAsync(String var1, Credentials var2, T var3, Encryption var4) throws AgentException;
    }

    public static class Credentials {
        private final String username;
        private final String password;
        private final String domain;

        public Credentials() {
            this(null, null, null);
        }

        public Credentials(String domain, String username, String password) {
            this.domain = domain;
            this.username = username;
            this.password = password;
        }

        public final String getUsername() {
            return this.username;
        }

        public final String getPassword() {
            return this.password;
        }

        public final String getDomain() {
            return this.domain;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Encryption {
        None(false),
        Required(true);

        private final boolean booleanValue;

        private Encryption(boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }
    }
}

