/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.spin.node.SpinNodeImpl;
import org.spin.tools.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeRegistry {
    private static final Logger log = Logger.getLogger(NodeRegistry.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private static final Set<SpinNodeImpl> registeredNodes = Util.makeHashSet();

    protected static Collection<SpinNodeImpl> getRegisteredNodes() {
        return Collections.unmodifiableCollection(registeredNodes);
    }

    public static void register(SpinNodeImpl node) {
        if (node != null) {
            registeredNodes.add(node);
            if (DEBUG) {
                log.debug((Object)("Registered node with ID " + node.getNodeID()));
            }
        }
    }

    public static void shutDown() {
        for (SpinNodeImpl node : registeredNodes) {
            node.destroy();
        }
        registeredNodes.clear();
        if (INFO) {
            log.info((Object)"Shut down nodes successfully");
        }
    }
}

