/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.spin.node.QueryMap;
import org.spin.node.SpinNodeImpl;
import org.spin.node.UnknownQueryTypeException;
import org.spin.node.actions.QueryAction;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.Util;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.QueryTypeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMapContext
implements QueryMap {
    private static final Logger log = Logger.getLogger(QueryMapContext.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private final Map<String, QueryAction<?>> queryTypeMap = Util.makeHashMap();
    private SpinNodeImpl enclosingNode = null;

    public SpinNodeImpl getEnclosingNode() {
        return this.enclosingNode;
    }

    public void setEnclosingNode(SpinNodeImpl enclosingNode) {
        this.enclosingNode = enclosingNode;
    }

    public void loadQueryActions(NodeConfig config) {
        for (QueryTypeConfig queryConfig : config.getQueries()) {
            if (queryConfig == null || queryConfig.getQueryType() == null || queryConfig.getClassName() == null) continue;
            this.mapQueryAction(queryConfig.getQueryType(), queryConfig.getClassName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapQueryAction(String queryType, String queryClassName) {
        try {
            QueryAction<?> queryActionInstance = QueryMapContext.createQueryAction(queryClassName);
            if (this.enclosingNode != null) {
                queryActionInstance.setEnclosingNode(this.enclosingNode);
            }
            Map<String, QueryAction<?>> map = this.queryTypeMap;
            synchronized (map) {
                this.queryTypeMap.put(queryType, queryActionInstance);
            }
            if (INFO) {
                log.info((Object)("Instantiated " + queryClassName + " to handle query type '" + queryType + "'"));
            }
        }
        catch (DynamicLoadingException e) {
            log.warn((Object)("Could not instantiate " + queryClassName + " to handle query type '" + queryType + "': "), (Throwable)e);
        }
    }

    @Override
    public final QueryAction<?> getQueryAction(String queryType) throws UnknownQueryTypeException {
        if (!this.queryTypeMap.containsKey(queryType)) {
            throw new UnknownQueryTypeException("Unknown query type: '" + queryType + "'.  See node.xml");
        }
        return this.queryTypeMap.get(queryType);
    }

    @Override
    public final String getQueryTypeFor(Class<?> queryTypeClass) throws UnknownQueryTypeException {
        for (String queryType : this.queryTypeMap.keySet()) {
            if (!this.queryTypeMap.get(queryType).getClass().equals(queryTypeClass)) continue;
            return queryType;
        }
        throw new UnknownQueryTypeException("No query type found that's implemented by " + queryTypeClass.getName());
    }

    @Override
    public Collection<String> getQueryTypes() {
        return this.queryTypeMap.keySet();
    }

    private static final QueryAction<?> createQueryAction(String queryClassName) throws DynamicLoadingException {
        try {
            return (QueryAction)ClassTools.createInstance((String)queryClassName, QueryAction.class);
        }
        catch (Throwable e) {
            throw new DynamicLoadingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        log.info((Object)"Shutting down all query types, calling destroy()");
        Map<String, QueryAction<?>> map = this.queryTypeMap;
        synchronized (map) {
            for (QueryAction<?> queryAction : this.queryTypeMap.values()) {
                queryAction.destroy();
            }
        }
    }
}

