/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.SpinNodeImpl;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.headers.QueryInfo;

public class QueryOperation
implements Runnable {
    private static Logger log = Logger.getLogger(QueryOperation.class);
    private static boolean DEBUG = log.isDebugEnabled();
    private final String criteria;
    private final QueryInfo queryInfo;
    private final SpinNodeImpl node;

    public QueryOperation(SpinNodeImpl node, QueryInfo queryInfo, String criteria) throws NodeException {
        if (node == null) {
            throw new NodeException("Null Node passed in");
        }
        if (queryInfo == null) {
            throw new NodeException("Null QueryInfo passed in");
        }
        if (criteria == null) {
            throw new NodeException("Null criteria passed in");
        }
        this.node = node;
        this.queryInfo = queryInfo;
        this.criteria = criteria;
    }

    public void run() {
        String responsePayload = this.doQueryAction();
        try {
            this.node.aggregate(this.node.getNodeID(), this.queryInfo, responsePayload);
        }
        catch (CacheException e) {
            log.error((Object)("Error aggregating to enclosing node with keyID " + this.node.getNodeID()));
        }
    }

    private String doQueryAction() {
        try {
            if (DEBUG) {
                log.debug((Object)"Starting local(leaf) query.");
            }
            String responsePayload = this.node.doQueryAction(this.queryInfo, this.criteria);
            if (DEBUG) {
                log.debug((Object)"Done with local(leaf) query.");
            }
            return responsePayload;
        }
        catch (Exception e) {
            log.warn((Object)("Failed to perform local query " + this.queryInfo.getQueryID()), (Throwable)e);
            return null;
        }
    }
}

