/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.log4j.Logger;
import org.spin.node.DefaultQueries;
import org.spin.node.ExpectationSetter;
import org.spin.node.NodeException;
import org.spin.node.NodeRegistry;
import org.spin.node.QueryMap;
import org.spin.node.QueryMapContext;
import org.spin.node.QueryOperation;
import org.spin.node.SpinNode;
import org.spin.node.acknack.AckNack;
import org.spin.node.acknack.AckOperationFactory;
import org.spin.node.actions.QueryAction;
import org.spin.node.actions.QueryException;
import org.spin.node.aggregation.AggregateOperationFactory;
import org.spin.node.broadcast.Broadcaster;
import org.spin.node.logging.QueryLogger;
import org.spin.query.message.cache.CacheEntry;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.MemoryResidentCache;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.cache.StatusCode;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.query.message.identity.IdentityServiceFactory;
import org.spin.tools.NetworkTime;
import org.spin.tools.PKITool;
import org.spin.tools.RandomTool;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.PeerGroupConfig;
import org.spin.tools.config.QueryStatus;
import org.spin.tools.config.RoutingTableConfig;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.XMLSignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="SpinNode", portName="SpinNodePort", targetNamespace="http://org.spin.node/", endpointInterface="org.spin.node.SpinNode")
@HandlerChain(file="/handlers.xml")
public class SpinNodeImpl
implements SpinNode {
    private static final Logger log = Logger.getLogger(SpinNodeImpl.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private final NodeConfig nodeConfig;
    private final RoutingTableConfig routingTable;
    private final QueryMapContext queryMapContext;
    private final PKITool pkiTool;
    private final IdentityService identityService;
    private final Broadcaster broadcaster;
    private final QueryLogger queryLog;
    private CertID nodeID;
    protected final MemoryResidentCache cache = new MemoryResidentCache();
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public SpinNodeImpl() throws ConfigException {
        this(ConfigTool.loadNodeConfig(), ConfigTool.loadRoutingTableConfig());
    }

    public SpinNodeImpl(NodeConfig config, RoutingTableConfig routingTable) throws ConfigException {
        this.nodeConfig = config;
        this.ensureDefaultQueriesArePresent(this.nodeConfig);
        this.routingTable = routingTable;
        this.identityService = config.isAuthenticator() ? IdentityServiceFactory.makeIdentityService((NodeConfig)config) : null;
        this.broadcaster = this.makeBroadcaster(config, routingTable);
        try {
            this.pkiTool = config.getKeyStoreConfig() != null ? PKITool.getInstance((KeyStoreConfig)config.getKeyStoreConfig()) : PKITool.getInstance();
            this.nodeID = this.pkiTool.getMyCertID();
            this.queryMapContext = new QueryMapContext();
            this.queryMapContext.setEnclosingNode(this);
            this.queryMapContext.loadQueryActions(config);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException("Error loading NodeConfig: " + e.getMessage(), (Throwable)e);
        }
        if (INFO) {
            log.info((Object)"Initializing SPIN Query Logging.");
        }
        this.queryLog = new QueryLogger();
        NodeRegistry.register(this);
        if (INFO) {
            log.info((Object)"Node registered with node registry.");
            log.info((Object)"Node initialization complete.");
        }
    }

    protected void ensureDefaultQueriesArePresent(NodeConfig config) {
        for (DefaultQueries queryDescriptor : DefaultQueries.values()) {
            if (config.hasQueryType(queryDescriptor.queryType)) continue;
            config.addQuery(queryDescriptor.toQueryTypeConfig());
        }
    }

    private final Broadcaster makeBroadcaster(NodeConfig config, RoutingTableConfig routingTable) throws ConfigException {
        if (!config.isBroadcaster()) {
            return null;
        }
        ExpectationSetter expectationSetter = this.makeExpectationSetter();
        return routingTable != null ? new Broadcaster(this.executor, routingTable, expectationSetter) : new Broadcaster(this.executor, expectationSetter);
    }

    private final ExpectationSetter makeExpectationSetter() {
        return new ExpectationSetter(){

            public void expectChildren(QueryInfo queryInfo, int howMany) throws CacheException {
                SpinNodeImpl.this.expectResponse(queryInfo, SpinNodeImpl.this.getStatuses(), howMany);
            }
        };
    }

    protected EndpointDescriptor getRootNodeEndpoint(QueryInfo queryInfo) throws NodeException {
        if (queryInfo.getAggregator() == null) {
            return new EndpointDescriptor(this.getParentEndpoint(queryInfo.getPeerGroup()), EndpointDescriptor.Type.Parent);
        }
        return new EndpointDescriptor(queryInfo.getAggregator(), EndpointDescriptor.Type.PeerGroupAggregator);
    }

    protected EndpointConfig getParentEndpoint(String peerGroup) throws NodeException {
        PeerGroupConfig peerGroupConfig = this.getRoutingTable().get(peerGroup);
        if (peerGroupConfig == null) {
            throw new NodeException("Couldn't get routing config for peer group '" + peerGroup + "'");
        }
        return peerGroupConfig.getParent();
    }

    @Override
    @WebMethod
    public Identity certify(@WebParam(name="username") String username, @WebParam(name="password") String password, @WebParam(name="role") String role) {
        if (this.nodeConfig.isAuthenticator()) {
            try {
                return this.identityService.certify(username, password, role);
            }
            catch (IdentityServiceException e) {
                log.error((Object)"Couldn't certify identity: ", (Throwable)e);
            }
        }
        if (INFO) {
            log.info((Object)"certify() invoked on Node not configured as an authenticator; returning null.");
        }
        return null;
    }

    protected boolean isRoutingLoop(List<CertID> routedBy) {
        return routedBy.contains(this.nodeID);
    }

    @Override
    @WebMethod
    public AckNack query(@WebParam(name="queryInfo") QueryInfo queryInfo, @WebParam(name="criteria") String criteria) {
        if (queryInfo == null) {
            return new AckNack(RandomTool.randomString(), StatusCode.MalformedHeader);
        }
        if (queryInfo.getQueryID() == null) {
            queryInfo.setQueryID(RandomTool.randomString());
            this.cache.initQuery(queryInfo);
        } else if (this.isDuplicateQuery(queryInfo)) {
            return new AckNack(queryInfo.getQueryID(), StatusCode.RoutingLoop);
        }
        if (DEBUG) {
            log.debug((Object)"Logging access request.");
        }
        if (!this.logAuditTrail(queryInfo, criteria)) {
            return new AckNack(queryInfo.getQueryID(), StatusCode.NodeUnavailable);
        }
        if (this.isRoutingLoop(queryInfo.getRoutedByNodes())) {
            log.error((Object)("Routing loop detected at Node: " + this.nodeID + ", routedBy: " + queryInfo.getRoutedByNodes()));
            return new AckNack(queryInfo.getQueryID(), StatusCode.RoutingLoop);
        }
        if (this.neitherBroadcasterNorQueryable()) {
            return new AckNack(queryInfo.getQueryID(), StatusCode.ServiceNotSupported);
        }
        if (this.hasBadPeerGroup(queryInfo)) {
            return new AckNack(queryInfo.getQueryID(), StatusCode.UnknownPeergroup);
        }
        if (this.hasUnkownQueryType(queryInfo)) {
            return new AckNack(queryInfo.getQueryID(), StatusCode.UnsupportedQueryType);
        }
        if (DEBUG) {
            log.debug((Object)"Client message passed inspection, attempting query.");
        }
        if (!this.checkDigitalSignature(queryInfo)) {
            return new AckNack(queryInfo.getQueryID(), StatusCode.UntrustedQuerier);
        }
        AckNack ackNack = new AckNack(queryInfo.getQueryID(), new StatusCode[0]);
        try {
            AckNack broadcastAckNack;
            this.addRoutedByEntry(queryInfo);
            int tentativeNumChildren = this.getNumChildren(queryInfo);
            this.expectResponse(queryInfo, this.getStatuses(), tentativeNumChildren);
            if (this.nodeConfig.isBroadcaster() && tentativeNumChildren > 0 && (broadcastAckNack = this.broadcaster.broadcast(queryInfo, criteria)) != null) {
                ackNack.addStatuses(broadcastAckNack.getStatuses());
            }
            if (this.nodeConfig.isQueryable()) {
                ackNack.addStatus(StatusCode.QueryStarted);
                this.executor.execute(new QueryOperation(this, queryInfo, criteria));
            }
            return ackNack;
        }
        catch (Exception e) {
            log.error((Object)Util.concat((Object[])new Object[]{"Node.query() failed for query ", queryInfo.getQueryID()}), (Throwable)e);
            ackNack.addStatus(StatusCode.QueryFailure);
            return ackNack;
        }
    }

    private final Collection<StatusCode> getStatuses() {
        EnumSet<StatusCode> statuses = EnumSet.noneOf(StatusCode.class);
        if (this.nodeConfig.isBroadcaster()) {
            statuses.add(StatusCode.BroadcastStarted);
        }
        if (this.nodeConfig.isQueryable()) {
            statuses.add(StatusCode.QueryStarted);
        }
        return statuses;
    }

    private final int getNumChildren(QueryInfo queryInfo) {
        return this.routingTable.get(queryInfo.getPeerGroup()).getChildren().size();
    }

    private boolean isDuplicateQuery(QueryInfo queryInfo) {
        return this.queryLog.getLogEntries(this.nodeID, queryInfo.getQueryID()).size() > 0;
    }

    private boolean logAuditTrail(QueryInfo queryInfo, String criteria) {
        try {
            this.queryLog.logAccessRequest(this.nodeID, queryInfo, criteria);
            return true;
        }
        catch (Throwable e) {
            log.error((Object)"Could not log access request, node must not proceed with any queries.", e);
            return false;
        }
    }

    private boolean neitherBroadcasterNorQueryable() {
        return !this.nodeConfig.isBroadcaster() && !this.nodeConfig.isQueryable();
    }

    private boolean hasUnkownQueryType(QueryInfo queryInfo) {
        return queryInfo.getQueryType() == null || !this.queryMapContext.getQueryTypes().contains(queryInfo.getQueryType());
    }

    private boolean hasBadPeerGroup(QueryInfo queryInfo) {
        return queryInfo.getPeerGroup() == null || !this.routingTable.contains(queryInfo.getPeerGroup());
    }

    private void addRoutedByEntry(QueryInfo queryInfo) {
        queryInfo.getRoutedByNodes().add(this.nodeID);
    }

    public String doQueryAction(QueryInfo queryInfo, String criteriaXML) throws QueryException {
        String queryID = queryInfo.getQueryID();
        try {
            if (DEBUG) {
                log.debug((Object)("Looking up query action for " + queryInfo.getQueryType()));
            }
            QueryAction<?> queryAction = this.queryMapContext.getQueryAction(queryInfo.getQueryType());
            if (DEBUG) {
                log.debug((Object)("Checking ready status for " + queryInfo.getQueryType()));
            }
            if (!queryAction.isReady()) {
                throw new QueryException("query (" + queryAction.getClass().getSimpleName() + ") not performed, QueryAction was not ready.  Perhaps it requires booting?");
            }
            if (DEBUG) {
                log.debug((Object)("Performing query " + queryInfo.getQueryType() + " " + queryInfo.getQueryID()));
            }
            String result = queryAction.perform(criteriaXML, queryInfo.getIdentity());
            this.queryLog.logQueryCompletion(this.nodeID, queryID, QueryStatus.Success);
            return result;
        }
        catch (QueryException e) {
            this.queryLog.logQueryCompletion(this.nodeID, queryID, QueryStatus.Failure);
            throw e;
        }
        catch (Exception e) {
            this.queryLog.logQueryCompletion(this.nodeID, queryID, QueryStatus.Failure);
            throw new QueryException("Error performing query", e);
        }
    }

    private boolean checkDigitalSignature(QueryInfo queryInfo) {
        boolean valid;
        if (DEBUG) {
            log.debug((Object)"Checking Digital Signature of investigator.");
        }
        Identity identity = queryInfo.getIdentity();
        NetworkTime now = new NetworkTime();
        NetworkTime timeValid = new NetworkTime(now).addMilliseconds(this.nodeConfig.getCertificationTTL());
        if (timeValid.before(now)) {
            String error = Util.concat((Object[])new Object[]{"Certification expired: queryID: ", queryInfo.getQueryID(), " TTL (in seconds): ", this.nodeConfig.getCertificationTTL(), " Expired timestamp: ", identity.getTimestamp(), " Now: ", now});
            log.error((Object)error);
            return false;
        }
        try {
            valid = XMLSignatureUtil.verifySignature((Identity)identity);
        }
        catch (XMLSignatureException e) {
            log.error((Object)Util.concat((Object[])new Object[]{"Failed Verification of digital signature for query ", queryInfo.getQueryID()}), (Throwable)e);
            return false;
        }
        if (!valid) {
            log.error((Object)Util.concat((Object[])new Object[]{"Failed Verification of digital signature for query ", queryInfo.getQueryID()}));
        }
        return valid;
    }

    public NodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    public RoutingTableConfig getRoutingTable() {
        return this.routingTable;
    }

    @Override
    @WebMethod
    public void initQuery(@WebParam(name="queryInfo") QueryInfo queryInfo) {
        this.cache.initQuery(queryInfo);
    }

    @Override
    @WebMethod
    public void aggregate(@WebParam(name="nodeID") CertID nodeID, @WebParam(name="queryInfo") QueryInfo queryInfo, @WebParam(name="result") String result) throws CacheException {
        EndpointDescriptor rootEndpointDescriptor;
        if (this.nodeConfig.isAggregator()) {
            this.cache.aggregate(nodeID, queryInfo, result);
        }
        try {
            rootEndpointDescriptor = this.getRootNodeEndpoint(queryInfo);
        }
        catch (NodeException e) {
            throw new CacheException((Throwable)e);
        }
        this.sendResults(rootEndpointDescriptor.endpoint, nodeID, rootEndpointDescriptor.getModifiedQueryInfo(queryInfo), result);
    }

    protected void sendResults(EndpointConfig endpoint, CertID nodeID, QueryInfo queryInfo, String responsePayload) {
        if (endpoint != null && responsePayload != null) {
            try {
                this.executor.execute(AggregateOperationFactory.getAggregateOperation(endpoint, nodeID, queryInfo, responsePayload));
            }
            catch (Exception e) {
                log.warn((Object)("Failed to aggregate results for query " + queryInfo.getQueryID()), (Throwable)e);
            }
        }
    }

    @Override
    @WebMethod
    public int countResponses(@WebParam(name="queryID") String queryID) throws CacheException, QueryNotFoundException {
        return this.cache.countResponses(queryID);
    }

    @Override
    @WebMethod
    public CacheEntry getResult(@WebParam(name="queryID") String queryID, @WebParam(name="requestorID") Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.cache.getResult(queryID, requestorID);
    }

    @Override
    @WebMethod
    public CacheEntry getResultNoDelete(@WebParam(name="queryID") String queryID, @WebParam(name="requestorID") Identity requestorID) throws CacheException, QueryNotFoundException {
        return this.cache.getResultNoDelete(queryID, requestorID);
    }

    @Override
    @WebMethod
    public boolean hasUpdate(@WebParam(name="queryID") String queryID, @WebParam(name="numResponsesSoFar") int numResponsesSoFar) throws CacheException, QueryNotFoundException {
        return this.cache.hasUpdate(queryID, numResponsesSoFar);
    }

    @Override
    @WebMethod
    public boolean isComplete(@WebParam(name="queryID") String queryID) throws CacheException, QueryNotFoundException {
        return this.cache.isComplete(queryID);
    }

    @Override
    @WebMethod
    public void expectResponse(@WebParam(name="queryInfo") QueryInfo queryInfo, @WebParam(name="statuses") Collection<StatusCode> statuses, @WebParam(name="numChildren") int numChildren) throws CacheException {
        Util.guardNotNull((Object)queryInfo);
        Util.guardNotNull(statuses);
        this.cache.expectResponse(queryInfo, statuses, numChildren);
        EndpointDescriptor rootEndpointDescriptor = null;
        try {
            rootEndpointDescriptor = this.getRootNodeEndpoint(queryInfo);
            this.sendAck(rootEndpointDescriptor.endpoint, this.nodeID, rootEndpointDescriptor.getModifiedQueryInfo(queryInfo), statuses, numChildren);
        }
        catch (NodeException e) {
            log.error((Object)Util.concat((Object[])new Object[]{"Error acking to node at ", rootEndpointDescriptor}), (Throwable)e);
        }
    }

    private void sendAck(EndpointConfig endpoint, CertID nodeID, QueryInfo queryInfo, Collection<StatusCode> statuses, int numChildren) throws NodeException {
        if (endpoint != null) {
            if (INFO) {
                log.info((Object)("Acking to node at " + endpoint));
            }
            this.executor.execute(AckOperationFactory.getAcker(endpoint, queryInfo, statuses, numChildren));
        } else if (DEBUG) {
            log.debug((Object)"No node to ack to, we must be the root");
        }
    }

    public QueryLogger getQueryLogger() {
        return this.queryLog;
    }

    public CertID getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(CertID nodeID) {
        this.nodeID = nodeID;
        this.cache.setNodeID(nodeID);
    }

    public QueryMap getQueryMapContext() {
        return this.queryMapContext;
    }

    public void destroy() {
        if (INFO) {
            log.info((Object)"Shutting down node....");
        }
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error((Object)"Interrupted waiting for jobs to finish, shutting down forcefully");
            this.executor.shutdownNow();
        }
        this.queryMapContext.destroy();
        if (INFO) {
            log.info((Object)"Node shut down.");
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(PKITool.getInstance().getMyCertID().getSerial());
    }

    protected static class EndpointDescriptor {
        protected final EndpointConfig endpoint;
        protected final Type type;

        protected EndpointDescriptor(EndpointConfig endpoint, Type type) {
            this.endpoint = endpoint;
            this.type = type;
        }

        protected QueryInfo getModifiedQueryInfo(QueryInfo queryInfo) {
            return this.type.getModifiedQueryInfo(queryInfo);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum Type {
            Parent,
            PeerGroupAggregator{

                protected QueryInfo getModifiedQueryInfo(QueryInfo queryInfo) {
                    QueryInfo copy = QueryInfo.copyOf((QueryInfo)queryInfo);
                    copy.setAggregator(null);
                    return copy;
                }
            };


            protected QueryInfo getModifiedQueryInfo(QueryInfo queryInfo) {
                return queryInfo;
            }
        }
    }
}

