/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.spin.node.actions.QueryAction;
import org.spin.node.actions.QueryException;
import org.spin.node.dataaccess.DataProvider;
import org.spin.node.dataaccess.transform.DataTypeTransformation;
import org.spin.node.dataaccess.transform.ResultTransformer;
import org.spin.node.dataaccess.transform.TypeConversionException;
import org.spin.node.output.OutputException;
import org.spin.node.output.ResultOutputter;
import org.spin.query.message.criteria.EncryptableCriteria;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadQueryAction<QueryCriteria extends EncryptableCriteria, LocalDataType, ClientResultType>
extends QueryAction<QueryCriteria> {
    private static final Logger log = Logger.getLogger(AbstractReadQueryAction.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private final DataProvider<QueryCriteria, LocalDataType> dataSource;
    private final ResultOutputter<ClientResultType, String> outputter;
    private final ResultTransformer<LocalDataType, ClientResultType> transformer;

    protected AbstractReadQueryAction(DataProvider<QueryCriteria, LocalDataType> dataSource, ResultOutputter<ClientResultType, String> outputter, DataTypeTransformation<LocalDataType, ClientResultType> transformation) {
        this.dataSource = dataSource;
        this.outputter = outputter;
        this.transformer = transformation.makeResultTransformer();
    }

    @Override
    public String doPerform(QueryCriteria queryCriteria, Identity identity) throws QueryException {
        try {
            List rawResults = this.dataSource.get(queryCriteria, identity);
            if (DEBUG) {
                log.debug((Object)("Got " + rawResults.size() + " data items from data source"));
            }
            List transformedResults = this.transformer.transform(rawResults);
            if (INFO) {
                log.info((Object)("Returning " + transformedResults.size() + " data items."));
            }
            return this.outputter.output(transformedResults);
        }
        catch (TypeConversionException e) {
            throw new QueryException("Query not performed: Error Converting to client's result Format: ", e);
        }
        catch (OutputException e) {
            throw new QueryException("Query not performed: Error Outputting XML: ", e);
        }
        catch (Throwable e) {
            throw new QueryException("Query not performed: ", e);
        }
    }
}

