/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.actions;

import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.spin.node.SerializationException;
import org.spin.node.SpinNodeImpl;
import org.spin.node.actions.QueryException;
import org.spin.query.message.criteria.EncryptableCriteria;
import org.spin.query.message.criteria.SpinCriteria;
import org.spin.query.message.headers.Result;
import org.spin.tools.JAXBUtils;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.Cryptor;
import org.spin.tools.crypto.NullCryptor;
import org.spin.tools.crypto.PKCryptor;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryAction<QueryCriteria extends EncryptableCriteria> {
    private static final Logger log = Logger.getLogger(QueryAction.class);
    private SpinNodeImpl enclosingNode;

    protected QueryAction() {
    }

    public void destroy() {
        this.enclosingNode = null;
    }

    public String perform(String queryCriteria, Identity identity) throws QueryException {
        try {
            CryptoParams cryptoParams = QueryAction.determineCryptoParams(queryCriteria);
            String results = cryptoParams.cryptor.encryptAndSign(this.doPerform(this.unmarshalCriteria(queryCriteria), identity), cryptoParams.encryptResultsFor);
            return new Result(this.getNodeID(), cryptoParams.shouldEncryptResults, results).toXML();
        }
        catch (Exception e) {
            throw new QueryException("Query not performed: ", e);
        }
    }

    private CertID getNodeID() {
        SpinNodeImpl node = this.getEnclosingNode();
        if (node != null) {
            return node.getNodeID();
        }
        return new CertID("0", "Unknown Node");
    }

    private static final CryptoParams determineCryptoParams(String queryCriteria) throws ConfigException {
        try {
            SpinCriteria encryptableCriteria = (SpinCriteria)JAXBUtils.unmarshal((String)queryCriteria, SpinCriteria.class);
            return new CryptoParams(QueryAction.selectCryptor((EncryptableCriteria)encryptableCriteria), encryptableCriteria.getShouldEncryptResults(), encryptableCriteria.getEncryptResultsFor());
        }
        catch (JAXBException e) {
            log.warn((Object)"Couldn't unmarshal criteria as XML to determine encryption parameters.  Falling back to no encryption");
            return CryptoParams.NoCrypto;
        }
    }

    private static final Cryptor selectCryptor(EncryptableCriteria encryptableCriteria) throws ConfigException {
        if (encryptableCriteria == null) {
            throw new ConfigException("Null EncryptableCriteria passed in");
        }
        return encryptableCriteria.getShouldEncryptResults() ? PKCryptorCache.pkCryptor() : NullCryptor.Instance;
    }

    protected abstract String doPerform(QueryCriteria var1, Identity var2) throws QueryException;

    public boolean isReady() {
        return true;
    }

    protected abstract QueryCriteria unmarshalCriteria(String var1) throws SerializationException;

    public SpinNodeImpl getEnclosingNode() {
        return this.enclosingNode;
    }

    public void setEnclosingNode(SpinNodeImpl enclosingNode) {
        this.enclosingNode = enclosingNode;
    }

    private static class PKCryptorCache {
        private static PKCryptor pkCryptor;

        private PKCryptorCache() {
        }

        private static final synchronized Cryptor pkCryptor() throws ConfigException {
            if (pkCryptor == null) {
                pkCryptor = new PKCryptor();
            }
            return pkCryptor;
        }
    }

    private static final class CryptoParams {
        public static final CryptoParams NoCrypto = new CryptoParams((Cryptor)NullCryptor.Instance, false, null);
        public final boolean shouldEncryptResults;
        public final Cryptor cryptor;
        public final CertID encryptResultsFor;

        public CryptoParams(Cryptor cryptor, boolean shouldEncryptResults, CertID encryptResultsFor) {
            this.shouldEncryptResults = shouldEncryptResults;
            this.cryptor = cryptor;
            this.encryptResultsFor = encryptResultsFor;
        }
    }
}

