/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.actions.discovery;

import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.spin.node.QueryMap;
import org.spin.node.SerializationException;
import org.spin.node.UnknownQueryTypeException;
import org.spin.node.actions.QueryAction;
import org.spin.node.actions.QueryException;
import org.spin.node.actions.discovery.DiscoveryCriteria;
import org.spin.node.actions.discovery.DiscoveryResult;
import org.spin.tools.JAXBUtils;
import org.spin.tools.PKITool;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.QueryTypeConfig;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiscoveryQueryAction
extends QueryAction<DiscoveryCriteria> {
    private static final Logger log = Logger.getLogger(DiscoveryQueryAction.class);

    @Override
    protected final String doPerform(DiscoveryCriteria queryCriteria, Identity identity) throws QueryException {
        this.sleepIfNecessary(queryCriteria);
        return this.getDiscoveryXML();
    }

    private void sleepIfNecessary(DiscoveryCriteria queryCriteria) {
        if (queryCriteria != null && queryCriteria.getSleepFor() > 0L) {
            try {
                Thread.sleep(queryCriteria.getSleepFor());
            }
            catch (InterruptedException e) {
                log.error((Object)"Could not sleep!");
            }
        }
    }

    private final DiscoveryResult makeDiscoveryResult() throws ConfigException, UnknownQueryTypeException {
        DiscoveryResult result = new DiscoveryResult();
        result.setNodeConfig(ConfigTool.loadNodeConfig());
        this.fillInQueryActionStates(result);
        result.setRoutingTable(ConfigTool.loadRoutingTableConfig());
        result.setX509Data(PKITool.getInstance().getMyX509());
        return result;
    }

    private final void fillInQueryActionStates(DiscoveryResult result) throws UnknownQueryTypeException {
        QueryMap node = this.getEnclosingNode().getQueryMapContext();
        if (node != null && result.getNodeConfig() != null) {
            for (QueryTypeConfig qtc : result.getNodeConfig().getQueries()) {
                String queryName = qtc.getQueryType();
                QueryAction<?> queryAction = node.getQueryAction(queryName);
                result.getQueryActionStates().put(queryName, DiscoveryQueryAction.getQueryActionState(queryAction));
            }
        }
    }

    private static final DiscoveryResult.QueryActionState getQueryActionState(QueryAction<?> queryAction) {
        if (queryAction == null) {
            return DiscoveryResult.QueryActionState.Unknown;
        }
        return DiscoveryResult.QueryActionState.valueOf(queryAction.isReady());
    }

    @Override
    protected final DiscoveryCriteria unmarshalCriteria(String queryCriteria) throws SerializationException {
        try {
            return (DiscoveryCriteria)((Object)JAXBUtils.unmarshal((String)queryCriteria, DiscoveryCriteria.class));
        }
        catch (JAXBException e) {
            throw new SerializationException(e);
        }
    }

    public final String getDiscoveryXML() {
        try {
            return JAXBUtils.marshalToString((Object)this.makeDiscoveryResult());
        }
        catch (Exception e) {
            log.error((Object)"Error getting leaf config: ", (Throwable)e);
            return "";
        }
    }
}

