/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.actions.write;

import java.util.List;
import org.spin.node.actions.QueryAction;
import org.spin.node.actions.QueryException;
import org.spin.node.dataaccess.DataSink;
import org.spin.node.dataaccess.DataSinkException;
import org.spin.node.dataaccess.types.Payload;
import org.spin.query.message.criteria.EncryptableCriteria;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWriteQueryAction<DataType, QueryPayload extends Payload<DataType> & EncryptableCriteria>
extends QueryAction<QueryPayload> {
    protected final DataSink dataSink;
    protected final WriteOperation operation;

    protected AbstractWriteQueryAction(DataSink dataSink, WriteOperation operation) {
        this.dataSink = dataSink;
        this.operation = operation;
    }

    @Override
    public String doPerform(QueryPayload payload, Identity identity) throws QueryException {
        try {
            this.operation.perform(this.dataSink, payload.getPayload());
        }
        catch (DataSinkException e) {
            throw new QueryException("Query not performed: error persisting query payload");
        }
        return "";
    }

    public final WriteOperation getOperation() {
        return this.operation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Delete
    implements WriteOperation {
        public static final Update Instance = new Update();

        private Delete() {
        }

        @Override
        public void perform(DataSink dataSink, List<?> data) throws DataSinkException {
            dataSink.delete(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Update
    implements WriteOperation {
        public static final Update Instance = new Update();

        private Update() {
        }

        @Override
        public void perform(DataSink dataSink, List<?> data) throws DataSinkException {
            dataSink.update(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Save
    implements WriteOperation {
        public static final Save Instance = new Save();

        private Save() {
        }

        @Override
        public void perform(DataSink dataSink, List<?> data) throws DataSinkException {
            dataSink.save(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface WriteOperation {
        public void perform(DataSink var1, List<?> var2) throws DataSinkException;
    }
}

