/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.aggregation;

import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.RunnableNodeOperation;
import org.spin.node.aggregation.AggregateOperationParams;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.cache.CacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateOperation
extends RunnableNodeOperation<AggregateOperationParams> {
    private static final Logger log = Logger.getLogger(AggregateOperation.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    public AggregateOperation(NodeConnector nodeConnector, AggregateOperationParams params) throws NodeException {
        super(nodeConnector, params);
        if (params.queryInfo == null) {
            throw new NodeException("Null QueryInfo passed in");
        }
        if (params.responsePayload == null) {
            throw new NodeException("Null response payload passed in");
        }
    }

    @Override
    public void run() {
        try {
            if (DEBUG) {
                log.debug((Object)("Aggregating to node: " + this.nodeConnector.getNodeName()));
            }
            this.nodeConnector.aggregate(((AggregateOperationParams)this.params).nodeID, ((AggregateOperationParams)this.params).queryInfo, ((AggregateOperationParams)this.params).responsePayload);
            if (DEBUG) {
                log.debug((Object)("Done aggregating to node: " + this.nodeConnector.getNodeName()));
            }
        }
        catch (CacheException e) {
            log.error((Object)("Error aggregating to node: " + this.nodeConnector.getNodeName()), (Throwable)e);
        }
    }
}

