/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.aggregation;

import java.net.MalformedURLException;
import java.net.URL;
import org.spin.node.NodeException;
import org.spin.node.NodeOperationFactory;
import org.spin.node.NodeOperationMaker;
import org.spin.node.aggregation.AggregateOperation;
import org.spin.node.aggregation.AggregateOperationParams;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.headers.QueryInfo;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.crypto.signature.CertID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateOperationFactory
extends NodeOperationFactory<AggregateOperation, AggregateOperationParams> {
    public static final AggregateOperationFactory Instance = new AggregateOperationFactory();

    private AggregateOperationFactory() {
        this.addMapping(EndpointType.SOAP, new NodeOperationMaker<AggregateOperation, AggregateOperationParams>(){

            @Override
            public AggregateOperation makeOperation(EndpointConfig endpoint, AggregateOperationParams params) throws NodeException {
                URL endpointURL;
                try {
                    endpointURL = endpoint.toURL();
                }
                catch (MalformedURLException e) {
                    throw new NodeException(e);
                }
                return new AggregateOperation(NodeConnector.instance(endpointURL), params);
            }
        });
    }

    public static void addMappingForEndpointType(EndpointType endpointType, NodeOperationMaker<AggregateOperation, AggregateOperationParams> threadMaker) {
        Instance.addMapping(endpointType, threadMaker);
    }

    public static final AggregateOperation getAggregateOperation(EndpointConfig endpoint, CertID nodeID, QueryInfo queryInfo, String responsePayload) throws NodeException {
        return AggregateOperationFactory.getAggregateOperation(endpoint, new AggregateOperationParams(nodeID, queryInfo, responsePayload));
    }

    public static final AggregateOperation getAggregateOperation(EndpointConfig endpoint, AggregateOperationParams params) throws NodeException {
        if (endpoint == null) {
            throw new NodeException("Null EndpointConfig passed in");
        }
        EndpointType type = endpoint.getEndpointType();
        if (AggregateOperationFactory.Instance.jobMakers.containsKey(type)) {
            return (AggregateOperation)((NodeOperationMaker)AggregateOperationFactory.Instance.jobMakers.get(type)).makeOperation(endpoint, params);
        }
        throw new NodeException("Unknown endpoint type: '" + endpoint.getEndpointType() + "'");
    }
}

