/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.broadcast;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.NodeOperationFactory;
import org.spin.node.NodeOperationMaker;
import org.spin.node.broadcast.BroadcastOperation;
import org.spin.node.broadcast.BroadcastOperationParams;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.headers.QueryInfo;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastOperationFactory
extends NodeOperationFactory<BroadcastOperation, BroadcastOperationParams> {
    private static final Logger log = Logger.getLogger(BroadcastOperationFactory.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    public static final BroadcastOperationFactory Instance = new BroadcastOperationFactory();

    protected BroadcastOperationFactory() {
        this.addMapping(EndpointType.SOAP, new NodeOperationMaker<BroadcastOperation, BroadcastOperationParams>(){

            @Override
            public BroadcastOperation makeOperation(EndpointConfig endpoint, BroadcastOperationParams params) throws NodeException {
                URL endpointURL;
                try {
                    endpointURL = endpoint.toURL();
                }
                catch (MalformedURLException e) {
                    throw new NodeException(e);
                }
                return new BroadcastOperation(NodeConnector.instance(endpointURL), params);
            }
        });
    }

    public static void addMappingForEndpointType(EndpointType endpointType, NodeOperationMaker<BroadcastOperation, BroadcastOperationParams> threadMaker) {
        Instance.addMapping(endpointType, threadMaker);
        if (DEBUG) {
            log.debug((Object)"Allowed Broadcast methods: ");
            for (EndpointType type : Instance.registeredEndpointTypes()) {
                log.debug((Object)("  '" + type + "' => " + BroadcastOperationFactory.Instance.jobMakers.get(type)));
            }
        }
    }

    public static final BroadcastOperation getBroadcastOperation(EndpointConfig endpoint, QueryInfo queryInfo, String criteria) throws NodeException {
        return BroadcastOperationFactory.getBroadcastOperation(endpoint, new BroadcastOperationParams(queryInfo, criteria));
    }

    public static final BroadcastOperation getBroadcastOperation(EndpointConfig endpoint, BroadcastOperationParams params) throws NodeException {
        if (endpoint == null) {
            throw new NodeException("Null EndpointConfig passed in");
        }
        EndpointType type = endpoint.getEndpointType();
        if (DEBUG) {
            log.debug((Object)("Making thread for method: '" + type + "'"));
        }
        if (BroadcastOperationFactory.Instance.jobMakers.containsKey(type)) {
            return (BroadcastOperation)((NodeOperationMaker)BroadcastOperationFactory.Instance.jobMakers.get(type)).makeOperation(endpoint, params);
        }
        throw new NodeException("Unknown endpoint type: '" + endpoint.getEndpointType() + "'");
    }
}

