/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.broadcast;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.spin.node.ExpectationSetter;
import org.spin.node.NodeException;
import org.spin.node.acknack.AckNack;
import org.spin.node.broadcast.BroadcastException;
import org.spin.node.broadcast.BroadcastOperationFactory;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.StatusCode;
import org.spin.query.message.headers.QueryInfo;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.RoutingTableConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Broadcaster {
    private static final Logger log = Logger.getLogger(Broadcaster.class);
    private final ExecutorService executor;
    private final RoutingTableConfig routingTable;
    private final ExpectationSetter expectationSetter;

    public Broadcaster(ExecutorService executor, ExpectationSetter expectationSetter) throws ConfigException {
        this(executor, ConfigTool.loadRoutingTableConfig(), expectationSetter);
    }

    public Broadcaster(ExecutorService executor, RoutingTableConfig routingTable, ExpectationSetter expectationSetter) throws ConfigException {
        if (routingTable == null) {
            throw new ConfigException("Null routing table passed in");
        }
        if (executor == null) {
            throw new ConfigException("Null java.util.concurrent.ExecutorService passed in");
        }
        if (expectationSetter == null) {
            throw new ConfigException("Null ExpectationSetter passed in");
        }
        this.executor = executor;
        this.routingTable = routingTable;
        this.expectationSetter = expectationSetter;
    }

    public AckNack broadcast(QueryInfo queryInfo, String criteria) throws BroadcastException {
        String peerGroup = queryInfo.getPeerGroup();
        if (peerGroup == null || !this.routingTable.contains(peerGroup)) {
            return new AckNack(queryInfo.getQueryID(), StatusCode.UnknownPeergroup);
        }
        List children = this.routingTable.get(peerGroup).getChildren();
        ArrayList handles = Util.makeArrayList((int)children.size());
        for (EndpointConfig endpoint : children) {
            try {
                handles.add(this.fireQueryToChild(endpoint, queryInfo, criteria));
            }
            catch (BroadcastException e) {
                log.error((Object)Util.concat((Object[])new Object[]{"Error broadcasting to node at '", endpoint.getAddress(), "' using method '", endpoint.getEndpointType(), "'"}), (Throwable)e);
            }
        }
        int numSuccessful = this.getNumSuccessfulChildren(handles);
        try {
            this.expectationSetter.expectChildren(queryInfo, numSuccessful);
        }
        catch (CacheException e) {
            throw new BroadcastException(Util.concat((Object[])new Object[]{"Error informing enclosing node of sucessful broadcast to ", numSuccessful, " children (out of ", children.size(), " possible)"}));
        }
        return new AckNack(queryInfo.getQueryID(), StatusCode.BroadcastStarted);
    }

    private final int getNumSuccessfulChildren(List<Future<AckNack>> childHandles) {
        int numSuccessfulChildren = 0;
        for (Future<AckNack> handle : childHandles) {
            try {
                AckNack broadcastResult = handle.get();
                if (!broadcastResult.isOk()) continue;
                ++numSuccessfulChildren;
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {}
        }
        return numSuccessfulChildren;
    }

    private final Future<AckNack> fireQueryToChild(EndpointConfig endpoint, QueryInfo queryInfo, String criteria) throws BroadcastException {
        try {
            return this.executor.submit(BroadcastOperationFactory.getBroadcastOperation(endpoint, queryInfo, criteria));
        }
        catch (NodeException e) {
            throw new BroadcastException(e);
        }
    }
}

