/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.connector;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.SPINWebserviceConstants;
import org.spin.node.SpinNode;
import org.spin.node.acknack.AckNack;
import org.spin.node.actions.QueryException;
import org.spin.query.message.cache.CacheEntry;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.cache.StatusCode;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.PKITool;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeConnector
implements SpinNode {
    private static final Logger log = Logger.getLogger(NodeConnector.class);
    private static final boolean INFO = log.isInfoEnabled();
    private final String nodeName;

    private NodeConnector(String nodeName) throws NodeException {
        if (nodeName == null) {
            throw new NodeException("Null node name passed in");
        }
        this.nodeName = nodeName;
    }

    public static final NodeConnector instance(String nodeWSDLURL) throws NodeException {
        if (nodeWSDLURL == null) {
            throw new NodeException("Null Node URL passed in");
        }
        return new LazyLoadingJAXWSNodeConnector(nodeWSDLURL);
    }

    public static final NodeConnector instance(URL nodeWSDLURL) throws NodeException {
        if (nodeWSDLURL == null) {
            throw new NodeException("Null Node URL passed in");
        }
        return new LazyLoadingJAXWSNodeConnector(nodeWSDLURL);
    }

    public static final NodeConnector instance(SpinNode node) throws NodeException {
        if (node == null) {
            throw new NodeException("Null Node passed in");
        }
        return new DefensiveCopyNodeConnector(node);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    protected static final <E extends Throwable> void rethrow(Class<E> exceptionClassToThrow, String message, Exception e) throws E {
        try {
            throw (Throwable)ClassTools.createInstance(exceptionClassToThrow, (Class[])Holder.ExceptionConstructorParamTypes, (Object[])new Object[]{message, e});
        }
        catch (DynamicLoadingException dle) {
            throw new RuntimeException(e);
        }
    }

    private static final class Holder {
        private static final Class<?>[] ExceptionConstructorParamTypes = new Class[]{String.class, Throwable.class};

        private Holder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefensiveCopyNodeConnector
    extends NodeConnector {
        protected SpinNode node;

        private DefensiveCopyNodeConnector(SpinNode node) throws NodeException {
            this(node, "localhost");
        }

        private DefensiveCopyNodeConnector(SpinNode node, String nodeName) throws NodeException {
            super(nodeName);
            if (node == null) {
                throw new NodeException("Null SpinNode passed in");
            }
            this.node = node;
        }

        @Override
        public void aggregate(CertID nodeID, QueryInfo queryInfo, String resultData) throws CacheException {
            this.node.aggregate(nodeID, QueryInfo.copyOf((QueryInfo)queryInfo), resultData);
        }

        @Override
        public Identity certify(String username, String password, String role) throws IdentityServiceException {
            return this.node.certify(username, password, role);
        }

        @Override
        public int countResponses(String queryID) throws CacheException, QueryNotFoundException {
            return this.node.countResponses(queryID);
        }

        @Override
        public void expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, int numChildren) throws CacheException {
            this.node.expectResponse(QueryInfo.copyOf((QueryInfo)queryInfo), EnumSet.copyOf(statuses), numChildren);
        }

        @Override
        public CacheEntry getResult(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
            return this.node.getResult(queryID, Identity.copyOf((Identity)requestorID));
        }

        @Override
        public CacheEntry getResultNoDelete(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
            return this.node.getResultNoDelete(queryID, Identity.copyOf((Identity)requestorID));
        }

        @Override
        public boolean hasUpdate(String queryID, int numResponders) throws CacheException, QueryNotFoundException {
            return this.node.hasUpdate(queryID, numResponders);
        }

        @Override
        public void initQuery(QueryInfo queryInfo) {
            this.node.initQuery(QueryInfo.copyOf((QueryInfo)queryInfo));
        }

        @Override
        public boolean isComplete(String queryID) throws CacheException, QueryNotFoundException {
            return this.node.isComplete(queryID);
        }

        @Override
        public AckNack query(QueryInfo queryInfo, String criteria) throws QueryException {
            return this.node.query(QueryInfo.copyOf((QueryInfo)queryInfo), criteria);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LazyLoadingJAXWSNodeConnector
    extends NodeConnector {
        private final String nodeWSDLURLAsString;
        private URL nodeWSDLURL;
        private SpinNode node;
        private static final Map<URL, SpinNode> cache = Util.makeHashMap();

        private LazyLoadingJAXWSNodeConnector(String nodeWSDLURL) throws NodeException {
            super(nodeWSDLURL);
            this.nodeWSDLURLAsString = nodeWSDLURL;
            this.nodeWSDLURL = null;
        }

        private LazyLoadingJAXWSNodeConnector(URL nodeWSDLURL) throws NodeException {
            super(String.valueOf(nodeWSDLURL));
            if (nodeWSDLURL == null) {
                throw new NodeException("Null node WSDL URL passed in");
            }
            this.nodeWSDLURLAsString = nodeWSDLURL.toString();
            this.nodeWSDLURL = nodeWSDLURL;
        }

        private final synchronized <E extends Throwable> void lazyLoadWSDLIfNecessary(Class<E> exceptionClassToThrow) throws E {
            if (this.node == null) {
                if (this.nodeWSDLURL == null) {
                    try {
                        this.nodeWSDLURL = new URL(this.nodeWSDLURLAsString);
                    }
                    catch (MalformedURLException e) {
                        LazyLoadingJAXWSNodeConnector.rethrow(exceptionClassToThrow, Util.concat((Object[])new Object[]{"Malformed URL: '", this.nodeWSDLURLAsString, "', cannot connect to WSDL using JAXWS"}), e);
                    }
                }
                try {
                    this.node = LazyLoadingJAXWSNodeConnector.getSpinNode(this.nodeWSDLURL);
                }
                catch (NodeException e) {
                    LazyLoadingJAXWSNodeConnector.rethrow(exceptionClassToThrow, Util.concat((Object[])new Object[]{"Error connecting to Node at URL: '", this.nodeWSDLURLAsString, "'"}), e);
                }
            }
        }

        private static final SpinNode getAndCacheSpinNode(URL nodeWSDLURL) throws NodeException {
            if (!cache.containsKey(nodeWSDLURL)) {
                cache.put(nodeWSDLURL, LazyLoadingJAXWSNodeConnector.getSpinNode(nodeWSDLURL));
            }
            return cache.get(nodeWSDLURL);
        }

        private static final SpinNode getSpinNode(URL nodeWSDLURL) throws NodeException {
            if (nodeWSDLURL == null) {
                throw new NodeException("Null Node URL passed in");
            }
            LazyLoadingJAXWSNodeConnector.initializeKeystoreForSSL();
            try {
                Service service = Service.create((URL)nodeWSDLURL, (QName)SPINWebserviceConstants.QserviceName);
                return (SpinNode)service.getPort(SPINWebserviceConstants.QportName, SpinNode.class);
            }
            catch (RuntimeException e) {
                throw new NodeException("Error connecting to JAXWS URL " + nodeWSDLURL, e);
            }
        }

        private static final void initializeKeystoreForSSL() throws NodeException {
            try {
                PKITool.getInstance();
            }
            catch (ConfigException e) {
                throw new NodeException("Failed to initialize Keystore (PKITool) for NodeConnector!");
            }
        }

        public synchronized Identity sign(Identity identity) throws IdentityServiceException {
            throw new IdentityServiceException("Signing not implemented");
        }

        @Override
        public synchronized Identity certify(String domain, String username, String password) throws IdentityServiceException {
            this.lazyLoadWSDLIfNecessary(IdentityServiceException.class);
            return this.node.certify(domain, username, password);
        }

        @Override
        public synchronized AckNack query(QueryInfo queryInfo, String criteria) throws QueryException {
            this.lazyLoadWSDLIfNecessary(QueryException.class);
            return this.node.query(queryInfo, criteria);
        }

        @Override
        public synchronized void initQuery(QueryInfo queryInfo) {
            this.lazyLoadWSDLIfNecessary(RuntimeException.class);
            this.node.initQuery(queryInfo);
        }

        @Override
        public synchronized void aggregate(CertID nodeID, QueryInfo queryInfo, String resultData) throws CacheException {
            this.lazyLoadWSDLIfNecessary(CacheException.class);
            this.node.aggregate(nodeID, queryInfo, resultData);
        }

        @Override
        public synchronized int countResponses(String queryID) throws CacheException, QueryNotFoundException {
            this.lazyLoadWSDLIfNecessary(CacheException.class);
            return this.node.countResponses(queryID);
        }

        @Override
        public synchronized CacheEntry getResult(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
            this.lazyLoadWSDLIfNecessary(CacheException.class);
            return this.node.getResult(queryID, requestorID);
        }

        @Override
        public synchronized CacheEntry getResultNoDelete(String queryID, Identity requestorID) throws CacheException, QueryNotFoundException {
            this.lazyLoadWSDLIfNecessary(CacheException.class);
            return this.node.getResultNoDelete(queryID, requestorID);
        }

        @Override
        public synchronized boolean hasUpdate(String queryID, int numResponders) throws CacheException, QueryNotFoundException {
            this.lazyLoadWSDLIfNecessary(CacheException.class);
            return this.node.hasUpdate(queryID, numResponders);
        }

        @Override
        public synchronized boolean isComplete(String queryID) throws CacheException, QueryNotFoundException {
            this.lazyLoadWSDLIfNecessary(CacheException.class);
            return this.node.isComplete(queryID);
        }

        @Override
        public synchronized void expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, int numChildren) throws CacheException {
            this.lazyLoadWSDLIfNecessary(CacheException.class);
            this.node.expectResponse(queryInfo, statuses, numChildren);
        }
    }
}

