/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.logging;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.spin.node.actions.QueryException;
import org.spin.node.dataaccess.DataAccess;
import org.spin.node.dataaccess.DataSinkException;
import org.spin.node.dataaccess.hibernate.LogEntryHibernateDataAccess;
import org.spin.node.dataaccess.types.LogEntry;
import org.spin.query.message.criteria.SPINLogCriteria;
import org.spin.query.message.headers.QueryInfo;
import org.spin.tools.config.QueryStatus;
import org.spin.tools.crypto.signature.CertID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryLogger {
    private static final Logger log = Logger.getLogger(QueryLogger.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private final DataAccess<SPINLogCriteria, LogEntry> dataAccess;

    public QueryLogger() {
        this((DataAccess<SPINLogCriteria, LogEntry>)new LogEntryHibernateDataAccess());
    }

    public QueryLogger(DataAccess<SPINLogCriteria, LogEntry> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void logAccessRequest(CertID nodeID, QueryInfo queryInfo, String queryCriteria) throws QueryException {
        if (nodeID == null) {
            throw new QueryException("Null nodeID passed in");
        }
        if (queryInfo == null) {
            throw new QueryException("Null queryInfo passed in");
        }
        if (queryCriteria == null) {
            throw new QueryException("Null query criteria passed in");
        }
        if (DEBUG) {
            log.debug((Object)("Logging query: " + queryInfo.getQueryID()));
            log.debug((Object)("Logging query type: " + queryInfo.getQueryType()));
            log.debug((Object)("Identity: " + queryInfo.getIdentity()));
            log.debug((Object)("Criteria: " + queryCriteria));
        }
        LogEntry entry = new LogEntry(nodeID, queryInfo, queryCriteria, false);
        try {
            this.dataAccess.save(Arrays.asList(entry));
            if (DEBUG) {
                log.debug((Object)("Logged query for nodeID " + nodeID + " and queryID '" + queryInfo.getQueryID() + "'"));
            }
        }
        catch (DataSinkException e) {
            throw new QueryException("Could not log queryID " + queryInfo.getQueryID(), e);
        }
    }

    public void logQueryCompletion(LogEntry logEntry, QueryStatus completionStatus) throws QueryException {
        QueryLogger.fillInCompletionFields(logEntry, completionStatus);
        this.dataAccess.saveOrUpdate(Arrays.asList(logEntry));
    }

    public void logQueryCompletion(CertID nodeID, String queryID, QueryStatus completionStatus) throws QueryException {
        List logEntries;
        if (DEBUG) {
            log.debug((Object)("Marking log entry with nodeID " + nodeID + " and queryID '" + queryID + "' as " + completionStatus));
        }
        if ((logEntries = this.dataAccess.get((Object)QueryLogger.makeCriteria(nodeID, queryID), null)) == null || logEntries.size() < 1) {
            throw new QueryException("Couldn't find existing log entry for query " + queryID + ", did logging at query-receipt-time succeed?");
        }
        LogEntry entry = (LogEntry)logEntries.get(0);
        QueryLogger.fillInCompletionFields(entry, completionStatus);
        this.dataAccess.update(Arrays.asList(entry));
    }

    public List<LogEntry> getLogEntries(CertID nodeID, String queryID) {
        return this.dataAccess.get((Object)QueryLogger.makeCriteria(nodeID, queryID), null);
    }

    private static final void fillInCompletionFields(LogEntry entry, QueryStatus completionStatus) {
        entry.setCompletedDate(new Date());
        entry.setCompletionStatus(completionStatus);
    }

    private static final SPINLogCriteria makeCriteria(CertID nodeID, String queryID) {
        SPINLogCriteria result = new SPINLogCriteria();
        result.getNodeIDList().add(nodeID);
        result.getQueryIDList().add(queryID);
        return result;
    }
}

