/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess;

import java.util.Collection;
import org.spin.node.dataaccess.DataSink;
import org.spin.node.dataaccess.DataSinkException;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyLoadingDataSink
implements DataSink {
    private final Class<? extends DataSink> delegateClass;
    private DataSink delegate;

    protected LazyLoadingDataSink(Class<? extends DataSink> delegateClass) {
        this.delegateClass = delegateClass;
    }

    @Override
    public void delete(Collection<?> data) throws DataSinkException {
        this.initDelegate();
        this.delegate.delete(data);
    }

    @Override
    public void save(Collection<?> data) throws DataSinkException {
        this.initDelegate();
        this.delegate.save(data);
    }

    @Override
    public void update(Collection<?> data) throws DataSinkException {
        this.initDelegate();
        this.delegate.update(data);
    }

    @Override
    public void saveOrUpdate(Collection<?> data) throws DataSinkException {
        this.initDelegate();
        this.delegate.saveOrUpdate(data);
    }

    private final synchronized void initDelegate() throws DataSinkException {
        if (this.delegate == null) {
            try {
                this.delegate = (DataSink)ClassTools.createInstance(this.delegateClass);
            }
            catch (DynamicLoadingException e) {
                throw new DataSinkException(e);
            }
        }
    }
}

