/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.codebook;

import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.spin.node.dataaccess.codebook.CodebookEntry;
import org.spin.node.dataaccess.codebook.CodebookException;
import org.spin.node.dataaccess.codebook.CodebookHibernateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Codebook {
    private static final Logger log = Logger.getLogger(Codebook.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static SessionFactory sessionFactory;

    public Codebook() {
        sessionFactory = CodebookHibernateUtil.getSessionFactory();
    }

    public Codebook(String codebookName) {
        sessionFactory = CodebookHibernateUtil.getSessionFactory(codebookName);
    }

    public Codebook(URL codebookConfigFile) {
        sessionFactory = CodebookHibernateUtil.getSessionFactory(codebookConfigFile);
    }

    public boolean exists(String key, String value) throws CodebookException {
        return this.getFirst(key, value) != null;
    }

    public boolean codebookIDExists(String codebookID) throws CodebookException {
        return this.exists(Key.codebookID.name(), codebookID);
    }

    public boolean UUIDExists(String UUID) throws CodebookException {
        return this.exists(Key.UUID.name(), UUID);
    }

    public boolean MRNExists(String MRN) throws CodebookException {
        return this.exists(Key.MRN.name(), MRN);
    }

    public List<CodebookEntry> get(String column, String value) throws CodebookException {
        Session session = sessionFactory.openSession();
        Criteria criteria = session.createCriteria(CodebookEntry.class).add((Criterion)Restrictions.eq((String)column, (Object)value));
        List results = criteria.list();
        session.close();
        return results;
    }

    public CodebookEntry getFirst(String column, String value) throws CodebookException {
        List<CodebookEntry> entries = this.get(column, value);
        return entries.size() == 0 ? null : entries.get(0);
    }

    public CodebookEntry getByCodebookID(String codebookID) throws CodebookException {
        return this.getFirst(Key.codebookID.name(), codebookID);
    }

    public CodebookEntry getByUUID(String deidentifiedUUID) throws CodebookException {
        return this.getFirst(Key.UUID.name(), deidentifiedUUID);
    }

    public List<CodebookEntry> getByMRN(String MRN) throws CodebookException {
        return this.get(Key.MRN.name(), MRN);
    }

    public List<CodebookEntry> getAll() {
        Session session = sessionFactory.openSession();
        Criteria criteria = session.createCriteria(CodebookEntry.class);
        List results = criteria.list();
        session.close();
        return results;
    }

    public void create(CodebookEntry entry) throws CodebookException {
        Session session = sessionFactory.openSession();
        try {
            session.beginTransaction();
            session.save((Object)entry);
            session.getTransaction().commit();
            if (DEBUG) {
                log.debug((Object)("Created entry " + entry.getUUID() + "with hash " + entry.getHashCode()));
            }
        }
        catch (RuntimeException e) {
            session.getTransaction().rollback();
            throw new CodebookException("Could not create codebook entry", e);
        }
        catch (Error e) {
            throw new CodebookException("Holy Fatal error batman!", e);
        }
        finally {
            session.close();
        }
    }

    public void update(CodebookEntry entry) throws CodebookException {
        Session session = sessionFactory.openSession();
        try {
            session.beginTransaction();
            session.update((Object)entry);
            session.getTransaction().commit();
        }
        catch (RuntimeException e) {
            session.getTransaction().rollback();
            throw new CodebookException("Could not update codebook entry", e);
        }
        finally {
            session.close();
        }
    }

    public void remove(String codebookId) throws CodebookException {
        CodebookEntry entry = new CodebookEntry();
        entry.setCodebookID(codebookId);
        this.remove(entry);
    }

    public void remove(CodebookEntry entry) throws CodebookException {
        Session session = sessionFactory.openSession();
        try {
            session.beginTransaction();
            session.delete((Object)entry);
            session.getTransaction().commit();
        }
        catch (RuntimeException e) {
            session.getTransaction().rollback();
            throw new CodebookException("Could not remove codebook entry", e);
        }
        finally {
            session.close();
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Key {
        MRN,
        codebookID,
        UUID;

    }
}

