/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.codebook;

import java.net.URL;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.spin.node.dataaccess.codebook.CodebookEntry;
import org.spin.node.dataaccess.hibernate.HibernateTool;
import org.spin.tools.Util;

public class CodebookHibernateUtil {
    public static final String codebookHibernateConfigFileName = "hibernate-codebook.cfg.xml";
    private static final List<Class<?>> annotations = Util.makeArrayList();

    private static final Configuration createConfiguration() {
        return HibernateTool.createConfiguration(codebookHibernateConfigFileName, annotations);
    }

    private static final Configuration createConfiguration(String codebookName) {
        return HibernateTool.createConfiguration(codebookName, annotations);
    }

    private static final Configuration createConfiguration(URL configurationFile) {
        return HibernateTool.createConfiguration(configurationFile, annotations);
    }

    public static SessionFactory getSessionFactory() {
        return CodebookHibernateUtil.getSessionFactory(codebookHibernateConfigFileName, CodebookHibernateUtil.createConfiguration());
    }

    public static SessionFactory getSessionFactory(URL configFile) {
        return CodebookHibernateUtil.getSessionFactory(configFile.getFile(), CodebookHibernateUtil.createConfiguration(configFile));
    }

    public static SessionFactory getSessionFactory(String codebookName) {
        return CodebookHibernateUtil.getSessionFactory(codebookName, CodebookHibernateUtil.createConfiguration(codebookName));
    }

    private static final SessionFactory getSessionFactory(String sessionName, Configuration configuration) {
        return HibernateTool.getSessionFactory(sessionName, configuration);
    }

    static {
        annotations.add(CodebookEntry.class);
    }
}

