/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.hibernate;

import java.util.Collection;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.spin.node.dataaccess.DataSink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateDataSink
implements DataSink {
    protected final SessionFactory sessionFactory;

    protected HibernateDataSink(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public final void save(Collection<?> data) {
        this.perform(SaveOperation.Instance, data);
    }

    @Override
    public final void update(Collection<?> data) {
        this.perform(UpdateOperation.Instance, data);
    }

    @Override
    public final void saveOrUpdate(Collection<?> data) {
        this.perform(SaveOrUpdateOperation.Instance, data);
    }

    @Override
    public final void delete(Collection<?> data) {
        this.perform(DeleteOperation.Instance, data);
    }

    private void perform(final HibernateWriteOperation operation, final Collection<?> data) {
        this.perform(OperationType.Write, new HibernateCommand<Object>(){

            @Override
            public List<Object> run(org.hibernate.Session session) {
                for (Object dataItem : data) {
                    operation.perform(session, dataItem);
                }
                return null;
            }
        });
    }

    @Deprecated
    protected <DataType> List<DataType> perform(HibernateCommand<DataType> command) {
        return this.perform(OperationType.Write, command);
    }

    protected <DataType> List<DataType> perform(OperationType operationType, HibernateCommand<DataType> command) {
        Session session = this.sessionFactory.openSession();
        try {
            session.setFlushMode(FlushMode.MANUAL);
            session.beginTransaction();
            List<DataType> results = command.run((org.hibernate.Session)session);
            if (operationType != null) {
                operationType.doPreCommitActions((org.hibernate.Session)session);
            }
            session.getTransaction().commit();
            List<DataType> list = results;
            return list;
        }
        catch (ConstraintViolationException e) {
            session.getTransaction().rollback();
            throw e;
        }
        catch (Throwable e) {
            session.getTransaction().rollback();
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    protected static class SaveOrUpdateOperation
    implements HibernateWriteOperation {
        public static final SaveOrUpdateOperation Instance = new SaveOrUpdateOperation();

        private SaveOrUpdateOperation() {
        }

        public void perform(org.hibernate.Session session, Object dataItem) throws HibernateException {
            session.saveOrUpdate(dataItem);
        }
    }

    private static class DeleteOperation
    implements HibernateWriteOperation {
        public static final DeleteOperation Instance = new DeleteOperation();

        private DeleteOperation() {
        }

        public void perform(org.hibernate.Session session, Object dataItem) throws HibernateException {
            session.delete(dataItem);
        }
    }

    private static class UpdateOperation
    implements HibernateWriteOperation {
        public static final UpdateOperation Instance = new UpdateOperation();

        private UpdateOperation() {
        }

        public void perform(org.hibernate.Session session, Object dataItem) throws HibernateException {
            session.update(dataItem);
        }
    }

    private static class SaveOperation
    implements HibernateWriteOperation {
        public static final SaveOperation Instance = new SaveOperation();

        private SaveOperation() {
        }

        public void perform(org.hibernate.Session session, Object dataItem) throws HibernateException {
            session.save(dataItem);
        }
    }

    protected static interface HibernateWriteOperation {
        public void perform(org.hibernate.Session var1, Object var2) throws HibernateException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface HibernateCommand<DataType> {
        public List<DataType> run(org.hibernate.Session var1) throws HibernateException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum OperationType {
        Read{

            public final void doPreCommitActions(org.hibernate.Session session) {
            }
        }
        ,
        Write{

            public final void doPreCommitActions(org.hibernate.Session session) {
                if (session != null) {
                    session.flush();
                }
            }
        };


        public abstract void doPreCommitActions(org.hibernate.Session var1);
    }
}

