/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.hibernate;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTool {
    private static final HashMap<String, SessionFactory> sessions = Util.makeHashMap();

    public static Configuration createConfiguration(String configFileName, List<Class<?>> persistableClasses) {
        try {
            return HibernateTool.createConfiguration(ConfigTool.getConfigFileAsURL((String)configFileName), persistableClasses);
        }
        catch (ConfigException e) {
            throw new RuntimeException("Could not create hibernate configuration.", e);
        }
    }

    public static Configuration createConfiguration(URL configurationFile, List<Class<?>> persistableClasses) {
        AnnotationConfiguration config = new AnnotationConfiguration();
        for (Class<?> clazz : persistableClasses) {
            config.addAnnotatedClass(clazz);
        }
        config.configure(configurationFile);
        return config;
    }

    public static SessionFactory getSessionFactory(URL configFile, List<Class<?>> annotations) {
        return HibernateTool.getSessionFactory(configFile.getFile(), HibernateTool.createConfiguration(configFile, annotations));
    }

    public static synchronized SessionFactory getSessionFactory(String sessionName, Configuration configuration) {
        if (!sessions.containsKey(sessionName)) {
            sessions.put(sessionName, configuration.buildSessionFactory());
        }
        return sessions.get(sessionName);
    }
}

