/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.hibernate;

import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.spin.node.dataaccess.hibernate.SpinAdminHibernateDataAccess;
import org.spin.node.dataaccess.types.LogEntry;
import org.spin.query.message.criteria.SPINLogCriteria;
import org.spin.tools.crypto.signature.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogEntryHibernateDataAccess
extends SpinAdminHibernateDataAccess<SPINLogCriteria, LogEntry> {
    @Override
    protected List<LogEntry> doGet(SPINLogCriteria queryCriteria, Identity ignored, Session session) {
        return LogEntryHibernateDataAccess.getWithRestrictions(session, LogEntry.class, new Criterion[]{LogEntryHibernateDataAccess.createRestrictions(queryCriteria)});
    }

    private static final Conjunction createRestrictions(SPINLogCriteria queryCriteria) {
        Conjunction conjunction = Restrictions.conjunction();
        LogEntryHibernateDataAccess.addReceivedDateRestrictions(queryCriteria, conjunction);
        LogEntryHibernateDataAccess.addCompletedDateRestrictions(queryCriteria, conjunction);
        LogEntryHibernateDataAccess.addAuthenticatorRestrictions(queryCriteria, conjunction);
        LogEntryHibernateDataAccess.addMembershipRestrictions(queryCriteria, conjunction);
        LogEntryHibernateDataAccess.addQueryIDRestrictions(queryCriteria, conjunction);
        LogEntryHibernateDataAccess.addNodeIDRestrictions(queryCriteria, conjunction);
        LogEntryHibernateDataAccess.addQueryTypeRestrictions(queryCriteria, conjunction);
        LogEntryHibernateDataAccess.addRoleRestrictions(queryCriteria, conjunction);
        LogEntryHibernateDataAccess.addUsernameRestrictions(queryCriteria, conjunction);
        LogEntryHibernateDataAccess.addStatusRestrictions(queryCriteria, conjunction);
        return conjunction;
    }

    private static final void addReceivedDateRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        if (queryCriteria.getReceivedStartDate() != null) {
            conjunction.add((Criterion)Restrictions.ge((String)"receivedDate", (Object)queryCriteria.getReceivedStartDate()));
        }
        if (queryCriteria.getReceivedEndDate() != null) {
            conjunction.add((Criterion)Restrictions.le((String)"receivedDate", (Object)queryCriteria.getReceivedEndDate()));
        }
    }

    private static final void addCompletedDateRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        if (queryCriteria.getCompletedStartDate() != null) {
            conjunction.add((Criterion)Restrictions.ge((String)"completedDate", (Object)queryCriteria.getCompletedStartDate()));
        }
        if (queryCriteria.getCompletedEndDate() != null) {
            conjunction.add((Criterion)Restrictions.le((String)"completedDate", (Object)queryCriteria.getCompletedEndDate()));
        }
    }

    private static final void addAuthenticatorRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        LogEntryHibernateDataAccess.addRestrictions("authenticator", queryCriteria.getAuthenticatorList(), conjunction);
    }

    private static final void addMembershipRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        LogEntryHibernateDataAccess.addRestrictions("membership", queryCriteria.getMembershipList(), conjunction);
    }

    private static final void addQueryIDRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        LogEntryHibernateDataAccess.addRestrictions("primaryKey.queryID", queryCriteria.getQueryIDList(), conjunction);
    }

    private static final void addNodeIDRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        LogEntryHibernateDataAccess.addRestrictions("primaryKey.nodeID", queryCriteria.getNodeIDList(), conjunction);
    }

    private static final void addQueryTypeRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        LogEntryHibernateDataAccess.addRestrictions("queryType", queryCriteria.getQueryTypeList(), conjunction);
    }

    private static final void addRoleRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        LogEntryHibernateDataAccess.addRestrictions("role", queryCriteria.getRoleList(), conjunction);
    }

    private static final void addUsernameRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        LogEntryHibernateDataAccess.addRestrictions("username", queryCriteria.getUsernameList(), conjunction);
    }

    private static final void addStatusRestrictions(SPINLogCriteria queryCriteria, Conjunction conjunction) {
        LogEntryHibernateDataAccess.addRestrictions("completionStatus", queryCriteria.getCompletionStatusList(), conjunction);
    }

    private static final void addRestrictions(String propertyName, List<?> values, Conjunction conjunction) {
        if (!values.isEmpty()) {
            Disjunction disjunction = Restrictions.disjunction();
            for (Object value : values) {
                disjunction.add((Criterion)Restrictions.eq((String)propertyName, value));
            }
            conjunction.add((Criterion)disjunction);
        }
    }
}

