/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.hibernate;

import java.net.URL;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.spin.node.dataaccess.types.LogEntry;
import org.spin.node.dataaccess.types.LogEntryPK;
import org.spin.tools.config.ConfigTool;

public class SpinAdminHibernateTool {
    public static final String spinHibernateConfigFileName = "hibernate-admin.cfg.xml";
    private static final Logger log = Logger.getLogger(SpinAdminHibernateTool.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final SessionFactory sessionFactory;
    private final String dbDriver;
    private final String dbUrl;
    private final String dataSourceName;
    public static final SpinAdminHibernateTool Instance = new SpinAdminHibernateTool();

    private SpinAdminHibernateTool() {
        this.addShutdownHook();
        try {
            URL configFile = ConfigTool.getConfigFileAsURL((String)spinHibernateConfigFileName);
            if (DEBUG) {
                log.debug((Object)("Initializing Hibernate with '" + configFile.getFile() + "'"));
            }
            Configuration config = new AnnotationConfiguration().addAnnotatedClass(LogEntry.class).addAnnotatedClass(LogEntryPK.class).configure(configFile);
            this.sessionFactory = config.buildSessionFactory();
            this.dbDriver = config.getProperty("connection.driver_class");
            this.dbUrl = config.getProperty("connection.url");
            this.dataSourceName = config.getProperty("connection.datasource");
        }
        catch (Throwable e) {
            log.error((Object)("Initial SessionFactory creation failed: " + e.getMessage()));
            throw new ExceptionInInitializerError(e);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    SpinAdminHibernateTool.this.shutDown();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed shutting down Spin query logging - the Node may take longer to start up next time, or the admin database may be corrupted: ", e);
                }
            }
        }));
    }

    public final SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final String getDBUrl() {
        return this.dbUrl;
    }

    public final String getDBDriver() {
        return this.dbDriver;
    }

    public final boolean shutDown() {
        this.shutdownHibernate();
        return this.shutdownDerby();
    }

    private boolean shutdownDerby() {
        try {
            Class.forName(this.getDBDriver());
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            log.error((Object)"Failed shutting down Spin admin database");
            return false;
        }
        catch (SQLException e) {
            if (INFO) {
                log.info((Object)"Successfully shut down Spin admin database");
            }
            return true;
        }
        catch (Throwable e) {
            log.error((Object)"Failed shutting down Spin admin database", e);
            return false;
        }
    }

    private void shutdownHibernate() {
        try {
            this.sessionFactory.close();
            if (INFO) {
                log.info((Object)"Shut down Spin Admin Hibernate SessionFactory");
            }
        }
        catch (HibernateException e) {
            log.error((Object)"Error shutting down Spin admin Hibernate SessionFactory");
            throw e;
        }
    }
}

