/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.dataaccess.transform;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.spin.node.dataaccess.transform.DataTypeTransformation;
import org.spin.node.dataaccess.transform.NullDataTypeTransformation;
import org.spin.node.dataaccess.transform.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultTransformer<Source, Dest> {
    private final DataTypeTransformation<Source, Dest> transformation;

    public ResultTransformer(DataTypeTransformation<Source, Dest> transformation) {
        this.transformation = transformation;
    }

    public List<Dest> transform(List<Source> sources) throws TypeConversionException {
        if (sources == null) {
            return new LinkedList();
        }
        ArrayList<Dest> result = new ArrayList<Dest>(sources.size());
        for (Source source : sources) {
            result.add(this.transformation.transform(source));
        }
        return result;
    }

    public static final <Source, Dest> ResultTransformer<Source, Dest> instance(DataTypeTransformation<Source, Dest> transformation) {
        return new ResultTransformer<Source, Dest>(transformation);
    }

    public static final <T> ResultTransformer<T, T> instance() {
        return new ResultTransformer(new NullDataTypeTransformation());
    }
}

